/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.query.collector.FieldCacheCollector;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class TwoWayTransformingFieldCacheCollector
extends FieldCacheCollector {
    private static final Logger log = LoggerFactory.make();
    private final TwoWayStringBridge stringBridge;
    private final FieldCacheCollector privateDelegate;

    public TwoWayTransformingFieldCacheCollector(FieldCacheCollector delegate, TwoWayStringBridge twoWayStringBridge) {
        super(delegate);
        this.privateDelegate = delegate;
        this.stringBridge = twoWayStringBridge;
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.delegate.setNextReader(reader, docBase);
    }

    public Object getValue(int docId) {
        String value = (String)this.privateDelegate.getValue(docId);
        if (value == null) {
            log.warn("unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.");
            return null;
        }
        return this.stringBridge.stringToObject(value);
    }
}

