/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorImpl
implements Iterator {
    private final List<EntityInfo> entityInfos;
    private int index = 0;
    private final int size;
    private Object next;
    private int nextObjectIndex = -1;
    private final Loader loader;

    public IteratorImpl(List<EntityInfo> entityInfos, Loader loader) {
        this.entityInfos = entityInfos;
        this.size = entityInfos.size();
        this.loader = loader;
    }

    @Override
    public boolean hasNext() {
        if (this.nextObjectIndex == this.index) {
            return this.next != null;
        }
        this.next = null;
        this.nextObjectIndex = -1;
        do {
            if (this.index >= this.size) {
                this.nextObjectIndex = this.index;
                this.next = null;
                return false;
            }
            this.next = this.loader.load(this.entityInfos.get(this.index));
            if (this.next == null) {
                ++this.index;
                continue;
            }
            this.nextObjectIndex = this.index;
        } while (this.next == null);
        return true;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        ++this.index;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a lucene query iterator");
    }
}

