/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.FieldLoadingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatFieldLoadingStrategy
implements FieldLoadingStrategy<Float> {
    private final String fieldName;
    private float[] currentCache;

    public FloatFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getFloats(reader, this.fieldName);
    }

    @Override
    public Float collect(int relativeDocId) {
        return Float.valueOf(this.currentCache[relativeDocId]);
    }
}

