/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache;

import org.hibernate.search.bridge.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.DoubleNumericFieldBridge;
import org.hibernate.search.bridge.builtin.FloatNumericFieldBridge;
import org.hibernate.search.bridge.builtin.IntegerNumericFieldBridge;
import org.hibernate.search.bridge.builtin.LongNumericFieldBridge;
import org.hibernate.search.query.fieldcache.FieldCollectorType;

public class ClassLoadingStrategySelector {
    public static FieldCollectorType guessAppropriateCollectorType(TwoWayFieldBridge idBridge) {
        if (idBridge instanceof NullEncodingTwoWayFieldBridge) {
            NullEncodingTwoWayFieldBridge encoding = (NullEncodingTwoWayFieldBridge)idBridge;
            return ClassLoadingStrategySelector.guessAppropriateCollectorType(encoding.unwrap());
        }
        if (idBridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return FieldCollectorType.STRING;
        }
        if (idBridge instanceof IntegerNumericFieldBridge) {
            return FieldCollectorType.INT;
        }
        if (idBridge instanceof LongNumericFieldBridge) {
            return FieldCollectorType.LONG;
        }
        if (idBridge instanceof DoubleNumericFieldBridge) {
            return FieldCollectorType.DOUBLE;
        }
        if (idBridge instanceof FloatNumericFieldBridge) {
            return FieldCollectorType.FLOAT;
        }
        return null;
    }

    public static TwoWayStringBridge getTwoWayStringBridge(TwoWayFieldBridge idBridge) {
        if (idBridge instanceof NullEncodingTwoWayFieldBridge) {
            NullEncodingTwoWayFieldBridge encoding = (NullEncodingTwoWayFieldBridge)idBridge;
            return ClassLoadingStrategySelector.getTwoWayStringBridge(encoding.unwrap());
        }
        if (idBridge instanceof TwoWayString2FieldBridgeAdaptor) {
            TwoWayString2FieldBridgeAdaptor adaptor = (TwoWayString2FieldBridgeAdaptor)idBridge;
            return adaptor.unwrap();
        }
        return null;
    }
}

