/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.facet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetRange<N extends Number> {
    private static final String MIN_INCLUDED = "[";
    private static final String MIN_EXCLUDED = "(";
    private static final String MAX_INCLUDED = "]";
    private static final String MAX_EXCLUDED = ")";
    private final N min;
    private final N max;
    private final boolean includeMin;
    private final boolean includeMax;
    private final String rangeString;

    public FacetRange(N min, N max) {
        this(min, max, true, true);
    }

    public FacetRange(N min, N max, boolean includeMin, boolean includeMax) {
        this.min = min;
        this.max = max;
        this.includeMax = includeMax;
        this.includeMin = includeMin;
        StringBuilder builder = new StringBuilder();
        if (includeMin) {
            builder.append(MIN_INCLUDED);
        } else {
            builder.append(MIN_EXCLUDED);
        }
        builder.append(min);
        builder.append(", ");
        builder.append(max);
        if (includeMax) {
            builder.append(MAX_INCLUDED);
        } else {
            builder.append(MAX_EXCLUDED);
        }
        this.rangeString = builder.toString();
    }

    public N getMin() {
        return this.min;
    }

    public N getMax() {
        return this.max;
    }

    public boolean isIncludeMin() {
        return this.includeMin;
    }

    public boolean isIncludeMax() {
        return this.includeMax;
    }

    public boolean isInRange(N value) {
        int minCheck = this.compare(this.min, value);
        if (this.isIncludeMin() && minCheck > 0) {
            return false;
        }
        if (!this.isIncludeMin() && minCheck >= 0) {
            return false;
        }
        int maxCheck = this.compare(value, this.max);
        if (this.isIncludeMax() && maxCheck > 0) {
            return false;
        }
        return this.isIncludeMax() || maxCheck < 0;
    }

    public String getRangeString() {
        return this.rangeString;
    }

    private int compare(N number1, N number2) {
        if (!number2.getClass().equals(number1.getClass())) {
            throw new IllegalStateException();
        }
        if (number1 instanceof Comparable) {
            return ((Comparable)number1).compareTo(number2);
        }
        if (((Number)number1).doubleValue() < ((Number)number2).doubleValue()) {
            return -1;
        }
        if (((Number)number1).doubleValue() > ((Number)number2).doubleValue()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "FacetRange{min=" + this.min + ", max=" + this.max + ", includeMin=" + this.includeMin + ", includeMax=" + this.includeMax + '}';
    }
}

