/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.List;
import org.hibernate.search.query.facet.FacetRange;
import org.hibernate.search.query.facet.FacetRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeFacetRequest<N extends Number>
extends FacetRequest {
    private final List<FacetRange<N>> facetRangeList;

    public RangeFacetRequest(String name, String fieldName, List<FacetRange<N>> facetRanges) {
        super(name, fieldName);
        if (facetRanges == null || facetRanges.isEmpty()) {
            throw new IllegalArgumentException("At least one facet range must be specified");
        }
        this.facetRangeList = facetRanges;
    }

    public List<FacetRange<N>> getFacetRangeList() {
        return this.facetRangeList;
    }

    @Override
    public Class<?> getFieldCacheType() {
        return this.facetRangeList.get(0).getMin().getClass();
    }

    @Override
    public String toString() {
        return "RangeFacetRequest{facetRangeList=" + this.facetRangeList + "} " + super.toString();
    }
}

