/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.facet.FacetRequest;
import org.hibernate.search.query.facet.FacetSortOrder;

class FacetBuildingContext {
    private String name;
    private String fieldName;
    private FacetSortOrder sort = FacetSortOrder.COUNT_DESC;
    private boolean includeZeroCount = true;
    private boolean isRangeQuery = false;

    FacetBuildingContext() {
    }

    void setName(String name) {
        this.name = name;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    void setSort(FacetSortOrder sort) {
        this.sort = sort;
    }

    void setIncludeZeroCount(boolean includeZeroCount) {
        this.includeZeroCount = includeZeroCount;
    }

    FacetRequest getFacetRequest() {
        FacetRequest request = null;
        if (!this.isRangeQuery) {
            request = new DiscreteFacetRequest(this.name, this.fieldName);
        }
        request.setSort(this.sort);
        request.setIncludeZeroCounts(this.includeZeroCount);
        return request;
    }
}

