/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.CloseIndexRunnable;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PerDPResources {
    private static final Logger log = LoggerFactory.make();
    private final ExecutorService executor;
    private final LuceneWorkVisitor visitor;
    private final Workspace workspace;
    private final boolean exclusiveIndexUsage;
    private final ErrorHandler errorHandler;

    PerDPResources(WorkerBuildContext context, DirectoryProvider<?> dp) {
        this.errorHandler = context.getErrorHandler();
        this.workspace = new Workspace(context, dp, this.errorHandler);
        this.visitor = new LuceneWorkVisitor(this.workspace, context);
        this.executor = Executors.newFixedThreadPool(1, "Directory writer");
        this.exclusiveIndexUsage = context.isExclusiveIndexUsageEnabled(dp);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public LuceneWorkVisitor getVisitor() {
        return this.visitor;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isExclusiveIndexUsageEnabled() {
        return this.exclusiveIndexUsage;
    }

    public void shutdown() {
        if (this.exclusiveIndexUsage) {
            this.executor.execute(new CloseIndexRunnable(this.workspace));
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock");
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

