/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jpa.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.OptimisticLockException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.hql.QueryExecutionRequestException;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.SearchException;
import org.hibernate.transform.ResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextQueryImpl
implements org.hibernate.search.jpa.FullTextQuery {
    private final FullTextQuery query;
    private final Session session;
    private Integer firstResult;
    private Integer maxResults;
    private final Map<String, Object> hints = new HashMap<String, Object>(0);
    private FlushModeType jpaFlushMode;

    public FullTextQueryImpl(FullTextQuery query, Session session) {
        this.query = query;
        this.session = session;
    }

    @Override
    public org.hibernate.search.jpa.FullTextQuery setSort(Sort sort) {
        this.query.setSort(sort);
        return this;
    }

    @Override
    public org.hibernate.search.jpa.FullTextQuery setFilter(Filter filter) {
        this.query.setFilter(filter);
        return this;
    }

    @Override
    public int getResultSize() {
        try {
            return this.query.getResultSize();
        }
        catch (QueryTimeoutException e) {
            this.throwQueryTimeoutException(e);
            return 0;
        }
    }

    private void throwQueryTimeoutException(QueryTimeoutException e) {
        throw new javax.persistence.QueryTimeoutException(e.getMessage(), (Throwable)e, (Query)this);
    }

    @Override
    public org.hibernate.search.jpa.FullTextQuery setCriteriaQuery(Criteria criteria) {
        this.query.setCriteriaQuery(criteria);
        return this;
    }

    @Override
    public org.hibernate.search.jpa.FullTextQuery setProjection(String ... fields) {
        this.query.setProjection(fields);
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.query.enableFullTextFilter(name);
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.query.disableFullTextFilter(name);
    }

    @Override
    public org.hibernate.search.jpa.FullTextQuery setResultTransformer(ResultTransformer transformer) {
        this.query.setResultTransformer(transformer);
        return this;
    }

    public List getResultList() {
        try {
            return this.query.list();
        }
        catch (QueryTimeoutException e) {
            this.throwQueryTimeoutException(e);
            return null;
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SearchException he) {
            this.throwPersistenceException(he);
            throw he;
        }
    }

    private void throwPersistenceException(Exception e) {
        if (e instanceof StaleStateException) {
            PersistenceException pe = this.wrapStaleStateException((StaleStateException)e);
            this.throwPersistenceException(pe);
        } else if (e instanceof OptimisticLockException) {
            PersistenceException converted = this.wrapLockException((HibernateException)((Object)e), null);
            this.throwPersistenceException(converted);
        } else if (e instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException((HibernateException)((Object)e), null);
            this.throwPersistenceException(converted);
        } else if (e instanceof ConstraintViolationException) {
            this.throwPersistenceException((PersistenceException)new EntityExistsException((Throwable)e));
        } else if (e instanceof QueryTimeoutException) {
            javax.persistence.QueryTimeoutException converted = new javax.persistence.QueryTimeoutException(e.getMessage(), (Throwable)e);
            this.throwPersistenceException((PersistenceException)converted);
        } else if (e instanceof ObjectNotFoundException) {
            this.throwPersistenceException((PersistenceException)new EntityNotFoundException(e.getMessage()));
        } else if (e instanceof NonUniqueResultException) {
            this.throwPersistenceException((PersistenceException)new javax.persistence.NonUniqueResultException(e.getMessage()));
        } else if (e instanceof UnresolvableObjectException) {
            this.throwPersistenceException((PersistenceException)new EntityNotFoundException(e.getMessage()));
        } else {
            if (e instanceof QueryException) {
                throw new IllegalArgumentException(e);
            }
            if (e instanceof TransientObjectException) {
                throw new IllegalStateException(e);
            }
            this.throwPersistenceException(new PersistenceException((Throwable)e));
        }
    }

    public PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        Object pe;
        if (e instanceof OptimisticLockException) {
            OptimisticLockException ole = (OptimisticLockException)e;
            pe = new javax.persistence.OptimisticLockException(ole.getMessage(), (Throwable)ole, ole.getEntity());
        } else if (e instanceof PessimisticLockException) {
            PessimisticLockException ple = (PessimisticLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new LockTimeoutException(ple.getMessage(), (Throwable)ple, ple.getEntity()) : new javax.persistence.PessimisticLockException(ple.getMessage(), (Throwable)ple, ple.getEntity());
        } else {
            pe = new javax.persistence.OptimisticLockException((Throwable)e);
        }
        return pe;
    }

    void throwPersistenceException(PersistenceException e) {
        if (e instanceof NoResultException || !(e instanceof javax.persistence.NonUniqueResultException)) {
            // empty if block
        }
        throw e;
    }

    PersistenceException wrapStaleStateException(StaleStateException e) {
        Object entity;
        StaleObjectStateException sose;
        Serializable identifier;
        javax.persistence.OptimisticLockException pe = e instanceof StaleObjectStateException ? ((identifier = (sose = (StaleObjectStateException)e).getIdentifier()) != null ? ((entity = this.session.load(sose.getEntityName(), identifier)) instanceof Serializable ? new javax.persistence.OptimisticLockException(null, (Throwable)e, entity) : new javax.persistence.OptimisticLockException((Throwable)e)) : new javax.persistence.OptimisticLockException((Throwable)e)) : new javax.persistence.OptimisticLockException((Throwable)e);
        return pe;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSingleResult() {
        try {
            List result = this.query.list();
            if (result.size() == 0) {
                this.throwPersistenceException((PersistenceException)new NoResultException("No entity found for query"));
                return null;
            } else {
                if (result.size() <= 1) return result.get(0);
                HashSet uniqueResult = new HashSet(result);
                if (uniqueResult.size() <= 1) return uniqueResult.iterator().next();
                this.throwPersistenceException((PersistenceException)new javax.persistence.NonUniqueResultException("result returns " + uniqueResult.size() + " elements"));
            }
            return null;
        }
        catch (QueryTimeoutException e) {
            this.throwQueryTimeoutException(e);
            return null;
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException((Exception)((Object)he));
            return null;
        }
    }

    public Query setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("Negative (" + maxResults + ") parameter passed in to setMaxResults");
        }
        this.query.setMaxResults(maxResults);
        this.maxResults = maxResults;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults == null || this.maxResults == -1 ? Integer.MAX_VALUE : this.maxResults;
    }

    public Query setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.query.setFirstResult(firstResult);
        this.firstResult = firstResult;
        return this;
    }

    public int getFirstResult() {
        return this.firstResult == null ? 0 : this.firstResult;
    }

    @Override
    public Explanation explain(int documentId) {
        return this.query.explain(documentId);
    }

    @Override
    public org.hibernate.search.jpa.FullTextQuery limitFetchingTime(long timeout, TimeUnit timeUnit) {
        this.query.limitFetchingTime(timeout, timeUnit);
        return this;
    }

    @Override
    public boolean hasPartialResults() {
        return this.query.hasPartialResults();
    }

    public int executeUpdate() {
        throw new IllegalStateException("Update not allowed in FullTextQueries");
    }

    public Query setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        if ("javax.persistence.query.timeout".equals(hintName) && value != null) {
            if (value instanceof String) {
                this.query.setTimeout(new Long((String)value), TimeUnit.MILLISECONDS);
            } else if (value instanceof Number) {
                this.query.setTimeout(((Number)value).longValue(), TimeUnit.MILLISECONDS);
            }
        }
        return this;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public <T> Query setParameter(Parameter<T> tParameter, T t) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(Parameter<Calendar> calendarParameter, Calendar calendar, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(Parameter<Date> dateParameter, Date date, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(String name, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(int position, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Set<Parameter<?>> getParameters() {
        return Collections.EMPTY_SET;
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Parameter<?> getParameter(String name) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Parameter<?> getParameter(int position) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public boolean isBound(Parameter<?> param) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public <T> T getParameterValue(Parameter<T> param) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(String name) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(int position) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Query setFlushMode(FlushModeType flushMode) {
        this.jpaFlushMode = flushMode;
        if (flushMode == FlushModeType.AUTO) {
            this.query.setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.query.setFlushMode(FlushMode.COMMIT);
        }
        return this;
    }

    public FlushModeType getFlushMode() {
        if (this.jpaFlushMode != null) {
            return this.jpaFlushMode;
        }
        FlushMode hibernateFlushMode = this.session.getFlushMode();
        if (FlushMode.AUTO == hibernateFlushMode) {
            return FlushModeType.AUTO;
        }
        if (FlushMode.COMMIT == hibernateFlushMode) {
            return FlushModeType.COMMIT;
        }
        return null;
    }

    public Query setLockMode(LockModeType lockModeType) {
        throw new UnsupportedOperationException("lock modes not supported in fullText queries");
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("lock modes not supported in fullText queries");
    }

    public <T> T unwrap(Class<T> type) {
        return this.query.unwrap(type);
    }
}

