/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.util.ContextualException2WayBridge;
import org.hibernate.search.bridge.util.ContextualExceptionBridge;
import org.hibernate.search.engine.AbstractDocumentBuilder;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.LuceneOptionsImpl;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.HibernateHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilderIndexedEntity<T>
extends AbstractDocumentBuilder<T> {
    private static final Logger log = LoggerFactory.make();
    private final DirectoryProvider[] directoryProviders;
    private final IndexShardingStrategy shardingStrategy;
    private boolean explicitDocumentId = false;
    private boolean allowFieldSelectionInProjection = false;
    private XMember idGetter;
    private String idKeywordName;
    private Float idBoost;
    private TwoWayFieldBridge idBridge;
    private boolean idProvided = false;

    public DocumentBuilderIndexedEntity(XClass clazz, ConfigContext context, DirectoryProviderFactory.DirectoryProviders providerWrapper, ReflectionManager reflectionManager) {
        super(clazz, context, providerWrapper.getSimilarity(), reflectionManager);
        this.setEntityState(EntityState.INDEXED);
        this.directoryProviders = providerWrapper.getProviders();
        this.shardingStrategy = providerWrapper.getSelectionStrategy();
    }

    public XMember getIdGetter() {
        return this.idGetter;
    }

    @Override
    protected void initSubClass(XClass clazz, ConfigContext context) {
        ProvidedId provided = this.findProvidedId(clazz, this.reflectionManager);
        if (provided != null) {
            this.idBridge = BridgeFactory.extractTwoWayType(provided.bridge(), clazz, this.reflectionManager);
            this.idKeywordName = provided.name();
        }
        if (this.idKeywordName == null) {
            throw new SearchException("No document id in: " + clazz.getName());
        }
        this.checkAllowFieldSelection();
        if (log.isDebugEnabled()) {
            log.debug("Field selection in projections is set to {} for entity {}.", (Object)this.allowFieldSelectionInProjection, (Object)clazz.getName());
        }
    }

    @Override
    protected void subClassSpecificCheck(XProperty member, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        this.checkDocumentId(member, propertiesMetadata, isRoot, prefix, context);
    }

    protected void checkDocumentId(XProperty member, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        Annotation idAnnotation = this.getIdAnnotation(member, context);
        NumericField numericFieldAnn = (NumericField)member.getAnnotation(NumericField.class);
        if (idAnnotation != null) {
            String attributeName = this.getIdAttributeName(member, idAnnotation);
            if (isRoot) {
                if (this.explicitDocumentId) {
                    throw new SearchException("More than one @DocumentId specified on entity " + this.getBeanClass().getName());
                }
                if (idAnnotation instanceof DocumentId) {
                    this.explicitDocumentId = true;
                }
                this.idKeywordName = prefix + attributeName;
                FieldBridge fieldBridge = BridgeFactory.guessType(null, numericFieldAnn, (XMember)member, this.reflectionManager);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
                }
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
                this.idBoost = this.getBoost(member, null);
                ReflectionHelper.setAccessible((XMember)member);
                this.idGetter = member;
            } else {
                ReflectionHelper.setAccessible((XMember)member);
                propertiesMetadata.fieldGetters.add((XMember)member);
                String fieldName = prefix + attributeName;
                propertiesMetadata.fieldNames.add(fieldName);
                propertiesMetadata.fieldStore.add(Store.YES);
                propertiesMetadata.fieldIndex.add(this.getIndex(Index.UN_TOKENIZED));
                propertiesMetadata.fieldTermVectors.add(this.getTermVector(TermVector.NO));
                propertiesMetadata.fieldNullTokens.add(null);
                propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(null, null, (XMember)member, this.reflectionManager));
                propertiesMetadata.fieldBoosts.add(this.getBoost(member, null));
                propertiesMetadata.precisionSteps.add(this.getPrecisionStep(null));
                propertiesMetadata.dynamicFieldBoosts.add(this.getDynamicBoost(member));
                Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
                if (analyzer == null) {
                    analyzer = propertiesMetadata.analyzer;
                }
                if (analyzer == null) {
                    throw new AssertionFailure("Analyzer should not be undefined");
                }
                this.addToScopedAnalyzer(fieldName, analyzer, Index.UN_TOKENIZED);
            }
        }
    }

    private Annotation getIdAnnotation(XProperty member, ConfigContext context) {
        Annotation idAnnotation = null;
        DocumentId documentIdAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (documentIdAnn != null) {
            idAnnotation = documentIdAnn;
        } else if (context.isJpaPresent()) {
            Annotation jpaId;
            try {
                Class jpaIdClass = ReflectHelper.classForName((String)"javax.persistence.Id", ConfigContext.class);
                jpaId = member.getAnnotation(jpaIdClass);
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to load @Id.class even though it should be present ?!");
            }
            if (jpaId != null) {
                log.debug("Found JPA id and using it as document id");
                idAnnotation = jpaId;
            }
        }
        return idAnnotation;
    }

    private ProvidedId findProvidedId(XClass clazz, ReflectionManager reflectionManager) {
        ProvidedId id = null;
        XClass currentClass = clazz;
        while (id == null && !reflectionManager.equals(currentClass, Object.class)) {
            id = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
            currentClass = currentClass.getSuperclass();
        }
        return id;
    }

    @Override
    public void addWorkToQueue(Class<T> entityClass, T entity, Serializable id, WorkType workType, List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor) {
        String idInString;
        boolean sameIdWasSetToBeDeleted = false;
        ArrayList<LuceneWork> toDelete = new ArrayList<LuceneWork>();
        boolean duplicateDelete = false;
        for (LuceneWork luceneWork : queue) {
            Serializable currentId;
            if (luceneWork.getEntityClass() != entityClass || (currentId = luceneWork.getId()) == null || !currentId.equals(id)) continue;
            if (luceneWork instanceof DeleteLuceneWork) {
                sameIdWasSetToBeDeleted = true;
            } else if (luceneWork instanceof AddLuceneWork) {
                sameIdWasSetToBeDeleted = false;
            }
            if (workType == WorkType.DELETE) {
                if (luceneWork instanceof AddLuceneWork) {
                    toDelete.add(luceneWork);
                } else if (luceneWork instanceof DeleteLuceneWork) {
                    duplicateDelete = true;
                }
            }
            if (workType != WorkType.ADD || !(luceneWork instanceof AddLuceneWork)) continue;
            toDelete.add(luceneWork);
        }
        if (sameIdWasSetToBeDeleted && workType == WorkType.COLLECTION) {
            return;
        }
        for (LuceneWork luceneWork : toDelete) {
            queue.remove(luceneWork);
        }
        if (duplicateDelete) {
            return;
        }
        if (workType == WorkType.ADD) {
            idInString = this.objectToString(this.idBridge, this.idKeywordName, (Object)id);
            queue.add(this.createAddWork(entityClass, entity, id, idInString, false));
        } else if (workType == WorkType.DELETE || workType == WorkType.PURGE) {
            idInString = this.objectToString(this.idBridge, this.idKeywordName, (Object)id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
        } else if (workType == WorkType.PURGE_ALL) {
            queue.add(new PurgeAllLuceneWork(entityClass));
        } else if (workType == WorkType.UPDATE || workType == WorkType.COLLECTION) {
            idInString = this.objectToString(this.idBridge, this.idKeywordName, (Object)id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            queue.add(this.createAddWork(entityClass, entity, id, idInString, false));
        } else if (workType == WorkType.INDEX) {
            idInString = this.objectToString(this.idBridge, this.idKeywordName, (Object)id);
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            queue.add(this.createAddWork(entityClass, entity, id, idInString, true));
        } else {
            throw new AssertionFailure("Unknown WorkType: " + (Object)((Object)workType));
        }
        if (workType.searchForContainers()) {
            this.processContainedInInstances(entity, queue, this.getMetadata(), searchFactoryImplementor);
        }
    }

    private String objectToString(TwoWayFieldBridge bridge, String fieldName, Object value) {
        ContextualException2WayBridge contextualBridge = ((ContextualException2WayBridge)new ContextualException2WayBridge().setClass((Class)this.getBeanClass())).setFieldBridge(bridge).setFieldName(fieldName);
        return contextualBridge.objectToString(value);
    }

    private String objectToString(StringBridge bridge, String fieldName, Object value) {
        ContextualException2WayBridge contextualBridge = ((ContextualException2WayBridge)new ContextualException2WayBridge().setClass((Class)this.getBeanClass())).setStringBridge(bridge).setFieldName(fieldName);
        return contextualBridge.objectToString(value);
    }

    public AddLuceneWork createAddWork(Class<T> entityClass, T entity, Serializable id, String idInString, boolean isBatch) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(entity, id, fieldToAnalyzerMap);
        AddLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new AddLuceneWork(id, idInString, entityClass, doc, isBatch) : new AddLuceneWork(id, idInString, entityClass, doc, fieldToAnalyzerMap, isBatch);
        return addWork;
    }

    public Document getDocument(T instance, Serializable id, Map<String, String> fieldToAnalyzerMap) {
        if (fieldToAnalyzerMap == null) {
            throw new IllegalArgumentException("fieldToAnalyzerMap cannot be null");
        }
        Document doc = new Document();
        Class<T> entityType = HibernateHelper.getClass(instance);
        doc.setBoost(this.getMetadata().getClassBoost(instance));
        Field classField = new Field("_hibernate_class", entityType.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
        doc.add((Fieldable)classField);
        LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO, this.idBoost);
        ContextualExceptionBridge contextualBridge = new ContextualExceptionBridge().setFieldBridge(this.idBridge).setClass(entityType).setFieldName(this.idKeywordName);
        if (this.idGetter != null) {
            contextualBridge.pushMethod(this.idGetter.getName());
        }
        contextualBridge.set(this.idKeywordName, id, doc, luceneOptions);
        if (this.idGetter != null) {
            contextualBridge.popMethod();
        }
        HashSet<String> processedFieldNames = new HashSet<String>();
        this.buildDocumentFields(instance, doc, this.getMetadata(), fieldToAnalyzerMap, processedFieldNames, contextualBridge);
        return doc;
    }

    private void buildDocumentFields(Object instance, Document doc, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, ContextualExceptionBridge contextualBridge) {
        Object value;
        XMember member;
        int i;
        if (instance == null) {
            return;
        }
        Object unproxiedInstance = HibernateHelper.unproxy(instance);
        for (i = 0; i < propertiesMetadata.classBridges.size(); ++i) {
            FieldBridge fb = propertiesMetadata.classBridges.get(i);
            String fieldName = propertiesMetadata.classNames.get(i);
            contextualBridge.setFieldBridge(fb).setFieldName(fieldName).set(fieldName, unproxiedInstance, doc, propertiesMetadata.getClassLuceneOptions(i));
        }
        for (i = 0; i < propertiesMetadata.fieldNames.size(); ++i) {
            member = propertiesMetadata.fieldGetters.get(i);
            value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
            FieldBridge fieldBridge = propertiesMetadata.fieldBridges.get(i);
            String fieldName = propertiesMetadata.fieldNames.get(i);
            contextualBridge.setFieldBridge(fieldBridge).pushMethod(member.getName()).setFieldName(fieldName).set(fieldName, value, doc, propertiesMetadata.getFieldLuceneOptions(i, value));
            contextualBridge.popMethod();
        }
        this.allowAnalyzerDiscriminatorOverride(doc, propertiesMetadata, fieldToAnalyzerMap, processedFieldNames, unproxiedInstance);
        for (i = 0; i < propertiesMetadata.embeddedGetters.size(); ++i) {
            member = propertiesMetadata.embeddedGetters.get(i);
            contextualBridge.pushMethod(member.getName());
            value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
            if (value == null) continue;
            AbstractDocumentBuilder.PropertiesMetadata embeddedMetadata = propertiesMetadata.embeddedPropertiesMetadata.get(i);
            switch (propertiesMetadata.embeddedContainers.get(i)) {
                case ARRAY: {
                    for (Object arrayValue : (Object[])value) {
                        this.buildDocumentFields(arrayValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, contextualBridge);
                    }
                    break;
                }
                case COLLECTION: {
                    for (Object collectionValue : (Collection)value) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, contextualBridge);
                    }
                    break;
                }
                case MAP: {
                    for (Object collectionValue : ((Map)value).values()) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, contextualBridge);
                    }
                    break;
                }
                case OBJECT: {
                    this.buildDocumentFields(value, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, contextualBridge);
                    break;
                }
                default: {
                    throw new AssertionFailure("Unknown embedded container: " + (Object)((Object)propertiesMetadata.embeddedContainers.get(i)));
                }
            }
            contextualBridge.popMethod();
        }
    }

    private void allowAnalyzerDiscriminatorOverride(Document doc, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, Object unproxiedInstance) {
        Discriminator discriminator = propertiesMetadata.discriminator;
        if (discriminator == null) {
            return;
        }
        Object value = null;
        if (propertiesMetadata.discriminatorGetter != null) {
            value = ReflectionHelper.getMemberValue(unproxiedInstance, propertiesMetadata.discriminatorGetter);
        }
        for (Fieldable o : doc.getFields()) {
            Fieldable field = o;
            if (processedFieldNames.contains(field.name())) continue;
            String analyzerName = discriminator.getAnalyzerDefinitionName(value, unproxiedInstance, field.name());
            if (analyzerName != null) {
                fieldToAnalyzerMap.put(field.name(), analyzerName);
            }
            processedFieldNames.add(field.name());
        }
    }

    public String getIdentifierName() {
        return this.idGetter.getName();
    }

    public DirectoryProvider[] getDirectoryProviders() {
        if (this.getEntityState() != EntityState.INDEXED) {
            throw new AssertionFailure("Contained in only entity: getDirectoryProvider should not have been called.");
        }
        return this.directoryProviders;
    }

    public IndexShardingStrategy getDirectoryProviderSelectionStrategy() {
        if (this.getEntityState() != EntityState.INDEXED) {
            throw new AssertionFailure("Contained in only entity: getDirectoryProviderSelectionStrategy should not have been called.");
        }
        return this.shardingStrategy;
    }

    public boolean allowFieldSelectionInProjection() {
        return this.allowFieldSelectionInProjection;
    }

    public Term getTerm(Serializable id) {
        if (this.idProvided) {
            return new Term(this.idKeywordName, (String)((Object)id));
        }
        return new Term(this.idKeywordName, this.objectToString(this.idBridge, this.idKeywordName, (Object)id));
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    public Serializable getId(Object entity) {
        if (entity == null || this.idGetter == null) {
            throw new IllegalStateException("Cannot guess id form entity");
        }
        return (Serializable)ReflectionHelper.getMemberValue(entity, this.idGetter);
    }

    public String objectToString(String fieldName, Object value) {
        if (fieldName == null) {
            throw new AssertionFailure("Field name should not be null");
        }
        if (fieldName.equals(this.idKeywordName)) {
            return this.objectToString(this.idBridge, this.idKeywordName, value);
        }
        FieldBridge bridge = this.getBridge(this.getMetadata(), fieldName);
        if (bridge != null) {
            Class<?> bridgeClass = bridge.getClass();
            if (TwoWayFieldBridge.class.isAssignableFrom(bridgeClass)) {
                return this.objectToString((TwoWayFieldBridge)bridge, fieldName, value);
            }
            if (StringBridge.class.isAssignableFrom(bridgeClass)) {
                return this.objectToString((StringBridge)((Object)bridge), fieldName, value);
            }
            throw new SearchException("FieldBridge " + bridgeClass + "does not have a objectToString method: field " + fieldName + " in " + this.getBeanXClass());
        }
        throw new SearchException("Unable to find field " + fieldName + " in " + this.getBeanXClass());
    }

    private FieldBridge getBridge(List<String> names, List<FieldBridge> bridges, String fieldName) {
        int index = names.indexOf(fieldName);
        if (index != -1) {
            return bridges.get(index);
        }
        return null;
    }

    public FieldBridge getBridge(String fieldName) {
        return this.getBridge(this.getMetadata(), fieldName);
    }

    private FieldBridge getBridge(AbstractDocumentBuilder.PropertiesMetadata metadata, String fieldName) {
        FieldBridge fieldBridge = this.getBridge(metadata.fieldNames, metadata.fieldBridges, fieldName);
        if (fieldBridge != null) {
            return fieldBridge;
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index = 0; index < nbrOfEmbeddedObjects; ++index) {
            fieldBridge = this.getBridge(metadata.embeddedPropertiesMetadata.get(index), fieldName);
            if (fieldBridge == null) continue;
            return fieldBridge;
        }
        fieldBridge = this.getBridge(metadata.classNames, metadata.classBridges, fieldName);
        if (fieldBridge != null) {
            return fieldBridge;
        }
        return null;
    }

    private void checkAllowFieldSelection() {
        this.allowFieldSelectionInProjection = true;
        if (!(this.idBridge instanceof TwoWayStringBridge) && !(this.idBridge instanceof TwoWayString2FieldBridgeAdaptor)) {
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (FieldBridge bridge : this.getMetadata().fieldBridges) {
            if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (FieldBridge bridge : this.getMetadata().classBridges) {
            if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
    }

    private String getIdAttributeName(XProperty member, Annotation idAnnotation) {
        String name = null;
        try {
            Method m = idAnnotation.getClass().getMethod("name", new Class[0]);
            name = (String)m.invoke((Object)idAnnotation, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ReflectionHelper.getAttributeName((XMember)member, name);
    }
}

