/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;

class LuceneOptionsImpl
implements LuceneOptions {
    private final boolean storeCompressed;
    private final boolean storeUncompressed;
    private final Field.Index indexMode;
    private final Field.TermVector termVector;
    private final Float boost;
    private final Store storeType;

    public LuceneOptionsImpl(Store store, Field.Index indexMode, Field.TermVector termVector, Float boost) {
        this.indexMode = indexMode;
        this.termVector = termVector;
        this.boost = boost;
        this.storeType = store;
        this.storeCompressed = store.equals((Object)Store.COMPRESS);
        this.storeUncompressed = store.equals((Object)Store.YES);
    }

    public void addFieldToDocument(String name, String indexedString, Document document) {
        if (StringHelper.isNotEmpty((String)indexedString)) {
            if (!this.indexMode.equals((Object)Field.Index.NO) || !this.storeCompressed) {
                this.standardFieldAdd(name, indexedString, document);
            }
            if (this.storeCompressed) {
                this.compressedFieldAdd(name, indexedString, document);
            }
        }
    }

    private void standardFieldAdd(String name, String indexedString, Document document) {
        Field field = new Field(name, false, indexedString, this.storeUncompressed ? Field.Store.YES : Field.Store.NO, this.indexMode, this.termVector);
        if (this.boost != null) {
            field.setBoost(this.boost.floatValue());
        }
        document.add((Fieldable)field);
    }

    private void compressedFieldAdd(String name, String indexedString, Document document) {
        byte[] compressedString = CompressionTools.compressString((String)indexedString);
        Field field = new Field(name, compressedString, Field.Store.YES);
        document.add((Fieldable)field);
    }

    public Float getBoost() {
        if (this.boost != null) {
            return this.boost;
        }
        return Float.valueOf(1.0f);
    }

    public boolean isCompressed() {
        return this.storeCompressed;
    }

    public Field.Index getIndex() {
        return this.indexMode;
    }

    public Field.Store getStore() {
        if (this.storeUncompressed || this.storeCompressed) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    public Store getStoreStrategy() {
        return this.storeType;
    }
}

