/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.DefaultBoostStrategy;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.LuceneOptionsImpl;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.HibernateHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.PassThroughAnalyzer;
import org.hibernate.search.util.ReflectionHelper;
import org.hibernate.search.util.ScopedAnalyzer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentBuilder<T>
implements DocumentBuilder {
    private static final Logger log = LoggerFactory.make();
    protected final PropertiesMetadata metadata = new PropertiesMetadata();
    protected final XClass beanXClass;
    protected final Class<?> beanClass;
    protected Set<Class<?>> mappedSubclasses = new HashSet();
    protected ReflectionManager reflectionManager;
    protected int level = 0;
    protected int maxLevel = Integer.MAX_VALUE;
    protected final ScopedAnalyzer analyzer = new ScopedAnalyzer();
    protected Similarity similarity;
    protected boolean isRoot;
    protected EntityState entityState;
    private Analyzer passThroughAnalyzer = new PassThroughAnalyzer();

    public AbstractDocumentBuilder(XClass xClass, ConfigContext context, ReflectionManager reflectionManager) {
        if (xClass == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilderContainedEntity with a null class");
        }
        this.entityState = EntityState.CONTAINED_IN_ONLY;
        this.beanXClass = xClass;
        this.reflectionManager = reflectionManager;
        this.beanClass = reflectionManager.toClass(xClass);
        this.init(xClass, context);
        if (this.metadata.containedInGetters.size() == 0) {
            this.entityState = EntityState.NON_INDEXABLE;
        }
    }

    public abstract void addWorkToQueue(Class<T> var1, T var2, Serializable var3, WorkType var4, List<LuceneWork> var5, SearchFactoryImplementor var6);

    protected abstract void subClassSpecificCheck(XProperty var1, PropertiesMetadata var2, boolean var3, String var4, ConfigContext var5);

    protected abstract void initSubClass(XClass var1, ConfigContext var2);

    public boolean isRoot() {
        return this.isRoot;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public Set<Class<?>> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    public void postInitialize(Set<Class<?>> indexedClasses) {
        Class<?> plainClass = this.beanClass;
        if (this.entityState == EntityState.NON_INDEXABLE) {
            throw new AssertionFailure("A non indexed entity is post processed");
        }
        HashSet tempMappedSubclasses = new HashSet();
        for (Class<?> currentClass : indexedClasses) {
            if (plainClass == currentClass || !plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
        this.isRoot = true;
        for (Class<?> superClass = plainClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!indexedClasses.contains(superClass)) continue;
            this.isRoot = false;
            break;
        }
        this.reflectionManager = null;
    }

    protected Analyzer getAnalyzer(XAnnotatedElement annotatedElement, ConfigContext context) {
        org.hibernate.search.annotations.Analyzer analyzerAnn = (org.hibernate.search.annotations.Analyzer)annotatedElement.getAnnotation(org.hibernate.search.annotations.Analyzer.class);
        return this.getAnalyzer(analyzerAnn, context);
    }

    protected void addToScopedAnalyzer(String fieldName, Analyzer analyzer, Index index) {
        if (index == Index.TOKENIZED) {
            if (analyzer != null) {
                this.analyzer.addScopedAnalyzer(fieldName, analyzer);
            }
        } else {
            this.analyzer.addScopedAnalyzer(fieldName, this.passThroughAnalyzer);
        }
    }

    protected Float getBoost(XProperty member, Field fieldAnn) {
        float computedBoost = 1.0f;
        Boost boostAnn = (Boost)member.getAnnotation(Boost.class);
        if (boostAnn != null) {
            computedBoost = boostAnn.value();
        }
        if (fieldAnn != null) {
            computedBoost *= fieldAnn.boost().value();
        }
        return Float.valueOf(computedBoost);
    }

    protected BoostStrategy getDynamicBoost(XProperty member) {
        BoostStrategy strategy;
        DynamicBoost boostAnnotation = (DynamicBoost)member.getAnnotation(DynamicBoost.class);
        if (boostAnnotation == null) {
            return new DefaultBoostStrategy();
        }
        Class<? extends BoostStrategy> boostStrategyClass = boostAnnotation.impl();
        try {
            strategy = boostStrategyClass.newInstance();
        }
        catch (Exception e) {
            throw new SearchException("Unable to instantiate boost strategy implementation: " + boostStrategyClass.getName());
        }
        return strategy;
    }

    protected Field.TermVector getTermVector(TermVector vector) {
        switch (vector) {
            case NO: {
                return Field.TermVector.NO;
            }
            case YES: {
                return Field.TermVector.YES;
            }
            case WITH_OFFSETS: {
                return Field.TermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return Field.TermVector.WITH_POSITIONS;
            }
            case WITH_POSITION_OFFSETS: {
                return Field.TermVector.WITH_POSITIONS_OFFSETS;
            }
        }
        throw new AssertionFailure("Unexpected TermVector: " + (Object)((Object)vector));
    }

    protected Field.Index getIndex(Index index) {
        switch (index) {
            case NO: {
                return Field.Index.NO;
            }
            case NO_NORMS: {
                return Field.Index.NOT_ANALYZED_NO_NORMS;
            }
            case TOKENIZED: {
                return Field.Index.ANALYZED;
            }
            case UN_TOKENIZED: {
                return Field.Index.NOT_ANALYZED;
            }
        }
        throw new AssertionFailure("Unexpected Index: " + (Object)((Object)index));
    }

    protected <T> void processContainedInInstances(Object instance, List<LuceneWork> queue, PropertiesMetadata metadata, SearchFactoryImplementor searchFactoryImplementor) {
        for (int i = 0; i < metadata.containedInGetters.size(); ++i) {
            XMember member = metadata.containedInGetters.get(i);
            Object value = ReflectionHelper.getMemberValue(instance, member);
            if (value == null) continue;
            if (member.isArray()) {
                Object[] array;
                for (Object arrayValue : array = (Object[])value) {
                    this.processSingleContainedInInstance(queue, searchFactoryImplementor, arrayValue);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection<T> collection;
                block7: {
                    collection = null;
                    try {
                        collection = this.getActualCollection(member, value);
                        collection.size();
                    }
                    catch (Exception e) {
                        if (!e.getClass().getName().contains("org.hibernate.LazyInitializationException")) break block7;
                        collection = null;
                    }
                }
                if (collection == null) continue;
                for (T collectionValue : collection) {
                    this.processSingleContainedInInstance(queue, searchFactoryImplementor, collectionValue);
                }
                continue;
            }
            this.processSingleContainedInInstance(queue, searchFactoryImplementor, value);
        }
    }

    private void init(XClass clazz, ConfigContext context) {
        this.metadata.boost = this.getBoost(clazz);
        this.metadata.classBoostStrategy = this.getDynamicBoost(clazz);
        this.metadata.analyzer = context.getDefaultAnalyzer();
        HashSet<XClass> processedClasses = new HashSet<XClass>();
        processedClasses.add(clazz);
        this.initializeClass(clazz, this.metadata, true, "", processedClasses, context);
        this.analyzer.setGlobalAnalyzer(this.metadata.analyzer);
        if (this.similarity == null) {
            this.similarity = context.getDefaultSimilarity();
        }
        this.initSubClass(clazz, context);
    }

    private void initializeClass(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, ConfigContext context) {
        ArrayList<XClass> hierarchy = new ArrayList<XClass>();
        for (XClass currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            hierarchy.add(currentClass);
        }
        for (int index = hierarchy.size() - 1; index >= 0; --index) {
            XClass currentClass = (XClass)hierarchy.get(index);
            this.initializeClassLevelAnnotations(currentClass, propertiesMetadata, isRoot, prefix, context);
            List methods = currentClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMemberLevelAnnotations(method, propertiesMetadata, isRoot, prefix, processedClasses, context);
            }
            List fields = currentClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMemberLevelAnnotations(field, propertiesMetadata, isRoot, prefix, processedClasses, context);
            }
        }
    }

    private void initializeClassLevelAnnotations(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        ClassBridge classBridgeAnn;
        Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)clazz, context);
        if (analyzer != null) {
            propertiesMetadata.analyzer = analyzer;
        }
        this.checkForAnalyzerDefs((XAnnotatedElement)clazz, context);
        ClassBridges classBridgesAnn = (ClassBridges)clazz.getAnnotation(ClassBridges.class);
        if (classBridgesAnn != null) {
            ClassBridge[] classBridges;
            for (ClassBridge cb : classBridges = classBridgesAnn.value()) {
                this.bindClassBridgeAnnotation(prefix, propertiesMetadata, cb, context);
            }
        }
        if ((classBridgeAnn = (ClassBridge)clazz.getAnnotation(ClassBridge.class)) != null) {
            this.bindClassBridgeAnnotation(prefix, propertiesMetadata, classBridgeAnn, context);
        }
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)clazz, propertiesMetadata);
        if (isRoot) {
            this.checkForSimilarity(clazz);
        }
    }

    private void initializeMemberLevelAnnotations(XProperty member, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, ConfigContext context) {
        this.checkForField(member, propertiesMetadata, prefix, context);
        this.checkForFields(member, propertiesMetadata, prefix, context);
        this.checkForAnalyzerDefs((XAnnotatedElement)member, context);
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)member, propertiesMetadata);
        this.checkForIndexedEmbedded(member, propertiesMetadata, prefix, processedClasses, context);
        this.checkForContainedIn(member, propertiesMetadata);
        this.subClassSpecificCheck(member, propertiesMetadata, isRoot, prefix, context);
    }

    private Analyzer getAnalyzer(org.hibernate.search.annotations.Analyzer analyzerAnn, ConfigContext context) {
        Class<Void> analyzerClass;
        Class<Void> clazz = analyzerClass = analyzerAnn == null ? Void.TYPE : analyzerAnn.impl();
        if (analyzerClass == Void.TYPE) {
            String definition;
            String string = definition = analyzerAnn == null ? "" : analyzerAnn.definition();
            if (StringHelper.isEmpty((String)definition)) {
                return null;
            }
            return context.buildLazyAnalyzer(definition);
        }
        try {
            return ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, context.getLuceneMatchVersion());
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    private void checkForAnalyzerDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def);
    }

    private void checkForAnalyzerDiscriminator(XAnnotatedElement annotatedElement, PropertiesMetadata propertiesMetadata) {
        AnalyzerDiscriminator discriminatorAnn = (AnalyzerDiscriminator)annotatedElement.getAnnotation(AnalyzerDiscriminator.class);
        if (discriminatorAnn != null) {
            if (propertiesMetadata.discriminator != null) {
                throw new SearchException("Multiple AnalyzerDiscriminator defined in the same class hierarchy: " + this.beanXClass.getName());
            }
            Class<? extends Discriminator> discriminatorClass = discriminatorAnn.impl();
            try {
                propertiesMetadata.discriminator = discriminatorClass.newInstance();
            }
            catch (Exception e) {
                throw new SearchException("Unable to instantiate analyzer discriminator implementation: " + discriminatorClass.getName());
            }
            if (annotatedElement instanceof XMember) {
                propertiesMetadata.discriminatorGetter = (XMember)annotatedElement;
            }
        }
    }

    private void checkForFields(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context) {
        Fields fieldsAnn = (Fields)member.getAnnotation(Fields.class);
        if (fieldsAnn != null) {
            for (Field fieldAnn : fieldsAnn.value()) {
                this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn, context);
            }
        }
    }

    private void checkForSimilarity(XClass currClass) {
        org.hibernate.search.annotations.Similarity similarityAnn = (org.hibernate.search.annotations.Similarity)currClass.getAnnotation(org.hibernate.search.annotations.Similarity.class);
        if (similarityAnn != null) {
            if (this.similarity != null) {
                throw new SearchException("Multiple Similarities defined in the same class hierarchy: " + this.beanXClass.getName());
            }
            Class<?> similarityClass = similarityAnn.impl();
            try {
                this.similarity = (Similarity)similarityClass.newInstance();
            }
            catch (Exception e) {
                log.error("Exception attempting to instantiate Similarity '{}' set for {}", (Object)similarityClass.getName(), (Object)this.beanXClass.getName());
            }
        }
    }

    private void checkForField(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context) {
        Field fieldAnn = (Field)member.getAnnotation(Field.class);
        if (fieldAnn != null) {
            this.bindFieldAnnotation(member, propertiesMetadata, prefix, fieldAnn, context);
        }
    }

    private void checkForContainedIn(XProperty member, PropertiesMetadata propertiesMetadata) {
        ContainedIn containedAnn = (ContainedIn)member.getAnnotation(ContainedIn.class);
        if (containedAnn != null) {
            ReflectionHelper.setAccessible((XMember)member);
            propertiesMetadata.containedInGetters.add((XMember)member);
        }
    }

    private void checkForIndexedEmbedded(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Set<XClass> processedClasses, ConfigContext context) {
        IndexedEmbedded embeddedAnn = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (embeddedAnn != null) {
            int oldMaxLevel = this.maxLevel;
            int potentialLevel = embeddedAnn.depth() + this.level;
            if (potentialLevel < 0) {
                potentialLevel = Integer.MAX_VALUE;
            }
            this.maxLevel = potentialLevel > this.maxLevel ? this.maxLevel : potentialLevel;
            ++this.level;
            XClass elementClass = Void.TYPE == embeddedAnn.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(embeddedAnn.targetElement());
            if (this.maxLevel == Integer.MAX_VALUE && processedClasses.contains(elementClass)) {
                throw new SearchException("Circular reference. Duplicate use of " + elementClass.getName() + " in root entity " + this.beanXClass.getName() + "#" + this.buildEmbeddedPrefix(prefix, embeddedAnn, member));
            }
            if (this.level <= this.maxLevel) {
                processedClasses.add(elementClass);
                ReflectionHelper.setAccessible((XMember)member);
                propertiesMetadata.embeddedGetters.add((XMember)member);
                PropertiesMetadata metadata = new PropertiesMetadata();
                propertiesMetadata.embeddedPropertiesMetadata.add(metadata);
                metadata.boost = this.getBoost(member, null).floatValue();
                Analyzer analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
                metadata.analyzer = analyzer != null ? analyzer : propertiesMetadata.analyzer;
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                this.initializeClass(elementClass, metadata, false, localPrefix, processedClasses, context);
                if (member.isArray()) {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.ARRAY);
                } else if (member.isCollection()) {
                    if (Map.class.equals((Object)member.getCollectionClass())) {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.MAP);
                    } else {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.COLLECTION);
                    }
                } else {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.OBJECT);
                }
                processedClasses.remove(elementClass);
            } else if (log.isTraceEnabled()) {
                String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
                log.trace("depth reached, ignoring {}", (Object)localPrefix);
            }
            --this.level;
            this.maxLevel = oldMaxLevel;
        }
    }

    private void bindClassBridgeAnnotation(String prefix, PropertiesMetadata propertiesMetadata, ClassBridge ann, ConfigContext context) {
        String fieldName = prefix + ann.name();
        propertiesMetadata.classNames.add(fieldName);
        propertiesMetadata.classStores.add(ann.store());
        propertiesMetadata.classIndexes.add(this.getIndex(ann.index()));
        propertiesMetadata.classTermVectors.add(this.getTermVector(ann.termVector()));
        propertiesMetadata.classBridges.add(BridgeFactory.extractType(ann));
        propertiesMetadata.classBoosts.add(Float.valueOf(ann.boost().value()));
        Analyzer analyzer = this.getAnalyzer(ann.analyzer(), context);
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
        this.addToScopedAnalyzer(fieldName, analyzer, ann.index());
    }

    private void bindFieldAnnotation(XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Field fieldAnn, ConfigContext context) {
        ReflectionHelper.setAccessible((XMember)member);
        propertiesMetadata.fieldGetters.add((XMember)member);
        String fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, fieldAnn.name());
        propertiesMetadata.fieldNames.add(fieldName);
        propertiesMetadata.fieldStore.add(fieldAnn.store());
        propertiesMetadata.fieldIndex.add(this.getIndex(fieldAnn.index()));
        propertiesMetadata.fieldBoosts.add(this.getBoost(member, fieldAnn));
        propertiesMetadata.dynamicFieldBoosts.add(this.getDynamicBoost(member));
        propertiesMetadata.fieldTermVectors.add(this.getTermVector(fieldAnn.termVector()));
        propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(fieldAnn, (XMember)member, this.reflectionManager));
        Analyzer analyzer = this.getAnalyzer(fieldAnn.analyzer(), context);
        if (analyzer == null) {
            analyzer = this.getAnalyzer((XAnnotatedElement)member, context);
        }
        this.addToScopedAnalyzer(fieldName, analyzer, fieldAnn.index());
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded embeddedAnn, XProperty member) {
        String localPrefix = prefix;
        localPrefix = ".".equals(embeddedAnn.prefix()) ? localPrefix + member.getName() + '.' : localPrefix + embeddedAnn.prefix();
        return localPrefix;
    }

    private float getBoost(XClass element) {
        float boost = 1.0f;
        if (element == null) {
            return boost;
        }
        Boost boostAnnotation = (Boost)element.getAnnotation(Boost.class);
        if (boostAnnotation != null) {
            boost = boostAnnotation.value();
        }
        return boost;
    }

    private BoostStrategy getDynamicBoost(XClass element) {
        BoostStrategy strategy;
        if (element == null) {
            return null;
        }
        DynamicBoost boostAnnotation = (DynamicBoost)element.getAnnotation(DynamicBoost.class);
        if (boostAnnotation == null) {
            return new DefaultBoostStrategy();
        }
        Class<? extends BoostStrategy> boostStrategyClass = boostAnnotation.impl();
        try {
            strategy = boostStrategyClass.newInstance();
        }
        catch (Exception e) {
            throw new SearchException("Unable to instantiate boost strategy implementation: " + boostStrategyClass.getName());
        }
        return strategy;
    }

    private <T> Collection<T> getActualCollection(XMember member, Object value) {
        Collection tmpCollection;
        Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? (tmpCollection = ((Map)value).values()) : (tmpCollection = (Collection)value);
        return collection;
    }

    private <T> void processSingleContainedInInstance(List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor, T value) {
        Class<T> valueClass = HibernateHelper.getClass(value);
        DocumentBuilderIndexedEntity<T> builderIndexedEntity = searchFactoryImplementor.getDocumentBuilderIndexedEntity(valueClass);
        if (builderIndexedEntity == null) {
            DocumentBuilderContainedEntity<T> builderContainedEntity = searchFactoryImplementor.getDocumentBuilderContainedEntity(valueClass);
            if (builderContainedEntity != null) {
                this.processContainedInInstances(value, queue, builderContainedEntity.metadata, searchFactoryImplementor);
            }
        } else {
            this.addWorkForEmbeddedValue(value, queue, valueClass, builderIndexedEntity, searchFactoryImplementor);
        }
    }

    private <T> void addWorkForEmbeddedValue(T value, List<LuceneWork> queue, Class<T> valueClass, DocumentBuilderIndexedEntity<T> builderIndexedEntity, SearchFactoryImplementor searchFactoryImplementor) {
        Serializable id = (Serializable)ReflectionHelper.getMemberValue(value, builderIndexedEntity.idGetter);
        if (id != null) {
            builderIndexedEntity.addWorkToQueue(valueClass, value, id, WorkType.UPDATE, queue, searchFactoryImplementor);
        }
    }

    protected static class PropertiesMetadata {
        public float boost;
        public Analyzer analyzer;
        public Discriminator discriminator;
        public XMember discriminatorGetter;
        public BoostStrategy classBoostStrategy;
        public final List<String> fieldNames = new ArrayList<String>();
        public final List<XMember> fieldGetters = new ArrayList<XMember>();
        public final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
        public final List<Store> fieldStore = new ArrayList<Store>();
        public final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
        public final List<Float> fieldBoosts = new ArrayList<Float>();
        public final List<BoostStrategy> dynamicFieldBoosts = new ArrayList<BoostStrategy>();
        public final List<Field.TermVector> fieldTermVectors = new ArrayList<Field.TermVector>();
        public final List<XMember> embeddedGetters = new ArrayList<XMember>();
        public final List<PropertiesMetadata> embeddedPropertiesMetadata = new ArrayList<PropertiesMetadata>();
        public final List<Container> embeddedContainers = new ArrayList<Container>();
        public final List<XMember> containedInGetters = new ArrayList<XMember>();
        public final List<String> classNames = new ArrayList<String>();
        public final List<Store> classStores = new ArrayList<Store>();
        public final List<Field.Index> classIndexes = new ArrayList<Field.Index>();
        public final List<FieldBridge> classBridges = new ArrayList<FieldBridge>();
        public final List<Field.TermVector> classTermVectors = new ArrayList<Field.TermVector>();
        public final List<Float> classBoosts = new ArrayList<Float>();

        protected PropertiesMetadata() {
        }

        protected LuceneOptions getClassLuceneOptions(int i) {
            return new LuceneOptionsImpl(this.classStores.get(i), this.classIndexes.get(i), this.classTermVectors.get(i), this.classBoosts.get(i));
        }

        protected LuceneOptions getFieldLuceneOptions(int i, Object value) {
            LuceneOptionsImpl options = new LuceneOptionsImpl(this.fieldStore.get(i), this.fieldIndex.get(i), this.fieldTermVectors.get(i), Float.valueOf(this.fieldBoosts.get(i).floatValue() * this.dynamicFieldBoosts.get(i).defineBoost(value)));
            return options;
        }

        protected float getClassBoost(Object value) {
            return this.boost * this.classBoostStrategy.defineBoost(value);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Container {
            OBJECT,
            COLLECTION,
            MAP,
            ARRAY;

        }
    }
}

