/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = new Entry[capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public WeakIdentityHashMap(Map t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t);
    }

    private static <T> T maskNull(T key) {
        return (T)(key == null ? NULL_KEY : key);
    }

    private static <T> T unmaskNull(T key) {
        return key == NULL_KEY ? null : (T)key;
    }

    int hash(Object x) {
        int h = System.identityHashCode(x);
        return h - (h << 7);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private void expungeStaleEntries() {
        Reference r;
        block0: while ((r = this.queue.poll()) != null) {
            Entry prev;
            Entry e = (Entry)r;
            int h = e.hash;
            int i = WeakIdentityHashMap.indexFor(h, this.table.length);
            Entry p = prev = this.table[i];
            while (p != null) {
                Entry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.value = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == h && k == e.get()) {
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null && (e.hash != h || k != e.get())) {
            e = e.next;
        }
        return e;
    }

    @Override
    public V put(K key, V value) {
        K k = WeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[i];
        while (e != null) {
            if (h == e.hash && k == e.get()) {
                Object oldValue = e.value;
                if (value != oldValue) {
                    e.value = value;
                }
                return (V)oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        tab[i] = new Entry<K, V>(k, value, this.queue, h, tab[i]);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = WeakIdentityHashMap.indexFor(e.hash, dest.length);
                    e.next = (Entry)dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry prev;
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && k == e.get()) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return (V)e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Entry<K, V>[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = WeakIdentityHashMap.maskNull(entry.getKey());
        int h = this.hash(k);
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean removeValue(Object value) {
        if (value == null) {
            return this.removeNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        HashSet<K> keys = new HashSet<K>();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    keys.add(e.getKey());
                }
                e = e.next;
            }
        }
        for (Object key : keys) {
            this.remove(key);
        }
        return !keys.isEmpty();
    }

    private boolean removeNullValue() {
        Entry<K, V>[] tab = this.getTable();
        HashSet<K> keys = new HashSet<K>();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    keys.add(e.getKey());
                }
                e = e.next;
            }
        }
        for (Object key : keys) {
            this.remove(key);
        }
        return !keys.isEmpty();
    }

    @Override
    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Entry candidate = WeakIdentityHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakIdentityHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry(i.next()));
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry(i.next()));
            }
            return c.toArray(a);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsValue(o);
        }

        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            if (WeakIdentityHashMap.this.containsKey(o)) {
                WeakIdentityHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        int index;
        Entry<K, V> entry = null;
        Entry<K, V> lastReturned = null;
        int expectedModCount = WeakIdentityHashMap.access$400(WeakIdentityHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = WeakIdentityHashMap.this.size() != 0 ? WeakIdentityHashMap.this.table.length : 0;
        }

        @Override
        public boolean hasNext() {
            Entry[] t = WeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        private V value;
        private final int hash;
        private Entry<K, V> next;

        Entry(K key, V value, ReferenceQueue queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakIdentityHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : System.identityHashCode(k)) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

