/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.WorkerFactory;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.MRUFilterCachingStrategy;
import org.hibernate.search.impl.InitContext;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderFactory;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFactoryImpl
implements SearchFactoryImplementor {
    private static final Logger log;
    private final Map<Class<?>, DocumentBuilder<?>> documentBuilders = new HashMap();
    private final Map<Class<?>, DocumentBuilder<?>> containedInOnlyBuilders = new HashMap();
    private final Map<DirectoryProvider<?>, DirectoryProviderData> dirProviderData = new HashMap();
    private final Worker worker;
    private final ReaderProvider readerProvider;
    private BackendQueueProcessorFactory backendQueueProcessorFactory;
    private final Map<String, FilterDef> filterDefinitions = new HashMap<String, FilterDef>();
    private final FilterCachingStrategy filterCachingStrategy;
    private Map<String, Analyzer> analyzers;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final int cacheBitResultsSize;
    private volatile short barrier;
    private Map<DirectoryProvider, LuceneIndexingParameters> dirProviderIndexingParams = new HashMap<DirectoryProvider, LuceneIndexingParameters>();
    private final String indexingStrategy;

    @Override
    public BackendQueueProcessorFactory getBackendQueueProcessorFactory() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.backendQueueProcessorFactory;
    }

    @Override
    public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
        this.backendQueueProcessorFactory = backendQueueProcessorFactory;
    }

    public SearchFactoryImpl(SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        this.indexingStrategy = SearchFactoryImpl.defineIndexingStrategy(cfg);
        this.initDocumentBuilders(cfg, reflectionManager);
        Set<Class<?>> indexedClasses = this.documentBuilders.keySet();
        for (DocumentBuilder<?> builder : this.documentBuilders.values()) {
            builder.postInitialize(indexedClasses);
        }
        for (DocumentBuilder<?> builder : this.containedInOnlyBuilders.values()) {
            builder.postInitialize(indexedClasses);
        }
        this.worker = WorkerFactory.createWorker(cfg, this);
        this.readerProvider = ReaderProviderFactory.createReaderProvider(cfg, this);
        this.filterCachingStrategy = SearchFactoryImpl.buildFilterCachingStrategy(cfg.getProperties());
        this.cacheBitResultsSize = ConfigurationParseHelper.getIntValue(cfg.getProperties(), "hibernate.search.filter.cache_bit_results.size", 5);
        this.barrier = 1;
    }

    private static String defineIndexingStrategy(SearchConfiguration cfg) {
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", "event");
        if (!"event".equals(indexingStrategy) && !"manual".equals(indexingStrategy)) {
            throw new SearchException("hibernate.search.indexing_strategy unknown: " + indexingStrategy);
        }
        return indexingStrategy;
    }

    @Override
    public String getIndexingStrategy() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.indexingStrategy;
    }

    @Override
    public void close() {
        if (this.barrier != 0) {
            // empty if block
        }
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.worker.close();
            }
            catch (Exception e) {
                log.error("Worker raises an exception on close()", (Throwable)e);
            }
            try {
                this.readerProvider.destroy();
            }
            catch (Exception e) {
                log.error("ReaderProvider raises an exception on destroy()", (Throwable)e);
            }
            for (DirectoryProvider<?> dp : this.getDirectoryProviders()) {
                try {
                    dp.stop();
                }
                catch (Exception e) {
                    log.error("DirectoryProvider raises an exception on stop() ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void addClassToDirectoryProvider(Class<?> clazz, DirectoryProvider<?> directoryProvider) {
        DirectoryProviderData data = this.dirProviderData.get(directoryProvider);
        if (data == null) {
            data = new DirectoryProviderData();
            this.dirProviderData.put(directoryProvider, data);
        }
        data.classes.add(clazz);
    }

    @Override
    public Set<Class<?>> getClassesInDirectoryProvider(DirectoryProvider<?> directoryProvider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return Collections.unmodifiableSet(this.dirProviderData.get(directoryProvider).classes);
    }

    private void bindFilterDefs(XClass mappedXClass) {
        FullTextFilterDefs defsAnn;
        FullTextFilterDef defAnn = (FullTextFilterDef)mappedXClass.getAnnotation(FullTextFilterDef.class);
        if (defAnn != null) {
            this.bindFilterDef(defAnn, mappedXClass);
        }
        if ((defsAnn = (FullTextFilterDefs)mappedXClass.getAnnotation(FullTextFilterDefs.class)) != null) {
            for (FullTextFilterDef def : defsAnn.value()) {
                this.bindFilterDef(def, mappedXClass);
            }
        }
    }

    private void bindFilterDef(FullTextFilterDef defAnn, XClass mappedXClass) {
        if (this.filterDefinitions.containsKey(defAnn.name())) {
            throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name() + ": " + mappedXClass.getName());
        }
        FilterDef filterDef = new FilterDef(defAnn);
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        this.filterDefinitions.put(defAnn.name(), filterDef);
    }

    @Override
    public Map<Class<?>, DocumentBuilder<?>> getDocumentBuilders() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.documentBuilders;
    }

    @Override
    public <T> DocumentBuilder<T> getDocumentBuilder(Class<T> entityType) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.documentBuilders.get(entityType);
    }

    @Override
    public <T> DocumentBuilder<T> getContainedInOnlyBuilder(Class<T> entityType) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.containedInOnlyBuilders.get(entityType);
    }

    @Override
    public Set<DirectoryProvider<?>> getDirectoryProviders() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.keySet();
    }

    @Override
    public Worker getWorker() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.worker;
    }

    @Override
    public void addOptimizerStrategy(DirectoryProvider<?> provider, OptimizerStrategy optimizerStrategy) {
        DirectoryProviderData data = this.dirProviderData.get(provider);
        if (data == null) {
            data = new DirectoryProviderData();
            this.dirProviderData.put(provider, data);
        }
        data.optimizerStrategy = optimizerStrategy;
    }

    @Override
    public void addIndexingParameters(DirectoryProvider<?> provider, LuceneIndexingParameters indexingParams) {
        this.dirProviderIndexingParams.put(provider, indexingParams);
    }

    @Override
    public OptimizerStrategy getOptimizerStrategy(DirectoryProvider<?> provider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.get(provider).optimizerStrategy;
    }

    @Override
    public LuceneIndexingParameters getIndexingParameters(DirectoryProvider<?> provider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderIndexingParams.get(provider);
    }

    @Override
    public ReaderProvider getReaderProvider() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.readerProvider;
    }

    @Override
    public DirectoryProvider[] getDirectoryProviders(Class<?> entity) {
        DocumentBuilder<?> documentBuilder;
        if (this.barrier != 0) {
            // empty if block
        }
        return (documentBuilder = this.getDocumentBuilder(entity)) == null ? null : documentBuilder.getDirectoryProviders();
    }

    @Override
    public void optimize() {
        if (this.barrier != 0) {
            // empty if block
        }
        Set<Class<?>> clazzs = this.getDocumentBuilders().keySet();
        for (Class<?> clazz : clazzs) {
            this.optimize(clazz);
        }
    }

    @Override
    public void optimize(Class entityType) {
        if (this.barrier != 0) {
            // empty if block
        }
        if (!this.getDocumentBuilders().containsKey(entityType)) {
            throw new SearchException("Entity not indexed: " + entityType);
        }
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>(1);
        queue.add(new OptimizeLuceneWork(entityType));
        this.getBackendQueueProcessorFactory().getProcessor(queue).run();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        Analyzer analyzer;
        if (this.barrier != 0) {
            // empty if block
        }
        if ((analyzer = this.analyzers.get(name)) == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzer;
    }

    public Analyzer getAnalyzer(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("A class has to be specified for retrieving a scoped analyzer");
        }
        DocumentBuilder<?> builder = this.documentBuilders.get(clazz);
        if (builder == null) {
            throw new IllegalArgumentException("Entity for which to retrieve the scoped analyzer is not an @Indexed entity: " + clazz.getName());
        }
        return builder.getAnalyzer();
    }

    private void initDocumentBuilders(SearchConfiguration cfg, ReflectionManager reflectionManager) {
        InitContext context = new InitContext(cfg);
        Iterator<Class<?>> iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        while (iter.hasNext()) {
            XClass mappedXClass;
            Class<?> mappedClass = iter.next();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                DirectoryProviderFactory.DirectoryProviders providers = factory.createDirectoryProviders(mappedXClass, cfg, this, reflectionManager);
                DocumentBuilder documentBuilder = new DocumentBuilder(mappedXClass, context, providers.getProviders(), providers.getSelectionStrategy(), reflectionManager);
                this.documentBuilders.put(mappedClass, documentBuilder);
            } else {
                DocumentBuilder documentBuilder = new DocumentBuilder(mappedXClass, context, reflectionManager);
                if (documentBuilder.getEntityState() != EntityState.NON_INDEXABLE) {
                    this.containedInOnlyBuilders.put(mappedClass, documentBuilder);
                }
            }
            this.bindFilterDefs(mappedXClass);
        }
        this.analyzers = context.initLazyAnalyzers();
        factory.startDirectoryProviders();
    }

    private static FilterCachingStrategy buildFilterCachingStrategy(Properties properties) {
        FilterCachingStrategy filterCachingStrategy;
        String impl = properties.getProperty("hibernate.search.filter.cache_strategy");
        if (StringHelper.isEmpty((String)impl) || "mru".equalsIgnoreCase(impl)) {
            filterCachingStrategy = new MRUFilterCachingStrategy();
        } else {
            try {
                Class filterCachingStrategyClass = ReflectHelper.classForName((String)impl, SearchFactoryImpl.class);
                filterCachingStrategy = (FilterCachingStrategy)filterCachingStrategyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find filterCachingStrategy class: " + impl, e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to instantiate filterCachingStrategy class: " + impl, e);
            }
            catch (InstantiationException e) {
                throw new SearchException("Unable to instantiate filterCachingStrategy class: " + impl, e);
            }
        }
        filterCachingStrategy.initialize(properties);
        return filterCachingStrategy;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.filterCachingStrategy;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.filterDefinitions.get(name);
    }

    @Override
    public ReentrantLock getDirectoryProviderLock(DirectoryProvider<?> dp) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.get(dp).dirLock;
    }

    @Override
    public void addDirectoryProvider(DirectoryProvider<?> provider) {
        this.dirProviderData.put(provider, new DirectoryProviderData());
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.cacheBitResultsSize;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }

    private static class DirectoryProviderData {
        public final ReentrantLock dirLock = new ReentrantLock();
        public OptimizerStrategy optimizerStrategy;
        public Set<Class<?>> classes = new HashSet(2);

        private DirectoryProviderData() {
        }
    }
}

