/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderHelper;
import org.hibernate.search.util.FileHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSSlaveDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static final Logger log = LoggerFactory.make();
    private final Timer timer = new Timer(true);
    private volatile int current;
    private FSDirectory directory1;
    private FSDirectory directory2;
    private String indexName;
    private long copyChunkSize;
    private File sourceIndexDir;
    private File indexDir;
    private String directoryProviderName;
    private Properties properties;

    @Override
    public void initialize(String directoryProviderName, Properties properties, SearchFactoryImplementor searchFactoryImplementor) {
        this.properties = properties;
        this.directoryProviderName = directoryProviderName;
        this.sourceIndexDir = DirectoryProviderHelper.getSourceDirectory(directoryProviderName, properties, false);
        if (!new File(this.sourceIndexDir, "current1").exists() && !new File(this.sourceIndexDir, "current2").exists()) {
            throw new IllegalStateException("No current marker in source directory");
        }
        log.debug("Source directory: {}", (Object)this.sourceIndexDir.getPath());
        this.indexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, true);
        log.debug("Index directory: {}", (Object)this.indexDir.getPath());
        try {
            this.indexName = this.indexDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
        this.copyChunkSize = DirectoryProviderHelper.getCopyBufferSize(directoryProviderName, properties);
        this.current = 0;
    }

    @Override
    public void start() {
        int readCurrentState = this.current;
        int currentToBe = 0;
        try {
            this.directory1 = DirectoryProviderHelper.createFSIndex(new File(this.indexDir, "1"));
            this.directory2 = DirectoryProviderHelper.createFSIndex(new File(this.indexDir, "2"));
            File currentMarker = new File(this.indexDir, "current1");
            File current2Marker = new File(this.indexDir, "current2");
            if (currentMarker.exists()) {
                currentToBe = 1;
                if (current2Marker.exists()) {
                    current2Marker.delete();
                }
            } else if (current2Marker.exists()) {
                currentToBe = 2;
            } else {
                int sourceCurrent;
                log.debug("Setting directory 1 as current");
                currentToBe = 1;
                File destinationFile = new File(this.indexDir, Integer.valueOf(readCurrentState).toString());
                if (new File(this.sourceIndexDir, "current1").exists()) {
                    sourceCurrent = 1;
                } else if (new File(this.sourceIndexDir, "current2").exists()) {
                    sourceCurrent = 2;
                } else {
                    throw new AssertionFailure("No current file marker found in source directory: " + this.sourceIndexDir.getPath());
                }
                try {
                    FileHelper.synchronize(new File(this.sourceIndexDir, String.valueOf(sourceCurrent)), destinationFile, true, this.copyChunkSize);
                }
                catch (IOException e) {
                    throw new SearchException("Unable to synchronize directory: " + this.indexName, e);
                }
                if (!currentMarker.createNewFile()) {
                    throw new SearchException("Unable to create the directory marker file: " + this.indexName);
                }
            }
            log.debug("Current directory: {}", (Object)currentToBe);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + this.directoryProviderName, e);
        }
        TriggerTask task = new TriggerTask(this.sourceIndexDir, this.indexDir);
        long period = DirectoryProviderHelper.getRefreshPeriod(this.properties, this.directoryProviderName);
        this.timer.scheduleAtFixedRate((TimerTask)task, period, period);
        this.current = currentToBe;
    }

    @Override
    public FSDirectory getDirectory() {
        int readState = this.current;
        if (readState == 1) {
            return this.directory1;
        }
        if (readState == 2) {
            return this.directory2;
        }
        throw new AssertionFailure("Illegal current directory: " + readState);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSSlaveDirectoryProvider)) {
            return false;
        }
        FSSlaveDirectoryProvider other = (FSSlaveDirectoryProvider)obj;
        int readCurrentState = this.current;
        readCurrentState = other.current;
        return this.indexName.equals(other.indexName);
    }

    public int hashCode() {
        int readCurrentState = this.current;
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }

    @Override
    public void stop() {
        int readCurrentState = this.current;
        this.timer.cancel();
        try {
            this.directory1.close();
        }
        catch (Exception e) {
            log.error("Unable to properly close Lucene directory {}" + this.directory1.getFile(), (Throwable)e);
        }
        try {
            this.directory2.close();
        }
        catch (Exception e) {
            log.error("Unable to properly close Lucene directory {}" + this.directory2.getFile(), (Throwable)e);
        }
    }

    class CopyDirectory
    implements Runnable {
        private final File source;
        private final File destination;
        private final AtomicBoolean inProgress = new AtomicBoolean(false);

        public CopyDirectory(File sourceIndexDir, File destination) {
            this.source = sourceIndexDir;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            try {
                File sourceFile;
                int index;
                int oldIndex = FSSlaveDirectoryProvider.this.current;
                int n = index = oldIndex == 1 ? 2 : 1;
                if (new File(this.source, "current1").exists()) {
                    sourceFile = new File(this.source, "1");
                } else if (new File(this.source, "current2").exists()) {
                    sourceFile = new File(this.source, "2");
                } else {
                    log.error("Unable to determine current in source directory");
                    return;
                }
                File destinationFile = new File(this.destination, Integer.valueOf(index).toString());
                try {
                    log.trace("Copying {} into {}", (Object)sourceFile, (Object)destinationFile);
                    FileHelper.synchronize(sourceFile, destinationFile, true, FSSlaveDirectoryProvider.this.copyChunkSize);
                    FSSlaveDirectoryProvider.this.current = index;
                }
                catch (IOException e) {
                    log.error("Unable to synchronize " + FSSlaveDirectoryProvider.this.indexName, (Throwable)e);
                    this.inProgress.set(false);
                    return;
                }
                if (!new File(FSSlaveDirectoryProvider.this.indexName, "current" + oldIndex).delete()) {
                    log.warn("Unable to remove previous marker file in " + FSSlaveDirectoryProvider.this.indexName);
                }
                try {
                    new File(FSSlaveDirectoryProvider.this.indexName, "current" + index).createNewFile();
                }
                catch (IOException e) {
                    log.warn("Unable to create current marker file in " + FSSlaveDirectoryProvider.this.indexName, (Throwable)e);
                }
            }
            finally {
                this.inProgress.set(false);
            }
            log.trace("Copy for {} took {} ms", (Object)FSSlaveDirectoryProvider.this.indexName, (Object)(System.currentTimeMillis() - start));
        }
    }

    class TriggerTask
    extends TimerTask {
        private final Executor executor = Executors.newSingleThreadExecutor();
        private final CopyDirectory copyTask;

        public TriggerTask(File sourceIndexDir, File destination) {
            this.copyTask = new CopyDirectory(sourceIndexDir, destination);
        }

        public void run() {
            if (this.copyTask.inProgress.compareAndSet(false, true)) {
                this.executor.execute(this.copyTask);
            } else if (log.isTraceEnabled()) {
                int unneeded = FSSlaveDirectoryProvider.this.current;
                log.trace("Skipping directory synchronization, previous work still in progress: {}", (Object)FSSlaveDirectoryProvider.this.indexName);
            }
        }
    }
}

