/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.Serializable;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.Destructible;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.event.ContextHolder;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
Initializable,
Destructible {
    private static final Logger log = LoggerFactory.make();
    protected boolean used;
    protected SearchFactoryImplementor searchFactoryImplementor;

    public void initialize(Configuration cfg) {
        this.searchFactoryImplementor = ContextHolder.getOrBuildSearchFactory(cfg);
        String indexingStrategy = this.searchFactoryImplementor.getIndexingStrategy();
        if ("event".equals(indexingStrategy)) {
            this.used = this.searchFactoryImplementor.getDocumentBuilders().size() != 0;
        } else if ("manual".equals(indexingStrategy)) {
            this.used = false;
        }
    }

    public SearchFactoryImplementor getSearchFactoryImplementor() {
        return this.searchFactoryImplementor;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.used) {
            Class<?> entityType = event.getEntity().getClass();
            if (this.searchFactoryImplementor.getDocumentBuilders().containsKey(entityType) || this.searchFactoryImplementor.getContainedInOnlyBuilder(entityType) != null) {
                this.processWork(event.getEntity(), event.getId(), WorkType.DELETE, (AbstractEvent)event);
            }
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        if (this.used && (this.searchFactoryImplementor.getDocumentBuilder((entity = event.getEntity()).getClass()) != null || this.searchFactoryImplementor.getContainedInOnlyBuilder(entity.getClass()) != null)) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.ADD, (AbstractEvent)event);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity;
        if (this.used && (this.searchFactoryImplementor.getDocumentBuilder((entity = event.getEntity()).getClass()) != null || this.searchFactoryImplementor.getContainedInOnlyBuilder(entity.getClass()) != null)) {
            Serializable id = event.getId();
            this.processWork(entity, id, WorkType.UPDATE, (AbstractEvent)event);
        }
    }

    protected void processWork(Object entity, Serializable id, WorkType workType, AbstractEvent event) {
        Work work = new Work(entity, id, workType);
        EventSourceTransactionContext transactionContext = new EventSourceTransactionContext(event.getSession());
        this.searchFactoryImplementor.getWorker().performWork(work, transactionContext);
    }

    public void cleanup() {
        this.searchFactoryImplementor.close();
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    protected void processCollectionEvent(AbstractCollectionEvent event) {
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        if (this.used && (this.searchFactoryImplementor.getDocumentBuilder(entity.getClass()) != null || this.searchFactoryImplementor.getContainedInOnlyBuilder(entity.getClass()) != null)) {
            Serializable id = this.getId(entity, event);
            if (id == null) {
                log.warn("Unable to reindex entity on collection change, id cannot be extracted: {}", (Object)event.getAffectedOwnerEntityName());
                return;
            }
            this.processWork(entity, id, WorkType.COLLECTION, (AbstractEvent)event);
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }
}

