/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.configuration.IndexWriterSetting;
import org.hibernate.search.backend.configuration.MaskedProperty;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class LuceneIndexingParameters
implements Serializable {
    private static final long serialVersionUID = 5424606407623591663L;
    private static final Logger log = LoggerFactory.make();
    public static final String EXPLICIT_DEFAULT_VALUE = "default";
    public static final String BATCH = "batch";
    public static final String TRANSACTION = "transaction";
    public static final String PROP_GROUP = "indexwriter";
    private final ParameterSet transactionIndexParameters;
    private final ParameterSet batchIndexParameters;

    public LuceneIndexingParameters(Properties sourceProps) {
        MaskedProperty indexingParameters = new MaskedProperty(sourceProps, PROP_GROUP, sourceProps);
        MaskedProperty transactionProps = new MaskedProperty(indexingParameters, TRANSACTION);
        MaskedProperty batchProps = new MaskedProperty(indexingParameters, BATCH, transactionProps);
        this.transactionIndexParameters = new ParameterSet(transactionProps, TRANSACTION);
        this.batchIndexParameters = new ParameterSet(batchProps, BATCH);
        this.doSanityChecks(this.transactionIndexParameters, this.batchIndexParameters);
    }

    private void doSanityChecks(ParameterSet transParams, ParameterSet batchParams) {
        Integer maxFieldLengthBatch;
        Integer maxFieldLengthTransaction;
        if (log.isWarnEnabled() && this.notEquals(maxFieldLengthTransaction = transParams.parameters.get(IndexWriterSetting.MAX_FIELD_LENGTH), maxFieldLengthBatch = transParams.parameters.get(IndexWriterSetting.MAX_FIELD_LENGTH))) {
            log.warn("The max_field_length value configured for transaction is different than the value configured for batch.");
        }
    }

    private boolean notEquals(Integer a, Integer b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null && b != null) {
            return true;
        }
        if (a != null && b == null) {
            return true;
        }
        return a.intValue() != b.intValue();
    }

    public ParameterSet getTransactionIndexParameters() {
        return this.transactionIndexParameters;
    }

    public ParameterSet getBatchIndexParameters() {
        return this.batchIndexParameters;
    }

    public void applyToWriter(IndexWriter writer, boolean batch) {
        if (batch) {
            this.getBatchIndexParameters().applyToWriter(writer);
        } else {
            this.getTransactionIndexParameters().applyToWriter(writer);
        }
    }

    public static class ParameterSet
    implements Serializable {
        private static final long serialVersionUID = -6121723702279869524L;
        final Map<IndexWriterSetting, Integer> parameters = new EnumMap<IndexWriterSetting, Integer>(IndexWriterSetting.class);

        public ParameterSet(Properties prop, String paramName) {
            for (IndexWriterSetting t : IndexWriterSetting.values()) {
                String key = t.getKey();
                String value = prop.getProperty(key);
                if (value == null || LuceneIndexingParameters.EXPLICIT_DEFAULT_VALUE.equalsIgnoreCase(value)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Set indexwriter parameter " + paramName + "." + key + " to value : " + value);
                }
                this.parameters.put(t, t.parseVal(value));
            }
        }

        public void applyToWriter(IndexWriter writer) {
            for (Map.Entry<IndexWriterSetting, Integer> entry : this.parameters.entrySet()) {
                try {
                    entry.getKey().applySetting(writer, entry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SearchException("Illegal IndexWriter setting " + entry.getKey().getKey() + " " + e.getMessage(), e);
                }
            }
        }

        public Integer getCurrentValueFor(IndexWriterSetting ws) {
            return this.parameters.get(ws);
        }

        public void setCurrentValueFor(IndexWriterSetting ws, Integer newValue) {
            if (newValue == null) {
                this.parameters.remove(ws);
            } else {
                this.parameters.put(ws, newValue);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterSet other = (ParameterSet)obj;
            return !(this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters));
        }
    }
}

