/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.ObjectLoader;
import org.hibernate.search.engine.ProjectionLoader;
import org.hibernate.search.engine.QueryLoader;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.ChainedFilter;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.query.FullTextFilterImpl;
import org.hibernate.search.query.IteratorImpl;
import org.hibernate.search.query.ScrollableResultsImpl;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.ContextHelper;
import org.hibernate.transform.ResultTransformer;

public class FullTextQueryImpl
extends AbstractQueryImpl
implements FullTextQuery {
    private static final Log log = LogFactory.getLog(FullTextQueryImpl.class);
    private org.apache.lucene.search.Query luceneQuery;
    private Class[] classes;
    private Set<Class> classesAndSubclasses;
    private Integer firstResult;
    private Integer maxResults;
    private Integer resultSize;
    private Sort sort;
    private Filter filter;
    private Criteria criteria;
    private String[] indexProjection;
    private ResultTransformer resultTransformer;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Map<String, FullTextFilterImpl> filterDefinitions;
    private int fetchSize = 1;
    private static Loader noLoader = new Loader(){

        public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        }

        public Object load(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        public List load(EntityInfo ... entityInfos) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }
    };

    public FullTextQueryImpl(org.apache.lucene.search.Query query, Class[] classes, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(query.toString(), null, session, parameterMetadata);
        this.luceneQuery = query;
        this.classes = classes;
    }

    public FullTextQuery setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public FullTextQuery setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Iterator iterate() throws HibernateException {
        SearchFactoryImplementor searchFactoryImplementor = ContextHelper.getSearchFactoryBySFI(this.session);
        IndexSearcher searcher = this.buildSearcher(searchFactoryImplementor);
        if (searcher == null) {
            return new IteratorImpl(new ArrayList<EntityInfo>(0), noLoader);
        }
        try {
            Hits hits = this.getHits((Searcher)searcher);
            int first = this.first();
            int max = this.max(first, hits);
            Session sess = (Session)this.session;
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = new DocumentExtractor(searchFactoryImplementor, this.indexProjection);
            for (int index = first; index <= max; ++index) {
                infos.add(extractor.extract(hits, index));
            }
            Loader loader = this.getLoader(sess, searchFactoryImplementor);
            IteratorImpl iteratorImpl = new IteratorImpl(infos, loader);
            return iteratorImpl;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            try {
                searchFactoryImplementor.getReaderProvider().closeReader(searcher.getIndexReader());
            }
            catch (SearchException e) {
                log.warn((Object)("Unable to properly close searcher during lucene query: " + this.getQueryString()), (Throwable)e);
            }
        }
    }

    private Loader getLoader(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        if (this.indexProjection != null) {
            ProjectionLoader loader = new ProjectionLoader();
            loader.init(session, searchFactoryImplementor, this.resultTransformer, this.indexProjection);
            return loader;
        }
        if (this.criteria != null) {
            if (this.classes.length > 1) {
                throw new SearchException("Cannot mix criteria and multiple entity types");
            }
            if (this.criteria instanceof CriteriaImpl) {
                String targetEntity = ((CriteriaImpl)this.criteria).getEntityOrClassName();
                if (this.classes.length == 1 && !this.classes[0].getName().equals(targetEntity)) {
                    throw new SearchException("Criteria query entity should match query entity");
                }
                try {
                    Class entityType = ReflectHelper.classForName((String)targetEntity);
                    this.classes = new Class[]{entityType};
                }
                catch (ClassNotFoundException e) {
                    throw new SearchException("Unable to load entity class from criteria: " + targetEntity, e);
                }
            }
            QueryLoader loader = new QueryLoader();
            loader.init(session, searchFactoryImplementor);
            loader.setEntityType(this.classes[0]);
            loader.setCriteria(this.criteria);
            return loader;
        }
        if (this.classes.length == 1) {
            QueryLoader loader = new QueryLoader();
            loader.init(session, searchFactoryImplementor);
            loader.setEntityType(this.classes[0]);
            return loader;
        }
        ObjectLoader objectLoader = new ObjectLoader();
        objectLoader.init(session, searchFactoryImplementor);
        return objectLoader;
    }

    public ScrollableResults scroll() throws HibernateException {
        SearchFactoryImplementor searchFactory = ContextHelper.getSearchFactoryBySFI(this.session);
        IndexSearcher searcher = this.buildSearcher(searchFactory);
        try {
            Hits hits = this.getHits((Searcher)searcher);
            int first = this.first();
            int max = this.max(first, hits);
            DocumentExtractor extractor = new DocumentExtractor(searchFactory, this.indexProjection);
            Loader loader = this.getLoader((Session)this.session, searchFactory);
            return new ScrollableResultsImpl(searcher, hits, first, max, this.fetchSize, extractor, loader, searchFactory);
        }
        catch (IOException e) {
            try {
                searchFactory.getReaderProvider().closeReader(searcher.getIndexReader());
            }
            catch (SearchException ee) {
                // empty catch block
            }
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        return this.scroll();
    }

    public List list() throws HibernateException {
        SearchFactoryImplementor searchFactoryImplementor = ContextHelper.getSearchFactoryBySFI(this.session);
        IndexSearcher searcher = this.buildSearcher(searchFactoryImplementor);
        if (searcher == null) {
            return new ArrayList(0);
        }
        try {
            Hits hits = this.getHits((Searcher)searcher);
            int first = this.first();
            int max = this.max(first, hits);
            Session sess = (Session)this.session;
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = new DocumentExtractor(searchFactoryImplementor, this.indexProjection);
            for (int index = first; index <= max; ++index) {
                infos.add(extractor.extract(hits, index));
            }
            Loader loader = this.getLoader(sess, searchFactoryImplementor);
            List list = loader.load(infos.toArray(new EntityInfo[infos.size()]));
            if (this.resultTransformer == null || loader instanceof ProjectionLoader) {
                List list2 = list;
                return list2;
            }
            List list3 = this.resultTransformer.transformList(list);
            return list3;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            try {
                searchFactoryImplementor.getReaderProvider().closeReader(searcher.getIndexReader());
            }
            catch (SearchException e) {
                log.warn((Object)("Unable to properly close searcher during lucene query: " + this.getQueryString()), (Throwable)e);
            }
        }
    }

    private Hits getHits(Searcher searcher) throws IOException {
        org.apache.lucene.search.Query query = this.filterQueryByClasses(this.luceneQuery);
        this.buildFilters();
        Hits hits = searcher.search(query, this.filter, this.sort);
        this.setResultSize(hits);
        return hits;
    }

    private void buildFilters() {
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        if (this.filterDefinitions != null && this.filterDefinitions.size() > 0) {
            ChainedFilter chainedFilter = new ChainedFilter();
            for (FullTextFilterImpl filterDefinition : this.filterDefinitions.values()) {
                Filter filter;
                Object instance;
                FilterDef def = searchFactoryImplementor.getFilterDefinition(filterDefinition.getName());
                Class implClass = def.getImpl();
                try {
                    instance = implClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), e);
                }
                catch (IllegalAccessException e) {
                    throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), e);
                }
                for (Map.Entry<String, Object> entry : filterDefinition.getParameters().entrySet()) {
                    def.invoke(entry.getKey(), instance, entry.getValue());
                }
                if (def.isCache() && def.getKeyMethod() == null && filterDefinition.getParameters().size() > 0) {
                    throw new SearchException("Filter with parameters and no @Key method: " + filterDefinition.getName());
                }
                FilterKey key = null;
                if (def.isCache()) {
                    if (def.getKeyMethod() == null) {
                        key = new FilterKey(){

                            public int hashCode() {
                                return this.getImpl().hashCode();
                            }

                            public boolean equals(Object obj) {
                                if (!(obj instanceof FilterKey)) {
                                    return false;
                                }
                                FilterKey that = (FilterKey)obj;
                                return this.getImpl().equals(that.getImpl());
                            }
                        };
                    } else {
                        try {
                            key = (FilterKey)def.getKeyMethod().invoke(instance, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
                        }
                        catch (InvocationTargetException e) {
                            throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
                        }
                        catch (ClassCastException e) {
                            throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
                        }
                    }
                    key.setImpl(def.getImpl());
                }
                Filter filter2 = filter = def.isCache() ? searchFactoryImplementor.getFilterCachingStrategy().getCachedFilter(key) : null;
                if (filter == null) {
                    if (def.getFactoryMethod() != null) {
                        try {
                            filter = (Filter)def.getFactoryMethod().invoke(instance, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                        }
                        catch (InvocationTargetException e) {
                            throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                        }
                        catch (ClassCastException e) {
                            throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                        }
                    }
                    try {
                        filter = (Filter)instance;
                    }
                    catch (ClassCastException e) {
                        throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
                    }
                    if (def.isCache()) {
                        searchFactoryImplementor.getFilterCachingStrategy().addCachedFilter(key, filter);
                    }
                }
                chainedFilter.addFilter(filter);
            }
            if (this.filter != null) {
                chainedFilter.addFilter(this.filter);
            }
            this.filter = chainedFilter;
        }
    }

    private org.apache.lucene.search.Query filterQueryByClasses(org.apache.lucene.search.Query luceneQuery) {
        if (this.classesAndSubclasses == null) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add((org.apache.lucene.search.Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((org.apache.lucene.search.Query)classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private int max(int first, Hits hits) {
        return this.maxResults == null ? hits.length() - 1 : (this.maxResults + first < hits.length() ? first + this.maxResults - 1 : hits.length() - 1);
    }

    private int first() {
        return this.firstResult != null ? this.firstResult : 0;
    }

    private IndexSearcher buildSearcher(SearchFactoryImplementor searchFactoryImplementor) {
        Map<Class, DocumentBuilder<Object>> builders = searchFactoryImplementor.getDocumentBuilders();
        ArrayList<DirectoryProvider> directories = new ArrayList<DirectoryProvider>();
        if (this.classes == null || this.classes.length == 0) {
            for (DocumentBuilder<Object> builder : builders.values()) {
                DirectoryProvider[] directoryProviders;
                for (DirectoryProvider provider : directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards()) {
                    if (directories.contains(provider)) continue;
                    directories.add(provider);
                }
            }
            this.classesAndSubclasses = null;
        } else {
            HashSet<Class> involvedClasses = new HashSet<Class>(this.classes.length);
            Collections.addAll(involvedClasses, this.classes);
            for (Class clazz : this.classes) {
                DocumentBuilder<Object> builder = builders.get(clazz);
                if (builder == null) continue;
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class clazz : involvedClasses) {
                DirectoryProvider[] directoryProviders;
                DocumentBuilder<Object> builder = builders.get(clazz);
                if (builder == null) {
                    throw new HibernateException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                for (DirectoryProvider provider : directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards()) {
                    if (directories.contains(provider)) continue;
                    directories.add(provider);
                }
            }
            this.classesAndSubclasses = involvedClasses;
        }
        DirectoryProvider[] directoryProviders = directories.toArray(new DirectoryProvider[directories.size()]);
        return new IndexSearcher(searchFactoryImplementor.getReaderProvider().openReader(directoryProviders));
    }

    private void setResultSize(Hits hits) {
        this.resultSize = hits.length();
    }

    public int getResultSize() {
        if (this.resultSize == null) {
            SearchFactoryImplementor searchFactoryImplementor = ContextHelper.getSearchFactoryBySFI(this.session);
            IndexSearcher searcher = this.buildSearcher(searchFactoryImplementor);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    Hits hits = this.getHits((Searcher)searcher);
                    this.resultSize = hits.length();
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to query Lucene index", (Throwable)e);
                }
                finally {
                    try {
                        searchFactoryImplementor.getReaderProvider().closeReader(searcher.getIndexReader());
                    }
                    catch (SearchException e) {
                        log.warn((Object)("Unable to properly close searcher during lucene query: " + this.getQueryString()), (Throwable)e);
                    }
                }
            }
        }
        return this.resultSize;
    }

    public FullTextQuery setCriteriaQuery(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public FullTextQuery setProjection(String ... fields) {
        this.indexProjection = fields == null || fields.length == 0 ? null : fields;
        return this;
    }

    public FullTextQuery setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
        return this;
    }

    public FullTextQuery setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
        return this;
    }

    public FullTextQuery setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("'fetch size' parameter less than or equals to 0");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public FullTextQuery setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        this.resultTransformer = transformer;
        return this;
    }

    public int executeUpdate() throws HibernateException {
        throw new HibernateException("Not supported operation");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        return null;
    }

    protected Map getLockModes() {
        return null;
    }

    public FullTextFilter enableFullTextFilter(String name) {
        FullTextFilterImpl filterDefinition;
        if (this.filterDefinitions == null) {
            this.filterDefinitions = new HashMap<String, FullTextFilterImpl>();
        }
        if ((filterDefinition = this.filterDefinitions.get(name)) != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.getSearchFactoryImplementor().getFilterDefinition(name);
        if (filterDef == null) {
            throw new SearchException("Unkown @FullTextFilter: " + name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    public void disableFullTextFilter(String name) {
        this.filterDefinitions.remove(name);
    }

    private SearchFactoryImplementor getSearchFactoryImplementor() {
        if (this.searchFactoryImplementor == null) {
            this.searchFactoryImplementor = ContextHelper.getSearchFactoryBySFI(this.session);
        }
        return this.searchFactoryImplementor;
    }
}

