/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.SearchFactoryImpl;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.FSDirectoryProvider;
import org.hibernate.search.store.IdHashShardingStrategy;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.NotShardedStrategy;
import org.hibernate.search.store.optimization.IncrementalOptimizerStrategy;
import org.hibernate.search.store.optimization.NoOpOptimizerStrategy;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryProviderFactory {
    public List<DirectoryProvider<?>> providers = new ArrayList();
    private static String LUCENE_PREFIX = "hibernate.search.";
    private static String LUCENE_DEFAULT = LUCENE_PREFIX + "default.";
    private static String DEFAULT_DIRECTORY_PROVIDER = FSDirectoryProvider.class.getName();
    private static final String MERGE_FACTOR = "merge_factor";
    private static final String MAX_MERGE_DOCS = "max_merge_docs";
    private static final String MAX_BUFFERED_DOCS = "max_buffered_docs";
    private static final String BATCH = "batch.";
    private static final String TRANSACTION = "transaction.";
    private static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final String NBR_OF_SHARDS = "sharding_strategy.nbr_of_shards";

    public DirectoryProviders createDirectoryProviders(XClass entity, Configuration cfg, SearchFactoryImplementor searchFactoryImplementor) {
        IndexShardingStrategy shardingStrategy;
        String directoryProviderName = DirectoryProviderFactory.getDirectoryProviderName(entity, cfg);
        Properties[] indexProps = DirectoryProviderFactory.getDirectoryProperties(cfg, directoryProviderName);
        int nbrOfProviders = indexProps.length;
        DirectoryProvider[] providers = new DirectoryProvider[nbrOfProviders];
        for (int index = 0; index < nbrOfProviders; ++index) {
            String providerName = nbrOfProviders > 1 ? directoryProviderName + "." + index : directoryProviderName;
            providers[index] = this.createDirectoryProvider(providerName, indexProps[index], searchFactoryImplementor);
        }
        Properties shardingProperties = new Properties();
        for (Map.Entry<Object, Object> entry : indexProps[0].entrySet()) {
            if (!((String)entry.getKey()).startsWith(SHARDING_STRATEGY)) continue;
            shardingProperties.put(entry.getKey(), entry.getValue());
        }
        String shardingStrategyName = shardingProperties.getProperty(SHARDING_STRATEGY);
        if (shardingStrategyName == null) {
            shardingStrategy = indexProps.length == 1 ? new NotShardedStrategy() : new IdHashShardingStrategy();
        } else {
            try {
                Class shardigStrategyClass = ReflectHelper.classForName((String)shardingStrategyName, this.getClass());
                shardingStrategy = (IndexShardingStrategy)shardigStrategyClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find ShardingStrategy class " + shardingStrategyName + " for " + directoryProviderName, e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to create instance of ShardingStrategy class " + shardingStrategyName + " Be sure to have a no-arg constructor", e);
            }
            catch (InstantiationException e) {
                throw new SearchException("Unable to create instance of ShardingStrategy class " + shardingStrategyName + " Be sure to have a no-arg constructor", e);
            }
            catch (ClassCastException e) {
                throw new SearchException("ShardingStrategy class does not implements DirecotryProviderShardingStrategy: " + shardingStrategyName, e);
            }
        }
        shardingStrategy.initialize(shardingProperties, providers);
        return new DirectoryProviders(shardingStrategy, providers);
    }

    public void startDirectoryProviders() {
        for (DirectoryProvider<?> provider : this.providers) {
            provider.start();
        }
    }

    private DirectoryProvider<?> createDirectoryProvider(String directoryProviderName, Properties indexProps, SearchFactoryImplementor searchFactoryImplementor) {
        DirectoryProvider provider;
        String className = indexProps.getProperty("directory_provider");
        if (StringHelper.isEmpty((String)className)) {
            className = DEFAULT_DIRECTORY_PROVIDER;
        }
        try {
            Class directoryClass = ReflectHelper.classForName((String)className, DirectoryProviderFactory.class);
            provider = (DirectoryProvider)directoryClass.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Unable to instanciate directory provider: " + className, (Throwable)e);
        }
        try {
            provider.initialize(directoryProviderName, indexProps, searchFactoryImplementor);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to initialize: " + directoryProviderName, (Throwable)e);
        }
        int index = this.providers.indexOf(provider);
        if (index != -1) {
            return this.providers.get(index);
        }
        this.configureOptimizerStrategy(searchFactoryImplementor, indexProps, provider);
        this.configureIndexingParameters(searchFactoryImplementor, indexProps, provider);
        this.providers.add(provider);
        if (!searchFactoryImplementor.getLockableDirectoryProviders().containsKey(provider)) {
            searchFactoryImplementor.getLockableDirectoryProviders().put(provider, new ReentrantLock());
        }
        return provider;
    }

    private void configureOptimizerStrategy(SearchFactoryImplementor searchFactoryImplementor, Properties indexProps, DirectoryProvider<?> provider) {
        OptimizerStrategy optimizerStrategy;
        boolean incremental;
        boolean bl = incremental = indexProps.containsKey("optimizer.operation_limit.max") || indexProps.containsKey("optimizer.transaction_limit.max");
        if (incremental) {
            optimizerStrategy = new IncrementalOptimizerStrategy();
            optimizerStrategy.initialize(provider, indexProps, searchFactoryImplementor);
        } else {
            optimizerStrategy = new NoOpOptimizerStrategy();
        }
        searchFactoryImplementor.addOptimizerStrategy(provider, optimizerStrategy);
    }

    private void configureIndexingParameters(SearchFactoryImplementor searchFactoryImplementor, Properties indexProps, DirectoryProvider<?> provider) {
        LuceneIndexingParameters indexingParams = new LuceneIndexingParameters();
        String s = indexProps.getProperty("transaction.merge_factor");
        if (!StringHelper.isEmpty((String)s)) {
            try {
                indexingParams.setTransactionMergeFactor(Integer.valueOf(s));
                indexingParams.setBatchMergeFactor(Integer.valueOf(s));
            }
            catch (NumberFormatException ne) {
                throw new SearchException("Invalid value for transaction.merge_factor: " + s);
            }
        }
        if (!StringHelper.isEmpty((String)(s = indexProps.getProperty("transaction.max_merge_docs")))) {
            try {
                indexingParams.setTransactionMaxMergeDocs(Integer.valueOf(s));
                indexingParams.setBatchMaxMergeDocs(Integer.valueOf(s));
            }
            catch (NumberFormatException ne) {
                throw new SearchException("Invalid value for transaction.max_merge_docs: " + s);
            }
        }
        if (!StringHelper.isEmpty((String)(s = indexProps.getProperty("transaction.max_buffered_docs")))) {
            try {
                indexingParams.setTransactionMaxBufferedDocs(Integer.valueOf(s));
                indexingParams.setBatchMaxBufferedDocs(Integer.valueOf(s));
            }
            catch (NumberFormatException ne) {
                throw new SearchException("Invalid value for transaction.max_buffered_docs: " + s);
            }
        }
        if (!StringHelper.isEmpty((String)(s = indexProps.getProperty("batch.merge_factor")))) {
            try {
                indexingParams.setBatchMergeFactor(Integer.valueOf(s));
            }
            catch (NumberFormatException ne) {
                throw new SearchException("Invalid value for batch.merge_factor: " + s);
            }
        }
        if (!StringHelper.isEmpty((String)(s = indexProps.getProperty("batch.max_merge_docs")))) {
            try {
                indexingParams.setBatchMaxMergeDocs(Integer.valueOf(s));
            }
            catch (NumberFormatException ne) {
                throw new SearchException("Invalid value for batch.max_merge_docs: " + s);
            }
        }
        if (!StringHelper.isEmpty((String)(s = indexProps.getProperty("batch.max_buffered_docs")))) {
            try {
                indexingParams.setBatchMaxBufferedDocs(Integer.valueOf(s));
            }
            catch (NumberFormatException ne) {
                throw new SearchException("Invalid value for batch.max_buffered_docs: " + s);
            }
        }
        searchFactoryImplementor.addIndexingParmeters(provider, indexingParams);
    }

    private static Properties[] getDirectoryProperties(Configuration cfg, String directoryProviderName) {
        Properties props = cfg.getProperties();
        String indexName = LUCENE_PREFIX + directoryProviderName;
        Properties defaultProperties = new Properties();
        ArrayList<Properties> indexSpecificProps = new ArrayList<Properties>();
        Properties indexSpecificDefaultProps = new Properties(defaultProperties);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(LUCENE_DEFAULT)) {
                defaultProperties.setProperty(key.substring(LUCENE_DEFAULT.length()), (String)entry.getValue());
                continue;
            }
            if (!key.startsWith(indexName)) continue;
            String suffixedKey = key.substring(indexName.length() + 1);
            int nextDoc = suffixedKey.indexOf(46);
            int index = -1;
            if (nextDoc != -1) {
                String potentialNbr = suffixedKey.substring(0, nextDoc);
                try {
                    index = Integer.parseInt(potentialNbr);
                }
                catch (Exception e) {
                    index = -1;
                }
            }
            if (index == -1) {
                indexSpecificDefaultProps.setProperty(suffixedKey, (String)entry.getValue());
                continue;
            }
            String finalKeyName = suffixedKey.substring(nextDoc + 1);
            if (finalKeyName.startsWith(SHARDING_STRATEGY)) continue;
            DirectoryProviderFactory.ensureListSize(indexSpecificProps, index + 1);
            Properties propertiesforIndex = indexSpecificProps.get(index);
            if (propertiesforIndex == null) {
                propertiesforIndex = new Properties(indexSpecificDefaultProps);
                indexSpecificProps.set(index, propertiesforIndex);
            }
            propertiesforIndex.setProperty(finalKeyName, (String)entry.getValue());
        }
        String nbrOfShardsString = indexSpecificDefaultProps.getProperty(NBR_OF_SHARDS);
        int nbrOfShards = -1;
        if (nbrOfShardsString != null) {
            try {
                nbrOfShards = Integer.parseInt(nbrOfShardsString);
            }
            catch (NumberFormatException e) {
                throw new SearchException(indexName + "." + NBR_OF_SHARDS + " is not a number", e);
            }
        }
        if (nbrOfShards <= 0 && indexSpecificProps.size() == 0) {
            return new Properties[]{indexSpecificDefaultProps};
        }
        nbrOfShards = nbrOfShards >= indexSpecificDefaultProps.size() ? nbrOfShards : indexSpecificDefaultProps.size();
        DirectoryProviderFactory.ensureListSize(indexSpecificProps, nbrOfShards);
        for (int index = 0; index < nbrOfShards; ++index) {
            if (indexSpecificProps.get(index) != null) continue;
            indexSpecificProps.set(index, new Properties(indexSpecificDefaultProps));
        }
        return indexSpecificProps.toArray(new Properties[indexSpecificProps.size()]);
    }

    private static void ensureListSize(ArrayList<Properties> indexSpecificProps, int size) {
        indexSpecificProps.ensureCapacity(size);
        while (indexSpecificProps.size() < size) {
            indexSpecificProps.add(null);
        }
    }

    private static String getDirectoryProviderName(XClass clazz, Configuration cfg) {
        ReflectionManager reflectionManager = SearchFactoryImpl.getReflectionManager(cfg);
        PersistentClass pc = cfg.getClassMapping(clazz.getName());
        XClass rootIndex = null;
        do {
            XClass currentClazz;
            Indexed indexAnn;
            if ((indexAnn = (Indexed)(currentClazz = reflectionManager.toXClass(pc.getMappedClass())).getAnnotation(Indexed.class)) == null) continue;
            if (indexAnn.index().length() != 0) {
                return indexAnn.index();
            }
            rootIndex = currentClazz;
        } while ((pc = pc.getSuperclass()) != null);
        if (rootIndex != null) {
            return rootIndex.getName();
        }
        throw new HibernateException("Trying to extract the index name from a non @Indexed class: " + clazz.getName());
    }

    public class DirectoryProviders {
        private IndexShardingStrategy shardingStrategy;
        private DirectoryProvider[] providers;

        public DirectoryProviders(IndexShardingStrategy shardingStrategy, DirectoryProvider[] providers) {
            this.shardingStrategy = shardingStrategy;
            this.providers = providers;
        }

        public IndexShardingStrategy getSelectionStrategy() {
            return this.shardingStrategy;
        }

        public DirectoryProvider[] getProviders() {
            return this.providers;
        }
    }
}

