/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class DocumentExtractor {
    private SearchFactoryImplementor searchFactoryImplementor;
    private String[] projection;

    public DocumentExtractor(SearchFactoryImplementor searchFactoryImplementor, String ... projection) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.projection = projection;
    }

    private EntityInfo extract(Document document) {
        EntityInfo entityInfo = new EntityInfo();
        entityInfo.clazz = DocumentBuilder.getDocumentClass(document);
        entityInfo.id = DocumentBuilder.getDocumentId(this.searchFactoryImplementor, entityInfo.clazz, document);
        if (this.projection != null && this.projection.length > 0) {
            entityInfo.projection = DocumentBuilder.getDocumentFields(this.searchFactoryImplementor, entityInfo.clazz, document, this.projection);
        }
        return entityInfo;
    }

    public EntityInfo extract(Hits hits, int index) throws IOException {
        Document doc = hits.doc(index);
        EntityInfo entityInfo = this.extract(doc);
        Object[] eip = entityInfo.projection;
        if (eip != null && eip.length > 0) {
            for (int x = 0; x < this.projection.length; ++x) {
                if ("__HSearch_Score".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(hits.score(index));
                    continue;
                }
                if ("__HSearch_id".equals(this.projection[x])) {
                    eip[x] = entityInfo.id;
                    continue;
                }
                if ("__HSearch_Document".equals(this.projection[x])) {
                    eip[x] = doc;
                    continue;
                }
                if ("__HSearch_Boost".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(doc.getBoost());
                    continue;
                }
                if (!"__HSearch_This".equals(this.projection[x])) continue;
                if (entityInfo.indexesOfThis == null) {
                    entityInfo.indexesOfThis = new ArrayList<Integer>(1);
                }
                entityInfo.indexesOfThis.add(x);
            }
        }
        return entityInfo;
    }
}

