/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.LuceneWorksBuilder;
import org.hibernate.search.indexes.serialization.spi.SerializableIndex;
import org.hibernate.search.indexes.serialization.spi.SerializableStore;
import org.hibernate.search.indexes.serialization.spi.SerializableTermVector;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AvroDeserializer
implements Deserializer {
    private static final Log log = LoggerFactory.make();
    private final Protocol protocol;
    private List<Utf8> classReferences;

    public AvroDeserializer(Protocol protocol) {
        this.protocol = protocol;
    }

    public void deserialize(byte[] data, LuceneWorksBuilder hydrator) {
        GenericRecord result;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        int majorVersion = inputStream.read();
        int minorVersion = inputStream.read();
        if (AvroSerializationProvider.getMajorVersion() != majorVersion) {
            throw log.incompatibleProtocolVersion(majorVersion, minorVersion, AvroSerializationProvider.getMajorVersion(), AvroSerializationProvider.getMinorVersion());
        }
        if (AvroSerializationProvider.getMinorVersion() < minorVersion && log.isTraceEnabled()) {
            log.tracef("Parsing message from a future protocol version. Some feature might not be propagated. Message version: " + majorVersion + "." + minorVersion + ". Current protocol version: " + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion(), new Object[0]);
        }
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        GenericDatumReader reader = new GenericDatumReader(this.protocol.getType("Message"));
        try {
            result = (GenericRecord)reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw log.unableToDeserializeAvroStream((Throwable)e);
        }
        this.classReferences = this.asListOfString(result, "classReferences");
        List<GenericRecord> operations = this.asListOfGenericRecords(result, "operations");
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        for (GenericRecord operation : operations) {
            Map<String, String> analyzers;
            String schema = operation.getSchema().getName();
            if ("OptimizeAll".equals(schema)) {
                hydrator.addOptimizeAll();
                continue;
            }
            if ("PurgeAll".equals(schema)) {
                hydrator.addPurgeAllLuceneWork(this.asClass(operation, "class"));
                continue;
            }
            if ("Delete".equals(schema)) {
                this.processId(operation, hydrator);
                hydrator.addDeleteLuceneWork(this.asClass(operation, "class"), (ConversionContext)conversionContext);
                continue;
            }
            if ("Add".equals(schema)) {
                this.buildLuceneDocument(this.asGenericRecord(operation, "document"), hydrator);
                analyzers = this.getAnalyzers(operation);
                this.processId(operation, hydrator);
                hydrator.addAddLuceneWork(this.asClass(operation, "class"), analyzers, (ConversionContext)conversionContext);
                continue;
            }
            if ("Update".equals(schema)) {
                this.buildLuceneDocument(this.asGenericRecord(operation, "document"), hydrator);
                analyzers = this.getAnalyzers(operation);
                this.processId(operation, hydrator);
                hydrator.addUpdateLuceneWork(this.asClass(operation, "class"), analyzers, (ConversionContext)conversionContext);
                continue;
            }
            throw log.cannotDeserializeOperation(schema);
        }
    }

    private String asClass(GenericRecord operation, String attribute) {
        Integer index = (Integer)operation.get(attribute);
        return this.classReferences.get(index).toString();
    }

    private List<Utf8> asListOfString(GenericRecord result, String attribute) {
        return (List)result.get(attribute);
    }

    private void processId(GenericRecord operation, LuceneWorksBuilder hydrator) {
        GenericRecord id = (GenericRecord)operation.get("id");
        Object value = id.get("value");
        if (value instanceof ByteBuffer) {
            hydrator.addIdAsJavaSerialized(this.asByteArray((ByteBuffer)value));
        } else if (value instanceof Utf8) {
            hydrator.addId((Serializable)((Object)value.toString()));
        } else {
            hydrator.addId((Serializable)value);
        }
    }

    private Map<String, String> getAnalyzers(GenericRecord operation) {
        Map analyzersWithUtf8 = (Map)operation.get("fieldToAnalyzerMap");
        if (analyzersWithUtf8 == null) {
            return null;
        }
        HashMap<String, String> analyzers = new HashMap<String, String>(analyzersWithUtf8.size());
        for (Map.Entry entry : analyzersWithUtf8.entrySet()) {
            analyzers.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return analyzers;
    }

    private void buildLuceneDocument(GenericRecord document, LuceneWorksBuilder hydrator) {
        hydrator.defineDocument();
        List<GenericRecord> fieldables = this.asListOfGenericRecords(document, "fieldables");
        for (GenericRecord field : fieldables) {
            String schema = field.getSchema().getName();
            if ("CustomFieldable".equals(schema)) {
                hydrator.addFieldable(this.asByteArray(field, "instance"));
                continue;
            }
            if ("NumericIntField".equals(schema)) {
                hydrator.addIntNumericField(this.asInt(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("NumericFloatField".equals(schema)) {
                hydrator.addFloatNumericField(this.asFloat(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("NumericLongField".equals(schema)) {
                hydrator.addLongNumericField(this.asLong(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("NumericDoubleField".equals(schema)) {
                hydrator.addDoubleNumericField(this.asDouble(field, "value"), this.asString(field, "name"), this.asInt(field, "precisionStep"), this.asStore(field), this.asBoolean(field, "indexed"), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("BinaryField".equals(schema)) {
                hydrator.addFieldWithBinaryData(this.asString(field, "name"), this.asByteArray(field, "value"), this.asInt(field, "offset"), this.asInt(field, "length"), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("StringField".equals(schema)) {
                hydrator.addFieldWithStringData(this.asString(field, "name"), this.asString(field, "value"), this.asStore(field), this.asIndex(field), this.asTermVector(field), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("TokenStreamField".equals(schema)) {
                this.buildAttributes(field, "value", hydrator);
                hydrator.addFieldWithTokenStreamData(this.asString(field, "name"), this.asTermVector(field), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            if ("ReaderField".equals(schema)) {
                hydrator.addFieldWithSerializableReaderData(this.asString(field, "name"), this.asByteArray(field, "value"), this.asTermVector(field), this.asFloat(field, "boost"), this.asBoolean(field, "omitNorms"), this.asBoolean(field, "omitTermFreqAndPositions"));
                continue;
            }
            throw log.cannotDeserializeField(schema);
        }
    }

    private void buildAttributes(GenericRecord record, String field, LuceneWorksBuilder hydrator) {
        List tokens = (List)record.get(field);
        for (List token : tokens) {
            for (Object attribute : token) {
                this.buildAttribute(attribute, hydrator);
            }
            hydrator.addToken();
        }
    }

    private void buildAttribute(Object element, LuceneWorksBuilder hydrator) {
        if (element instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)element;
            String name = record.getSchema().getName();
            if ("TokenTrackingAttribute".equals(name)) {
                hydrator.addTokenTrackingAttribute((List)record.get("positions"));
            } else if ("CharTermAttribute".equals(name)) {
                hydrator.addCharTermAttribute((CharSequence)record.get("sequence"));
            } else if ("PayloadAttribute".equals(name)) {
                hydrator.addPayloadAttribute(this.asByteArray(record, "payload"));
            } else if ("KeywordAttribute".equals(name)) {
                hydrator.addKeywordAttribute(this.asBoolean(record, "isKeyword"));
            } else if ("PositionIncrementAttribute".equals(name)) {
                hydrator.addPositionIncrementAttribute(this.asInt(record, "positionIncrement"));
            } else if ("FlagsAttribute".equals(name)) {
                hydrator.addFlagsAttribute(this.asInt(record, "flags"));
            } else if ("TypeAttribute".equals(name)) {
                hydrator.addTypeAttribute(this.asString(record, "type"));
            } else if ("OffsetAttribute".equals(name)) {
                hydrator.addOffsetAttribute(this.asInt(record, "startOffset"), this.asInt(record, "endOffset"));
            } else {
                log.unknownAttributeSerializedRepresentation(name);
            }
        }
        if (element instanceof ByteBuffer) {
            hydrator.addSerializedAttribute(this.asByteArray((ByteBuffer)element));
        } else {
            log.unknownAttributeSerializedRepresentation(element.getClass().getName());
        }
    }

    private GenericRecord asGenericRecord(GenericRecord operation, String field) {
        return (GenericRecord)operation.get(field);
    }

    private List<GenericRecord> asListOfGenericRecords(GenericRecord result, String field) {
        return (List)result.get(field);
    }

    private float asFloat(GenericRecord record, String field) {
        return ((Float)record.get(field)).floatValue();
    }

    private int asInt(GenericRecord record, String field) {
        return (Integer)record.get(field);
    }

    private long asLong(GenericRecord record, String field) {
        return (Long)record.get(field);
    }

    private double asDouble(GenericRecord record, String field) {
        return (Double)record.get(field);
    }

    private String asString(GenericRecord record, String field) {
        return record.get(field).toString();
    }

    private boolean asBoolean(GenericRecord record, String field) {
        return (Boolean)record.get(field);
    }

    private SerializableStore asStore(GenericRecord field) {
        String string = field.get("store").toString();
        return SerializableStore.valueOf((String)string);
    }

    private SerializableIndex asIndex(GenericRecord field) {
        String string = field.get("index").toString();
        return SerializableIndex.valueOf((String)string);
    }

    private SerializableTermVector asTermVector(GenericRecord field) {
        String string = field.get("termVector").toString();
        return SerializableTermVector.valueOf((String)string);
    }

    private byte[] asByteArray(GenericRecord operation, String field) {
        ByteBuffer buffer = (ByteBuffer)operation.get(field);
        return this.asByteArray(buffer);
    }

    private byte[] asByteArray(ByteBuffer buffer) {
        byte[] copy = new byte[buffer.remaining()];
        buffer.get(copy);
        return copy;
    }
}

