/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.tartarus.snowball.SnowballProgram;

class SnowballPorterFilter
extends TokenFilter {
    private final CharArraySet protWords;
    private final SnowballProgram stemmer;
    private final TermAttribute termAtt;

    public SnowballPorterFilter(TokenStream source, SnowballProgram stemmer, CharArraySet protWords) {
        super(source);
        this.protWords = protWords;
        this.stemmer = stemmer;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.termBuffer();
        int len = this.termAtt.termLength();
        if (this.protWords != null && this.protWords.contains(termBuffer, 0, len)) {
            return true;
        }
        this.stemmer.setCurrent(new String(termBuffer, 0, len));
        this.stemmer.stem();
        String newstr = this.stemmer.getCurrent();
        this.termAtt.setTermBuffer(newstr.toCharArray(), 0, newstr.length());
        return true;
    }
}

