/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.solr.analysis.WordDelimiterIterator;

final class WordDelimiterFilter
extends TokenFilter {
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean JRE_IS_64BIT;
    public static final int LOWER = 1;
    public static final int UPPER = 2;
    public static final int DIGIT = 4;
    public static final int SUBWORD_DELIM = 8;
    public static final int ALPHA = 3;
    public static final int ALPHANUM = 7;
    final boolean generateWordParts;
    final boolean generateNumberParts;
    final boolean catenateWords;
    final boolean catenateNumbers;
    final boolean catenateAll;
    final boolean preserveOriginal;
    final CharArraySet protWords;
    private final TermAttribute termAttribute = (TermAttribute)this.addAttribute(TermAttribute.class);
    private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAttribute = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final WordDelimiterIterator iterator;
    private final WordDelimiterConcatenation concat = new WordDelimiterConcatenation();
    private int lastConcatCount = 0;
    private final WordDelimiterConcatenation concatAll = new WordDelimiterConcatenation();
    private int accumPosInc = 0;
    private char[] savedBuffer = new char[1024];
    private int savedStartOffset;
    private int savedEndOffset;
    private String savedType;
    private boolean hasSavedState = false;
    private boolean hasIllegalOffsets = false;
    private boolean hasOutputToken = false;
    private boolean hasOutputFollowingOriginal = false;

    public WordDelimiterFilter(TokenStream in, byte[] charTypeTable, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal, int splitOnNumerics, int stemEnglishPossessive, CharArraySet protWords) {
        super(in);
        this.generateWordParts = generateWordParts != 0;
        this.generateNumberParts = generateNumberParts != 0;
        this.catenateWords = catenateWords != 0;
        this.catenateNumbers = catenateNumbers != 0;
        this.catenateAll = catenateAll != 0;
        this.preserveOriginal = preserveOriginal != 0;
        this.protWords = protWords;
        this.iterator = new WordDelimiterIterator(charTypeTable, splitOnCaseChange != 0, splitOnNumerics != 0, stemEnglishPossessive != 0);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, byte[] charTypeTable, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal, int splitOnNumerics, CharArraySet protWords) {
        this(in, charTypeTable, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, splitOnCaseChange, preserveOriginal, 1, 1, null);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, byte[] charTypeTable, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal) {
        this(in, charTypeTable, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, splitOnCaseChange, preserveOriginal, 1, null);
    }

    public WordDelimiterFilter(TokenStream in, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal, int splitOnNumerics, int stemEnglishPossessive, CharArraySet protWords) {
        this(in, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, splitOnCaseChange, preserveOriginal, splitOnNumerics, stemEnglishPossessive, protWords);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal, int splitOnNumerics, CharArraySet protWords) {
        this(in, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, splitOnCaseChange, preserveOriginal, splitOnNumerics, 1, protWords);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll, int splitOnCaseChange, int preserveOriginal) {
        this(in, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, splitOnCaseChange, preserveOriginal);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, byte[] charTypeTable, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll) {
        this(in, charTypeTable, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, 1, 0, 1, null);
    }

    @Deprecated
    public WordDelimiterFilter(TokenStream in, int generateWordParts, int generateNumberParts, int catenateWords, int catenateNumbers, int catenateAll) {
        this(in, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, generateWordParts, generateNumberParts, catenateWords, catenateNumbers, catenateAll, 1, 0, 1, null);
    }

    public boolean incrementToken() throws IOException {
        while (true) {
            if (!this.hasSavedState) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                int termLength = this.termAttribute.termLength();
                char[] termBuffer = this.termAttribute.termBuffer();
                this.accumPosInc += this.posIncAttribute.getPositionIncrement();
                this.iterator.setText(termBuffer, termLength);
                this.iterator.next();
                if (this.iterator.current == 0 && this.iterator.end == termLength || this.protWords != null && this.protWords.contains(termBuffer, 0, termLength)) {
                    this.posIncAttribute.setPositionIncrement(this.accumPosInc);
                    this.accumPosInc = 0;
                    return true;
                }
                if (this.iterator.end == -1 && !this.preserveOriginal) {
                    if (this.posIncAttribute.getPositionIncrement() != 1) continue;
                    --this.accumPosInc;
                    continue;
                }
                this.saveState();
                this.hasOutputToken = false;
                this.hasOutputFollowingOriginal = !this.preserveOriginal;
                this.lastConcatCount = 0;
                if (this.preserveOriginal) {
                    this.posIncAttribute.setPositionIncrement(this.accumPosInc);
                    this.accumPosInc = 0;
                    return true;
                }
            }
            if (this.iterator.end == -1) {
                if (!this.concat.isEmpty() && this.flushConcatenation(this.concat)) {
                    return true;
                }
                if (!this.concatAll.isEmpty()) {
                    if (this.concatAll.subwordCount > this.lastConcatCount) {
                        this.concatAll.writeAndClear();
                        return true;
                    }
                    this.concatAll.clear();
                }
                this.hasSavedState = false;
                continue;
            }
            if (this.iterator.isSingleWord()) {
                this.generatePart(true);
                this.iterator.next();
                return true;
            }
            int wordType = this.iterator.type();
            if (!this.concat.isEmpty() && (this.concat.type & wordType) == 0) {
                if (this.flushConcatenation(this.concat)) {
                    this.hasOutputToken = false;
                    return true;
                }
                this.hasOutputToken = false;
            }
            if (this.shouldConcatenate(wordType)) {
                if (this.concat.isEmpty()) {
                    this.concat.type = wordType;
                }
                this.concatenate(this.concat);
            }
            if (this.catenateAll) {
                this.concatenate(this.concatAll);
            }
            if (this.shouldGenerateParts(wordType)) {
                this.generatePart(false);
                this.iterator.next();
                return true;
            }
            this.iterator.next();
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.hasSavedState = false;
        this.concat.clear();
        this.concatAll.clear();
        this.accumPosInc = 0;
    }

    private void saveState() {
        this.savedStartOffset = this.offsetAttribute.startOffset();
        this.savedEndOffset = this.offsetAttribute.endOffset();
        this.hasIllegalOffsets = this.savedEndOffset - this.savedStartOffset != this.termAttribute.termLength();
        this.savedType = this.typeAttribute.type();
        if (this.savedBuffer.length < this.termAttribute.termLength()) {
            this.savedBuffer = new char[WordDelimiterFilter.oversize(this.termAttribute.termLength(), 2)];
        }
        System.arraycopy(this.termAttribute.termBuffer(), 0, this.savedBuffer, 0, this.termAttribute.termLength());
        this.iterator.text = this.savedBuffer;
        this.hasSavedState = true;
    }

    private boolean flushConcatenation(WordDelimiterConcatenation concatenation) {
        this.lastConcatCount = concatenation.subwordCount;
        if (concatenation.subwordCount != 1 || !this.shouldGenerateParts(concatenation.type)) {
            concatenation.writeAndClear();
            return true;
        }
        concatenation.clear();
        return false;
    }

    private boolean shouldConcatenate(int wordType) {
        return this.catenateWords && WordDelimiterFilter.isAlpha(wordType) || this.catenateNumbers && WordDelimiterFilter.isDigit(wordType);
    }

    private boolean shouldGenerateParts(int wordType) {
        return this.generateWordParts && WordDelimiterFilter.isAlpha(wordType) || this.generateNumberParts && WordDelimiterFilter.isDigit(wordType);
    }

    private void concatenate(WordDelimiterConcatenation concatenation) {
        if (concatenation.isEmpty()) {
            concatenation.startOffset = this.savedStartOffset + this.iterator.current;
        }
        concatenation.append(this.savedBuffer, this.iterator.current, this.iterator.end - this.iterator.current);
        concatenation.endOffset = this.savedStartOffset + this.iterator.end;
    }

    private void generatePart(boolean isSingleWord) {
        this.clearAttributes();
        this.termAttribute.setTermBuffer(this.savedBuffer, this.iterator.current, this.iterator.end - this.iterator.current);
        int startOffSet = isSingleWord || !this.hasIllegalOffsets ? this.savedStartOffset + this.iterator.current : this.savedStartOffset;
        int endOffSet = this.hasIllegalOffsets ? this.savedEndOffset : this.savedStartOffset + this.iterator.end;
        this.offsetAttribute.setOffset(startOffSet, endOffSet);
        this.posIncAttribute.setPositionIncrement(this.position(false));
        this.typeAttribute.setType(this.savedType);
    }

    private int position(boolean inject) {
        int posInc = this.accumPosInc;
        if (this.hasOutputToken) {
            this.accumPosInc = 0;
            return inject ? 0 : Math.max(1, posInc);
        }
        this.hasOutputToken = true;
        if (!this.hasOutputFollowingOriginal) {
            this.hasOutputFollowingOriginal = true;
            return 0;
        }
        this.accumPosInc = 0;
        return Math.max(1, posInc);
    }

    static boolean isAlpha(int type) {
        return (type & 3) != 0;
    }

    static boolean isDigit(int type) {
        return (type & 4) != 0;
    }

    static boolean isSubwordDelim(int type) {
        return (type & 8) != 0;
    }

    static boolean isUpper(int type) {
        return (type & 2) != 0;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0) {
            return Integer.MAX_VALUE;
        }
        if (JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return newSize;
    }

    static {
        String x = System.getProperty("sun.arch.data.model");
        JRE_IS_64BIT = x != null ? x.indexOf("64") != -1 : OS_ARCH != null && OS_ARCH.indexOf("64") != -1;
    }

    final class WordDelimiterConcatenation {
        final StringBuilder buffer = new StringBuilder();
        int startOffset;
        int endOffset;
        int type;
        int subwordCount;

        WordDelimiterConcatenation() {
        }

        void append(char[] text, int offset, int length) {
            this.buffer.append(text, offset, length);
            ++this.subwordCount;
        }

        void write() {
            WordDelimiterFilter.this.clearAttributes();
            if (WordDelimiterFilter.this.termAttribute.termLength() < this.buffer.length()) {
                WordDelimiterFilter.this.termAttribute.resizeTermBuffer(this.buffer.length());
            }
            char[] termbuffer = WordDelimiterFilter.this.termAttribute.termBuffer();
            this.buffer.getChars(0, this.buffer.length(), termbuffer, 0);
            WordDelimiterFilter.this.termAttribute.setTermLength(this.buffer.length());
            if (WordDelimiterFilter.this.hasIllegalOffsets) {
                WordDelimiterFilter.this.offsetAttribute.setOffset(WordDelimiterFilter.this.savedStartOffset, WordDelimiterFilter.this.savedEndOffset);
            } else {
                WordDelimiterFilter.this.offsetAttribute.setOffset(this.startOffset, this.endOffset);
            }
            WordDelimiterFilter.this.posIncAttribute.setPositionIncrement(WordDelimiterFilter.this.position(true));
            WordDelimiterFilter.this.typeAttribute.setType(WordDelimiterFilter.this.savedType);
            WordDelimiterFilter.this.accumPosInc = 0;
        }

        boolean isEmpty() {
            return this.buffer.length() == 0;
        }

        void clear() {
            this.buffer.setLength(0);
            this.subwordCount = 0;
            this.type = 0;
            this.endOffset = 0;
            this.startOffset = 0;
        }

        void writeAndClear() {
            this.write();
            this.clear();
        }
    }
}

