/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShingleFilterFactory
extends BaseTokenFilterFactory {
    private int maxShingleSize;
    private boolean outputUnigrams;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.maxShingleSize = this.getInt("maxShingleSize", 2);
        this.outputUnigrams = this.getBoolean("outputUnigrams", true);
    }

    public ShingleFilter create(TokenStream input) {
        ShingleFilter r = new ShingleFilter(input, this.maxShingleSize);
        r.setOutputUnigrams(this.outputUnigrams);
        return r;
    }
}

