/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.DoubleMetaphoneFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleMetaphoneFilterFactory
extends BaseTokenFilterFactory {
    public static final String INJECT = "inject";
    public static final String MAX_CODE_LENGTH = "maxCodeLength";
    public static final int DEFAULT_MAX_CODE_LENGTH = 4;
    private boolean inject = true;
    private int maxCodeLength = 4;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.inject = this.getBoolean(INJECT, true);
        if (args.get(MAX_CODE_LENGTH) != null) {
            this.maxCodeLength = Integer.parseInt(args.get(MAX_CODE_LENGTH));
        }
    }

    public DoubleMetaphoneFilter create(TokenStream input) {
        return new DoubleMetaphoneFilter(input, this.maxCodeLength, this.inject);
    }
}

