// original code from Apache Solr - ported to work with Lucene 3.x and reformatted to Search coding style
/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Set;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

/**
 * A TokenFilter that only keeps tokens with text contained in the
 * required words.  This filter behaves like the inverse of StopFilter.
 *
 * @version $Id: KeepWordFilter.java 940806 2010-05-04 11:18:46Z uschindler $
 * @since solr 1.3
 */
public final class KeepWordFilter extends TokenFilter {
	private final CharArraySet words;
	private final TermAttribute termAtt = addAttribute( TermAttribute.class );

	/**
	 * @deprecated Use {@link #KeepWordFilter(TokenStream, Set, boolean)} instead
	 */
	@Deprecated
	public KeepWordFilter(TokenStream in, Set<String> words, boolean ignoreCase) {
		this( in, new CharArraySet( words, ignoreCase ) );
	}

	/**
	 * The words set passed to this constructor will be directly used by this filter
	 * and should not be modified,
	 */
	public KeepWordFilter(TokenStream in, CharArraySet words) {
		super( in );
		this.words = words;
	}

	@Override
	public boolean incrementToken() throws IOException {
		while ( input.incrementToken() ) {
			if ( words.contains( termAtt.termBuffer(), 0, termAtt.termLength() ) ) {
				return true;
			}
		}
		return false;
	}
}
