/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.ClassWriter;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.Version;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.JpaDescriptorParser;

@SupportedAnnotationTypes(value={"jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable"})
@SupportedOptions(value={"debug", "persistenceXml", "ormXml", "fullyAnnotationConfigured", "lazyXmlParsing", "addGenerationDate", "addGeneratedAnnotation", "addSuppressWarningsAnnotation"})
public class JPAMetaModelEntityProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    public static final String PERSISTENCE_XML_OPTION = "persistenceXml";
    public static final String ORM_XML_OPTION = "ormXml";
    public static final String FULLY_ANNOTATION_CONFIGURED_OPTION = "fullyAnnotationConfigured";
    public static final String LAZY_XML_PARSING = "lazyXmlParsing";
    public static final String ADD_GENERATION_DATE = "addGenerationDate";
    public static final String ADD_GENERATED_ANNOTATION = "addGeneratedAnnotation";
    public static final String ADD_SUPPRESS_WARNINGS_ANNOTATION = "addSuppressWarningsAnnotation";
    private static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private Context context;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.context = new Context(env);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Hibernate JPA 2 Static-Metamodel Generator " + Version.getVersionString());
        String tmp = env.getOptions().get(ADD_GENERATED_ANNOTATION);
        if (tmp != null) {
            boolean addGeneratedAnnotation = Boolean.parseBoolean(tmp);
            this.context.setAddGeneratedAnnotation(addGeneratedAnnotation);
        }
        tmp = env.getOptions().get(ADD_GENERATION_DATE);
        boolean addGenerationDate = Boolean.parseBoolean(tmp);
        this.context.setAddGenerationDate(addGenerationDate);
        tmp = env.getOptions().get(ADD_SUPPRESS_WARNINGS_ANNOTATION);
        boolean addSuppressWarningsAnnotation = Boolean.parseBoolean(tmp);
        this.context.setAddSuppressWarningsAnnotation(addSuppressWarningsAnnotation);
        tmp = env.getOptions().get(FULLY_ANNOTATION_CONFIGURED_OPTION);
        boolean fullyAnnotationConfigured = Boolean.parseBoolean(tmp);
        if (!fullyAnnotationConfigured) {
            JpaDescriptorParser parser = new JpaDescriptorParser(this.context);
            parser.parseXml();
            if (this.context.isFullyXmlConfigured()) {
                this.createMetaModelClasses();
            }
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver() || annotations.size() == 0) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (this.context.isFullyXmlConfigured()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Skipping the processing of annotations since persistence unit is purely xml configured.");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        Set<? extends Element> elements = roundEnvironment.getRootElements();
        for (Element element : elements) {
            if (!this.isJPAEntity(element)) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class " + element.toString());
            this.handleRootElementAnnotationMirrors(element);
        }
        this.createMetaModelClasses();
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    private void createMetaModelClasses() {
        for (MetaEntity entity : this.context.getMetaEntities()) {
            if (this.context.isAlreadyGenerated(entity.getQualifiedName())) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for entity " + entity);
            ClassWriter.writeFile(entity, this.context);
            this.context.markGenerated(entity.getQualifiedName());
        }
        Collection<MetaEntity> toProcessEntities = this.context.getMetaEmbeddables();
        while (!toProcessEntities.isEmpty()) {
            HashSet<MetaEntity> processedEntities = new HashSet<MetaEntity>();
            int toProcessCountBeforeLoop = toProcessEntities.size();
            for (MetaEntity entity : toProcessEntities) {
                if (this.context.isAlreadyGenerated(entity.getQualifiedName())) {
                    processedEntities.add(entity);
                    continue;
                }
                if (this.modelGenerationNeedsToBeDeferred(toProcessEntities, entity)) continue;
                this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for embeddable/mapped superclass" + entity);
                ClassWriter.writeFile(entity, this.context);
                this.context.markGenerated(entity.getQualifiedName());
                processedEntities.add(entity);
            }
            toProcessEntities.removeAll(processedEntities);
            if (toProcessEntities.size() < toProcessCountBeforeLoop) continue;
            this.context.logMessage(Diagnostic.Kind.ERROR, "Potential endless loop in generation of entities.");
        }
    }

    private boolean modelGenerationNeedsToBeDeferred(Collection<MetaEntity> entities, MetaEntity containedEntity) {
        ContainsAttributeTypeVisitor visitor = new ContainsAttributeTypeVisitor(containedEntity.getTypeElement(), this.context);
        for (MetaEntity entity : entities) {
            boolean contains;
            TypeMirror mirror;
            if (entity.equals(containedEntity)) continue;
            for (Element element : ElementFilter.fieldsIn(entity.getTypeElement().getEnclosedElements())) {
                mirror = element.asType();
                if (!TypeKind.DECLARED.equals((Object)mirror.getKind()) || !(contains = mirror.accept(visitor, element).booleanValue())) continue;
                return true;
            }
            for (Element element : ElementFilter.methodsIn(entity.getTypeElement().getEnclosedElements())) {
                mirror = element.asType();
                if (!TypeKind.DECLARED.equals((Object)mirror.getKind()) || !(contains = mirror.accept(visitor, element).booleanValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isJPAEntity(Element element) {
        return TypeUtils.containsAnnotation(element, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable");
    }

    private void handleRootElementAnnotationMirrors(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!ElementKind.CLASS.equals((Object)element.getKind())) continue;
            String fqn = ((TypeElement)element).getQualifiedName().toString();
            MetaEntity alreadyExistingMetaEntity = this.tryGettingExistingEntityFromContext(annotationMirror, fqn);
            if (alreadyExistingMetaEntity != null && alreadyExistingMetaEntity.isMetaComplete()) {
                String msg = "Skipping processing of annotations for " + fqn + " since xml configuration is metadata complete.";
                this.context.logMessage(Diagnostic.Kind.OTHER, msg);
                continue;
            }
            boolean requiresLazyMemberInitialization = false;
            if (TypeUtils.containsAnnotation(element, "jakarta.persistence.Embeddable") || TypeUtils.containsAnnotation(element, "jakarta.persistence.MappedSuperclass")) {
                requiresLazyMemberInitialization = true;
            }
            AnnotationMetaEntity metaEntity = new AnnotationMetaEntity((TypeElement)element, this.context, requiresLazyMemberInitialization);
            if (alreadyExistingMetaEntity != null) {
                metaEntity.mergeInMembers(alreadyExistingMetaEntity);
            }
            this.addMetaEntityToContext(annotationMirror, metaEntity);
        }
    }

    private MetaEntity tryGettingExistingEntityFromContext(AnnotationMirror mirror, String fqn) {
        MetaEntity alreadyExistingMetaEntity = null;
        if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Entity") || TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.MappedSuperclass")) {
            alreadyExistingMetaEntity = this.context.getMetaEntity(fqn);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Embeddable")) {
            alreadyExistingMetaEntity = this.context.getMetaEmbeddable(fqn);
        }
        return alreadyExistingMetaEntity;
    }

    private void addMetaEntityToContext(AnnotationMirror mirror, AnnotationMetaEntity metaEntity) {
        if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Entity")) {
            this.context.addMetaEntity(metaEntity.getQualifiedName(), metaEntity);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.MappedSuperclass")) {
            this.context.addMetaEntity(metaEntity.getQualifiedName(), metaEntity);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, "jakarta.persistence.Embeddable")) {
            this.context.addMetaEmbeddable(metaEntity.getQualifiedName(), metaEntity);
        }
    }

    static class ContainsAttributeTypeVisitor
    extends SimpleTypeVisitor6<Boolean, Element> {
        private Context context;
        private TypeElement type;

        ContainsAttributeTypeVisitor(TypeElement elem, Context context) {
            this.context = context;
            this.type = elem;
        }

        @Override
        public Boolean visitDeclared(DeclaredType declaredType, Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            String fqNameOfReturnType = returnedElement.getQualifiedName().toString();
            String collection = Constants.COLLECTIONS.get(fqNameOfReturnType);
            if (collection != null) {
                TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, fqNameOfReturnType, null, this.context);
                Element collectionElement = this.context.getTypeUtils().asElement(collectionElementType);
                if (ElementKind.TYPE_PARAMETER.equals((Object)collectionElement.getKind())) {
                    return Boolean.FALSE;
                }
                returnedElement = (TypeElement)collectionElement;
            }
            if (this.type.getQualifiedName().toString().equals(returnedElement.getQualifiedName().toString())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitExecutable(ExecutableType t, Element element) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) {
                return Boolean.FALSE;
            }
            String string = element.getSimpleName().toString();
            if (!StringUtil.isProperty(string, TypeUtils.toTypeString(t.getReturnType()))) {
                return Boolean.FALSE;
            }
            TypeMirror returnType = t.getReturnType();
            return returnType.accept(this, element);
        }
    }
}

