/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.jcache.JCacheNaturalIdRegion;
import org.hibernate.cache.jcache.access.AbstractReadWriteRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ReadWriteNaturalIdRegionAccessStrategy
extends AbstractReadWriteRegionAccessStrategy<JCacheNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    public ReadWriteNaturalIdRegionAccessStrategy(JCacheNaturalIdRegion jCacheNaturalIdRegion) {
        super(jCacheNaturalIdRegion);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return ((JCacheNaturalIdRegion)this.region).putIfAbsent(key, new AbstractReadWriteRegionAccessStrategy.Item(value, null, ((JCacheNaturalIdRegion)this.region).nextTimestamp(), this.nextItemId()));
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        AbstractReadWriteRegionAccessStrategy.Lockable item;
        while ((item = (AbstractReadWriteRegionAccessStrategy.Lockable)((JCacheNaturalIdRegion)this.region).get(key)) != null && item.isUnlockable(lock)) {
            AbstractReadWriteRegionAccessStrategy.Lock lockItem = (AbstractReadWriteRegionAccessStrategy.Lock)item;
            if (lockItem.wasLockedConcurrently()) {
                if (!((JCacheNaturalIdRegion)this.region).replace(key, lockItem, lockItem.unlock(((JCacheNaturalIdRegion)this.region).nextTimestamp()))) continue;
                return false;
            }
            if (!((JCacheNaturalIdRegion)this.region).replace(key, lockItem, new AbstractReadWriteRegionAccessStrategy.Item(value, null, ((JCacheNaturalIdRegion)this.region).nextTimestamp(), this.nextItemId()))) continue;
            return true;
        }
        this.handleMissingLock(key, item);
        return false;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SharedSessionContractImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }
}

