/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache;

import javax.cache.Cache;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheTransactionalDataRegion;
import org.hibernate.cache.jcache.access.NonStrictEntityRegionAccessStrategy;
import org.hibernate.cache.jcache.access.ReadOnlyEntityRegionAccessStrategy;
import org.hibernate.cache.jcache.access.ReadWriteEntityRegionAccessStrategy;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;

public class JCacheEntityRegion
extends JCacheTransactionalDataRegion
implements EntityRegion {
    public JCacheEntityRegion(Cache<Object, Object> cache, CacheDataDescription metadata, SessionFactoryOptions options) {
        super(cache, metadata, options);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        this.throwIfAccessTypeUnsupported(accessType);
        switch (accessType) {
            case READ_ONLY: {
                return new ReadOnlyEntityRegionAccessStrategy(this);
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictEntityRegionAccessStrategy(this);
            }
            case READ_WRITE: {
                return new ReadWriteEntityRegionAccessStrategy(this);
            }
            case TRANSACTIONAL: {
                return this.createTransactionalEntityRegionAccessStrategy();
            }
        }
        throw new IllegalArgumentException("Unknown AccessType: " + accessType);
    }

    protected EntityRegionAccessStrategy createTransactionalEntityRegionAccessStrategy() {
        throw new UnsupportedOperationException("No org.hibernate.cache.spi.access.AccessType.TRANSACTIONAL support");
    }
}

