/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import java.io.Serializable;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.entities.RelationType;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.synchronization.AuditSync;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.envers.synchronization.work.PersistentCollectionChangeWorkUnit;
import org.hibernate.envers.tools.Tools;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRemoveEvent;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEvent;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public class AuditEventListener
implements PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreCollectionUpdateEventListener,
PreCollectionRemoveEventListener,
PostCollectionRecreateEventListener,
Initializable {
    private static final long serialVersionUID = -2499904286323112715L;
    private AuditConfiguration verCfg;

    private void generateBidirectionalCollectionChangeWorkUnits(AuditSync verSync, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState, SessionImplementor session) {
        if (!this.verCfg.getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            IdMapper idMapper;
            Serializable id;
            String toEntityName;
            HibernateProxy hibernateProxy;
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.verCfg.getEntCfg().getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.isBidirectional() || relDesc.getRelationType() != RelationType.TO_ONE) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (Tools.entitiesEqual(session, oldValue, newValue)) continue;
            if (newValue != null) {
                if (newValue instanceof HibernateProxy) {
                    hibernateProxy = (HibernateProxy)newValue;
                    toEntityName = session.bestGuessEntityName(newValue);
                    id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
                    newValue = Tools.getTargetFromProxy(session.getFactory(), hibernateProxy);
                } else {
                    toEntityName = session.guessEntityName(newValue);
                    idMapper = this.verCfg.getEntCfg().get(toEntityName).getIdMapper();
                    id = (Serializable)idMapper.mapToIdFromEntity(newValue);
                }
                verSync.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, this.verCfg, id, newValue));
            }
            if (oldValue == null) continue;
            if (oldValue instanceof HibernateProxy) {
                hibernateProxy = (HibernateProxy)oldValue;
                toEntityName = session.bestGuessEntityName(oldValue);
                id = hibernateProxy.getHibernateLazyInitializer().getIdentifier();
                oldValue = Tools.getTargetFromProxy(session.getFactory(), hibernateProxy);
            } else {
                toEntityName = session.guessEntityName(oldValue);
                idMapper = this.verCfg.getEntCfg().get(toEntityName).getIdMapper();
                id = (Serializable)idMapper.mapToIdFromEntity(oldValue);
            }
            verSync.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, this.verCfg, id, oldValue));
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            verSync.addWorkUnit(new AddWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getState()));
            this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), null, (SessionImplementor)event.getSession());
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            verSync.addWorkUnit(new ModWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getState(), event.getOldState()));
            this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, event.getState(), event.getOldState(), (SessionImplementor)event.getSession());
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            verSync.addWorkUnit(new DelWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.verCfg, event.getId(), event.getPersister(), event.getDeletedState()));
            this.generateBidirectionalCollectionChangeWorkUnits(verSync, event.getPersister(), entityName, null, event.getDeletedState(), (SessionImplementor)event.getSession());
        }
    }

    private void generateBidirectionalCollectionChangeWorkUnits(AuditSync verSync, AbstractCollectionEvent event, PersistentCollectionChangeWorkUnit workUnit) {
        if (!this.verCfg.getGlobalCfg().isGenerateRevisionsForCollections()) {
            return;
        }
        RelationDescription relDesc = this.verCfg.getEntCfg().getRelationDescription(event.getAffectedOwnerEntityName(), workUnit.getReferencingPropertyName());
        if (relDesc != null && relDesc.isBidirectional()) {
            String relatedEntityName = relDesc.getToEntityName();
            IdMapper relatedIdMapper = this.verCfg.getEntCfg().get(relatedEntityName).getIdMapper();
            for (PersistentCollectionChangeData changeData : workUnit.getCollectionChanges()) {
                Object relatedObj = changeData.getChangedElement();
                Serializable relatedId = (Serializable)relatedIdMapper.mapToIdFromEntity(relatedObj);
                verSync.addWorkUnit(new CollectionChangeWorkUnit((SessionImplementor)event.getSession(), relatedEntityName, this.verCfg, relatedId, relatedObj));
            }
        }
    }

    private void onCollectionAction(AbstractCollectionEvent event, PersistentCollection newColl, Serializable oldColl, CollectionEntry collectionEntry) {
        String entityName = event.getAffectedOwnerEntityName();
        if (this.verCfg.getEntCfg().isVersioned(entityName)) {
            AuditSync verSync = this.verCfg.getSyncManager().get(event.getSession());
            PersistentCollectionChangeWorkUnit workUnit = new PersistentCollectionChangeWorkUnit((SessionImplementor)event.getSession(), entityName, this.verCfg, newColl, collectionEntry, oldColl, event.getAffectedOwnerIdOrNull());
            verSync.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                verSync.addWorkUnit(new CollectionChangeWorkUnit((SessionImplementor)event.getSession(), event.getAffectedOwnerEntityName(), this.verCfg, event.getAffectedOwnerIdOrNull(), event.getAffectedOwnerOrNull()));
                this.generateBidirectionalCollectionChangeWorkUnits(verSync, event, workUnit);
            }
        }
    }

    private CollectionEntry getCollectionEntry(AbstractCollectionEvent event) {
        return event.getSession().getPersistenceContext().getCollectionEntry(event.getCollection());
    }

    public void onPreUpdateCollection(PreCollectionUpdateEvent event) {
        CollectionEntry collectionEntry = this.getCollectionEntry((AbstractCollectionEvent)event);
        if (!collectionEntry.getLoadedPersister().isInverse()) {
            this.onCollectionAction((AbstractCollectionEvent)event, event.getCollection(), collectionEntry.getSnapshot(), collectionEntry);
        }
    }

    public void onPreRemoveCollection(PreCollectionRemoveEvent event) {
        CollectionEntry collectionEntry = this.getCollectionEntry((AbstractCollectionEvent)event);
        if (collectionEntry != null && !collectionEntry.getLoadedPersister().isInverse()) {
            this.onCollectionAction((AbstractCollectionEvent)event, null, collectionEntry.getSnapshot(), collectionEntry);
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        CollectionEntry collectionEntry = this.getCollectionEntry((AbstractCollectionEvent)event);
        if (!collectionEntry.getLoadedPersister().isInverse()) {
            this.onCollectionAction((AbstractCollectionEvent)event, event.getCollection(), null, collectionEntry);
        }
    }

    public void initialize(Configuration cfg) {
        this.verCfg = AuditConfiguration.getFor(cfg);
    }

    public AuditConfiguration getVerCfg() {
        return this.verCfg;
    }
}

