/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata.reader;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.ModificationStore;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.entities.PropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAuditingData {
    private String name;
    private String beanName;
    private ModificationStore store;
    private String mapKey;
    private AuditJoinTable joinTable;
    private String accessType;
    private final List<AuditOverride> auditJoinTableOverrides = new ArrayList<AuditOverride>(0);
    private RelationTargetAuditMode relationTargetAuditMode;

    public PropertyAuditingData() {
    }

    public PropertyAuditingData(String name, String accessType, ModificationStore store, RelationTargetAuditMode relationTargetAuditMode) {
        this.name = name;
        this.beanName = name;
        this.accessType = accessType;
        this.store = store;
        this.relationTargetAuditMode = relationTargetAuditMode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public ModificationStore getStore() {
        return this.store;
    }

    public void setStore(ModificationStore store) {
        this.store = store;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public AuditJoinTable getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(AuditJoinTable joinTable) {
        this.joinTable = joinTable;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public PropertyData getPropertyData() {
        return new PropertyData(this.name, this.beanName, this.accessType, this.store);
    }

    public List<AuditOverride> getAuditingOverrides() {
        return this.auditJoinTableOverrides;
    }

    public void addAuditingOverride(AuditOverride annotation) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AuditOverride current : this.auditJoinTableOverrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                this.auditJoinTableOverrides.add(annotation);
            }
        }
    }

    public void addAuditingOverrides(AuditOverrides annotationOverrides) {
        if (annotationOverrides != null) {
            for (AuditOverride annotation : annotationOverrides.value()) {
                this.addAuditingOverride(annotation);
            }
        }
    }

    public RelationTargetAuditMode getRelationTargetAuditMode() {
        return this.relationTargetAuditMode;
    }

    public void setRelationTargetAuditMode(RelationTargetAuditMode relationTargetAuditMode) {
        this.relationTargetAuditMode = relationTargetAuditMode;
    }
}

