/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.OneEntityQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.ThreeEntityQueryGenerator;
import org.hibernate.envers.entities.mapper.relation.query.TwoEntityQueryGenerator;

public final class QueryGeneratorBuilder {
    private final GlobalConfiguration globalCfg;
    private final AuditEntitiesConfiguration verEntCfg;
    private final MiddleIdData referencingIdData;
    private final String auditMiddleEntityName;
    private final List<MiddleIdData> idDatas;

    QueryGeneratorBuilder(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, MiddleIdData referencingIdData, String auditMiddleEntityName) {
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.referencingIdData = referencingIdData;
        this.auditMiddleEntityName = auditMiddleEntityName;
        this.idDatas = new ArrayList<MiddleIdData>();
    }

    void addRelation(MiddleIdData idData) {
        this.idDatas.add(idData);
    }

    RelationQueryGenerator build(MiddleComponentData ... componentDatas) {
        if (this.idDatas.size() == 0) {
            return new OneEntityQueryGenerator(this.verEntCfg, this.auditMiddleEntityName, this.referencingIdData, componentDatas);
        }
        if (this.idDatas.size() == 1) {
            return new TwoEntityQueryGenerator(this.globalCfg, this.verEntCfg, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), componentDatas);
        }
        if (this.idDatas.size() == 2) {
            return new ThreeEntityQueryGenerator(this.globalCfg, this.verEntCfg, this.auditMiddleEntityName, this.referencingIdData, this.idDatas.get(0), this.idDatas.get(1), componentDatas);
        }
        throw new IllegalStateException("Illegal number of related entities.");
    }

    int getCurrentIndex() {
        return this.idDatas.size();
    }
}

