/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockScope;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TransactionRequiredException;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.validation.ConstraintViolationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.OptimisticLockException;
import org.hibernate.PessimisticLockException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.QueryImpl;
import org.hibernate.ejb.TransactionImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ValueHandlerFactory;
import org.hibernate.ejb.criteria.expression.CompoundSelectionImpl;
import org.hibernate.ejb.transaction.JoinableCMTTransaction;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityManagerImpl.class);
    private static final String PESSIMISTICLOCKSCOPE = "javax.persistence.lock.scope";
    private static final String PESSIMISTICLOCKTIMEOUT = "javax.persistence.lock.timeout";
    private EntityManagerFactoryImpl entityManagerFactory;
    protected transient TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType persistenceContextType;
    private FlushModeType flushModeType = FlushModeType.AUTO;
    private PersistenceUnitTransactionType transactionType;
    private Map properties;
    private CriteriaQueryCompiler criteriaQueryCompiler;

    protected AbstractEntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType type, PersistenceUnitTransactionType transactionType, Map properties) {
        this.entityManagerFactory = entityManagerFactory;
        this.persistenceContextType = type;
        this.transactionType = transactionType;
        this.properties = properties != null ? properties : CollectionHelper.EMPTY_MAP;
    }

    protected void postInit() {
        Object flushMode;
        if (PersistenceUnitTransactionType.JTA.equals((Object)this.transactionType)) {
            this.joinTransaction(true);
        }
        if ((flushMode = this.properties.get("org.hibernate.flushMode")) != null) {
            this.getSession().setFlushMode(ConfigurationHelper.getFlushMode(flushMode));
        }
        this.properties = null;
    }

    public javax.persistence.Query createQuery(String jpaqlString) {
        try {
            return new QueryImpl(this.getSession().createQuery(jpaqlString), this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass) {
        try {
            Query hqlQuery = this.getSession().createQuery(jpaqlString);
            if (hqlQuery.getReturnTypes().length != 1) {
                throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
            }
            if (!resultClass.isAssignableFrom(hqlQuery.getReturnTypes()[0].getReturnedClass())) {
                throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + hqlQuery.getReturnTypes()[0].getReturnedClass() + "]");
            }
            return new QueryImpl(hqlQuery, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass, Selection selection, HibernateEntityManagerImplementor.Options options) {
        try {
            List<Selection<?>> tupleElements;
            Query hqlQuery = this.getSession().createQuery(jpaqlString);
            if (options.getValueHandlers() == null) {
                options.getResultMetadataValidator().validate(hqlQuery.getReturnTypes());
            }
            List<Selection<?>> list = tupleElements = Tuple.class.equals(resultClass) ? ((CompoundSelectionImpl)selection).getCompoundSelectionItems() : null;
            if (options.getValueHandlers() != null || tupleElements != null) {
                hqlQuery.setResultTransformer((ResultTransformer)new CriteriaQueryTransformer(options.getValueHandlers(), tupleElements));
            }
            return new QueryImpl(hqlQuery, this, options.getNamedParameterExplicitTypes());
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        if (this.criteriaQueryCompiler == null) {
            this.criteriaQueryCompiler = new CriteriaQueryCompiler(this);
        }
        return this.criteriaQueryCompiler.compile(criteriaQuery);
    }

    public javax.persistence.Query createNamedQuery(String name) {
        try {
            Query namedQuery = this.getSession().getNamedQuery(name);
            try {
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        try {
            Query namedQuery = this.getSession().getNamedQuery(name);
            try {
                if (namedQuery.getReturnTypes().length != 1) {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                }
                if (!resultClass.isAssignableFrom(namedQuery.getReturnTypes()[0].getReturnedClass())) {
                    throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + namedQuery.getReturnTypes()[0].getReturnedClass() + "]");
                }
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.setResultSetMapping(resultSetMapping);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            return (T)this.getSession().load(entityClass, (Serializable)primaryKey);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return this.find(entityClass, primaryKey, null, null);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType) {
        return this.find(entityClass, primaryKey, lockModeType, null);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = null;
        try {
            if (lockModeType != null) {
                lockOptions = this.getLockRequest(lockModeType, properties);
                return (A)this.getSession().get(entityClass, (Serializable)primaryKey, lockOptions);
            }
            return (A)this.getSession().get(entityClass, (Serializable)primaryKey);
        }
        catch (ObjectDeletedException e) {
            return null;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
    }

    private void checkTransactionNeeded() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
        }
    }

    public void persist(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().persist(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public <A> A merge(A entity) {
        this.checkTransactionNeeded();
        try {
            return (A)this.getSession().merge(entity);
        }
        catch (ObjectDeletedException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public void remove(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, LockModeType lockModeType) {
        this.refresh(entity, lockModeType, null);
    }

    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkTransactionNeeded();
        LockOptions lockOptions = null;
        try {
            if (!this.getSession().contains(entity)) {
                throw new IllegalArgumentException("Entity not managed");
            }
            if (lockModeType != null) {
                lockOptions = this.getLockRequest(lockModeType, properties);
                this.getSession().refresh(entity, lockOptions);
            } else {
                this.getSession().refresh(entity);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
    }

    public boolean contains(Object entity) {
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.getSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.getSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public LockModeType getLockMode(Object entity) {
        if (!this.contains(entity)) {
            throw new IllegalArgumentException("entity not in the persistence context");
        }
        return AbstractEntityManagerImpl.getLockModeType(this.getSession().getCurrentLockMode(entity));
    }

    public void setProperty(String s, Object o) {
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public void flush() {
        try {
            if (!this.isTransactionInProgress()) {
                throw new TransactionRequiredException("no transaction is in progress");
            }
            this.getSession().flush();
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public abstract Session getSession();

    protected abstract Session getRawSession();

    public EntityTransaction getTransaction() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.tx;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public HibernateEntityManagerFactory getFactory() {
        return this.entityManagerFactory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEntityManagerFactory().getMetamodel();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.flushModeType = flushModeType;
        if (flushModeType == FlushModeType.AUTO) {
            this.getSession().setFlushMode(FlushMode.AUTO);
        } else if (flushModeType == FlushModeType.COMMIT) {
            this.getSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + flushModeType);
        }
    }

    public void clear() {
        try {
            this.getSession().clear();
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public void detach(Object entity) {
        try {
            this.getSession().evict(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public FlushModeType getFlushMode() {
        FlushMode mode = this.getSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            this.flushModeType = FlushModeType.AUTO;
        } else if (mode == FlushMode.COMMIT) {
            this.flushModeType = FlushModeType.COMMIT;
        } else {
            return null;
        }
        return this.flushModeType;
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = null;
        try {
            if (!this.isTransactionInProgress()) {
                throw new TransactionRequiredException("no transaction is in progress");
            }
            if (!this.contains(entity)) {
                throw new IllegalArgumentException("entity not in the persistence context");
            }
            lockOptions = this.getLockRequest(lockModeType, properties);
            this.getSession().buildLockRequest(lockOptions).lock(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
    }

    @Override
    public LockOptions getLockRequest(LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = new LockOptions();
        lockOptions.setLockMode(AbstractEntityManagerImpl.getLockMode(lockModeType));
        if (properties != null) {
            Object value = properties.get(PESSIMISTICLOCKSCOPE);
            if (value instanceof String && PessimisticLockScope.valueOf((String)((String)value)) == PessimisticLockScope.EXTENDED) {
                lockOptions.setScope(true);
            }
            if ((value = properties.get(PESSIMISTICLOCKTIMEOUT)) instanceof String) {
                int timeout = Integer.parseInt((String)value);
                if (timeout < 0) {
                    lockOptions.setTimeOut(-1);
                } else if (timeout == 0) {
                    lockOptions.setTimeOut(0);
                } else {
                    lockOptions.setTimeOut(timeout);
                }
            }
        }
        return lockOptions;
    }

    private static LockModeType getLockModeType(LockMode lockMode) {
        if (lockMode == LockMode.NONE) {
            return LockModeType.NONE;
        }
        if (lockMode == LockMode.OPTIMISTIC || lockMode == LockMode.READ) {
            return LockModeType.OPTIMISTIC;
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT || lockMode == LockMode.WRITE) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return LockModeType.PESSIMISTIC_READ;
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE || lockMode == LockMode.UPGRADE || lockMode == LockMode.UPGRADE_NOWAIT) {
            return LockModeType.PESSIMISTIC_WRITE;
        }
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT || lockMode == LockMode.FORCE) {
            return LockModeType.PESSIMISTIC_FORCE_INCREMENT;
        }
        throw new AssertionFailure("unhandled lock mode " + lockMode);
    }

    private static LockMode getLockMode(LockModeType lockMode) {
        switch (lockMode) {
            case READ: 
            case OPTIMISTIC: {
                return LockMode.OPTIMISTIC;
            }
            case OPTIMISTIC_FORCE_INCREMENT: 
            case WRITE: {
                return LockMode.OPTIMISTIC_FORCE_INCREMENT;
            }
            case PESSIMISTIC_READ: {
                return LockMode.PESSIMISTIC_READ;
            }
            case PESSIMISTIC_WRITE: {
                return LockMode.PESSIMISTIC_WRITE;
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return LockMode.PESSIMISTIC_FORCE_INCREMENT;
            }
            case NONE: {
                return LockMode.NONE;
            }
        }
        throw new AssertionFailure("Unknown LockModeType: " + lockMode);
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)this.getRawSession()).isTransactionInProgress();
    }

    protected void markAsRollback() {
        log.debug("mark transaction for rollback");
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        } else if (PersistenceUnitTransactionType.JTA == this.transactionType) {
            TransactionManager transactionManager = ((SessionFactoryImplementor)this.getRawSession().getSessionFactory()).getTransactionManager();
            if (transactionManager == null) {
                throw new PersistenceException("Using a JTA persistence context wo setting hibernate.transaction.manager_lookup_class");
            }
            try {
                transactionManager.setRollbackOnly();
            }
            catch (SystemException e) {
                throw new PersistenceException("Unable to set the JTA transaction as RollbackOnly", (Throwable)e);
            }
        }
    }

    public void joinTransaction() {
        this.joinTransaction(false);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(Session.class)) {
            return (T)this.getSession();
        }
        if (clazz.equals(SessionImplementor.class)) {
            return (T)this.getSession();
        }
        throw new PersistenceException("Hibernate cannot unwrap " + clazz);
    }

    private void joinTransaction(boolean ignoreNotJoining) {
        this.getSession().isOpen();
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            try {
                log.debug("Looking for a JTA transaction to join");
                final Session session = this.getSession();
                Transaction transaction = session.getTransaction();
                if (transaction != null && transaction instanceof JoinableCMTTransaction) {
                    JoinableCMTTransaction joinableCMTTransaction = (JoinableCMTTransaction)transaction;
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.JOINED) {
                        log.debug("Transaction already joined");
                        return;
                    }
                    joinableCMTTransaction.markForJoined();
                    session.isOpen();
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.NOT_JOINED) {
                        if (ignoreNotJoining) {
                            log.debug("No JTA transaction found");
                            return;
                        }
                        throw new TransactionRequiredException("No active JTA transaction on joinTransaction call");
                    }
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.MARKED_FOR_JOINED) {
                        throw new AssertionFailure("Transaction MARKED_FOR_JOINED after isOpen() call");
                    }
                    log.trace("Adding flush() and close() synchronization");
                    joinableCMTTransaction.registerSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                            boolean flush = false;
                            TransactionFactory.Context ctx = null;
                            try {
                                ctx = (TransactionFactory.Context)session;
                                JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                javax.transaction.Transaction transaction = joinable.getTransaction();
                                if (transaction == null) {
                                    log.warn("Transaction not available on beforeCompletionPhase: assuming valid");
                                }
                                flush = !ctx.isFlushModeNever() && (transaction == null || !JTAHelper.isRollback((int)transaction.getStatus()));
                            }
                            catch (SystemException se) {
                                log.error("could not determine transaction status", (Throwable)se);
                                PersistenceException pe = new PersistenceException("could not determine transaction status in beforeCompletion()", (Throwable)se);
                                AbstractEntityManagerImpl.this.handlePersistenceException(pe);
                                throw pe;
                            }
                            catch (HibernateException he) {
                                AbstractEntityManagerImpl.this.throwPersistenceException(he);
                            }
                            try {
                                if (flush) {
                                    log.trace("automatically flushing session");
                                    ctx.managedFlush();
                                } else {
                                    log.trace("skipping managed flushing");
                                }
                            }
                            catch (HibernateException he) {
                                throw AbstractEntityManagerImpl.this.convert(he);
                            }
                            catch (PersistenceException pe) {
                                AbstractEntityManagerImpl.this.handlePersistenceException(pe);
                                throw pe;
                            }
                            catch (RuntimeException re) {
                                PersistenceException wrapped = new PersistenceException((Throwable)re);
                                AbstractEntityManagerImpl.this.handlePersistenceException(wrapped);
                                throw wrapped;
                            }
                        }

                        public void afterCompletion(int status) {
                            try {
                                if (4 == status && AbstractEntityManagerImpl.this.transactionType == PersistenceUnitTransactionType.JTA && session.isOpen()) {
                                    session.clear();
                                }
                                if (session.isOpen()) {
                                    JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                    joinable.resetStatus();
                                }
                            }
                            catch (HibernateException e) {
                                throw AbstractEntityManagerImpl.this.convert(e);
                            }
                        }
                    });
                }
                log.warn("Cannot join transaction: do not override {}", (Object)"hibernate.transaction.factory_class");
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        } else if (!ignoreNotJoining) {
            log.warn("Calling joinTransaction() on a non JTA EntityManager");
        }
    }

    public Object getDelegate() {
        return this.getSession();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }

    @Override
    public void handlePersistenceException(PersistenceException e) {
        if (e instanceof NoResultException) {
            return;
        }
        if (e instanceof javax.persistence.NonUniqueResultException) {
            return;
        }
        if (e instanceof LockTimeoutException) {
            return;
        }
        if (e instanceof QueryTimeoutException) {
            return;
        }
        try {
            this.markAsRollback();
        }
        catch (Exception ne) {
            log.error("Unable to mark for rollback on PersistenceException: ", (Throwable)ne);
        }
    }

    @Override
    public void throwPersistenceException(PersistenceException e) {
        this.handlePersistenceException(e);
        throw e;
    }

    @Override
    public RuntimeException convert(HibernateException e) {
        return this.convert(e, null);
    }

    public RuntimeException convert(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)((Object)e));
        } else if (e instanceof ConstraintViolationException) {
            this.markAsRollback();
        }
        return result;
    }

    @Override
    public RuntimeException convert(HibernateException e, LockOptions lockOptions) {
        if (e instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)e);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof OptimisticLockException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof NonUniqueResultException) {
            javax.persistence.NonUniqueResultException converted = new javax.persistence.NonUniqueResultException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof QueryException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof TransientObjectException) {
            try {
                this.markAsRollback();
            }
            catch (Exception ne) {
                log.error("Unable to mark for rollback on TransientObjectException: ", (Throwable)ne);
            }
            return new IllegalStateException(e);
        }
        PersistenceException converted = new PersistenceException((Throwable)e);
        this.handlePersistenceException(converted);
        return converted;
    }

    @Override
    public void throwPersistenceException(HibernateException e) {
        throw this.convert(e);
    }

    @Override
    public PersistenceException wrapStaleStateException(StaleStateException e) {
        javax.persistence.OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Serializable identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.getRawSession().load(sose.getEntityName(), identifier);
                        if (entity instanceof Serializable) {
                            pe = new javax.persistence.OptimisticLockException(null, (Throwable)e, entity);
                            break block7;
                        }
                        pe = new javax.persistence.OptimisticLockException((Throwable)e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new javax.persistence.OptimisticLockException((Throwable)e);
                    }
                } else {
                    pe = new javax.persistence.OptimisticLockException((Throwable)e);
                }
            } else {
                pe = new javax.persistence.OptimisticLockException((Throwable)e);
            }
        }
        return pe;
    }

    public PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        Object pe;
        if (e instanceof OptimisticLockException) {
            OptimisticLockException ole = (OptimisticLockException)e;
            pe = new javax.persistence.OptimisticLockException(ole.getMessage(), (Throwable)ole, ole.getEntity());
        } else if (e instanceof PessimisticLockException) {
            PessimisticLockException ple = (PessimisticLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new LockTimeoutException(ple.getMessage(), (Throwable)ple, ple.getEntity()) : new javax.persistence.PessimisticLockException(ple.getMessage(), (Throwable)ple, ple.getEntity());
        } else {
            pe = new javax.persistence.OptimisticLockException((Throwable)e);
        }
        return pe;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CriteriaQueryTransformer
    extends BasicTransformerAdapter {
        private final List<ValueHandlerFactory.ValueHandler> valueHandlers;
        private final List tupleElements;

        private CriteriaQueryTransformer(List<ValueHandlerFactory.ValueHandler> valueHandlers, List tupleElements) {
            this.valueHandlers = valueHandlers;
            this.tupleElements = tupleElements;
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            Object[] valueHandlerResult;
            if (this.valueHandlers == null) {
                valueHandlerResult = tuple;
            } else {
                valueHandlerResult = new Object[tuple.length];
                for (int i = 0; i < tuple.length; ++i) {
                    ValueHandlerFactory.ValueHandler valueHandler = this.valueHandlers.get(i);
                    valueHandlerResult[i] = valueHandler == null ? tuple[i] : valueHandler.convert(tuple[i]);
                }
            }
            return this.tupleElements == null ? (valueHandlerResult.length == 1 ? valueHandlerResult[0] : valueHandlerResult) : new TupleImpl(tuple);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TupleImpl
        implements Tuple {
            private final Object[] tuples;

            private TupleImpl(Object[] tuples) {
                if (tuples.length != CriteriaQueryTransformer.this.tupleElements.size()) {
                    throw new IllegalArgumentException("Size mismatch between tuple result [" + tuples.length + "] and expected tuple elements [" + CriteriaQueryTransformer.this.tupleElements.size() + "]");
                }
                this.tuples = tuples;
            }

            public <X> X get(TupleElement<X> tupleElement) {
                int index = CriteriaQueryTransformer.this.tupleElements.indexOf(tupleElement);
                if (index < 0) {
                    throw new IllegalArgumentException("Requested tuple element did not correspond to element in the result tuple");
                }
                return (X)this.tuples[index];
            }

            public Object get(String alias) {
                int index = -1;
                if (alias != null && (alias = alias.trim()).length() > 0) {
                    int i = 0;
                    for (TupleElement selection : CriteriaQueryTransformer.this.tupleElements) {
                        if (alias.equals(selection.getAlias())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index < 0) {
                    throw new IllegalArgumentException("Given alias [" + alias + "] did not correspond to an element in the result tuple");
                }
                return this.tuples[index];
            }

            public <X> X get(String alias, Class<X> type) {
                return (X)this.get(alias);
            }

            public Object get(int i) {
                if (i >= this.tuples.length) {
                    throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.tuples.length + "] ");
                }
                return this.tuples[i];
            }

            public <X> X get(int i, Class<X> type) {
                return (X)this.get(i);
            }

            public Object[] toArray() {
                return this.tuples;
            }

            public List<TupleElement<?>> getElements() {
                return CriteriaQueryTransformer.this.tupleElements;
            }
        }
    }
}

