/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.publish.auth.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.build.gradle.publish.auth.maven.Credentials;
import org.hibernate.build.gradle.publish.auth.maven.CredentialsProvider;
import org.hibernate.build.gradle.publish.auth.maven.DomHelper;
import org.hibernate.build.gradle.publish.auth.maven.PasswordReader;
import org.hibernate.build.gradle.publish.auth.maven.PasswordReaderFactory;
import org.hibernate.build.gradle.publish.auth.maven.PathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SettingsXmlCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(SettingsXmlCredentialsProvider.class);
    public static final SettingsXmlCredentialsProvider INSTANCE = new SettingsXmlCredentialsProvider();
    public static final String SETTINGS_LOCATION_OVERRIDE = "maven.settings";
    private final ConcurrentHashMap<String, Credentials> credentialsByRepoIdMap;

    private SettingsXmlCredentialsProvider() {
        ConcurrentHashMap<String, Credentials> byIdMap = new ConcurrentHashMap<String, Credentials>();
        PasswordReader passwordReader = PasswordReaderFactory.INSTANCE.determinePasswordReader();
        File settingsFile = this.determineSettingsFileLocation();
        try {
            SAXReader saxReader = this.buildSAXReader();
            InputSource inputSource = new InputSource(new FileInputStream(settingsFile));
            try {
                Document document = saxReader.read(inputSource);
                Element settingsElement = document.getRootElement();
                Element serversElement = settingsElement.element("servers");
                Iterator serversIterator = serversElement.elementIterator("server");
                while (serversIterator.hasNext()) {
                    Element serverElement = (Element)serversIterator.next();
                    String id = DomHelper.extractValue(serverElement.element("id"));
                    if (id == null) continue;
                    Credentials authentication = this.extractCredentials(serverElement, passwordReader);
                    byIdMap.put(id, authentication);
                }
            }
            catch (DocumentException e) {
                log.error("Error reading Maven settings.xml", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            log.info("Unable to locate Maven settings.xml");
        }
        this.credentialsByRepoIdMap = byIdMap;
    }

    private File determineSettingsFileLocation() {
        String defaultLocation = "~/.m2/settings.xml";
        String location = System.getProperty(SETTINGS_LOCATION_OVERRIDE, "~/.m2/settings.xml");
        return new File(PathHelper.normalizePath(location));
    }

    private SAXReader buildSAXReader() {
        SAXReader saxReader = new SAXReader(new DocumentFactory());
        saxReader.setMergeAdjacentText(true);
        return saxReader;
    }

    private Credentials extractCredentials(Element serverElement, PasswordReader passwordReader) {
        Credentials authentication = new Credentials();
        authentication.setUserName(DomHelper.extractValue(serverElement.element("username")));
        authentication.setPassword(passwordReader.readPassword(serverElement.element("password")));
        authentication.setPrivateKey(DomHelper.extractValue(serverElement.element("privateKey")));
        authentication.setPassphrase(DomHelper.extractValue(serverElement.element("passphrase")));
        return authentication;
    }

    @Override
    public Credentials determineAuthentication(String repositoryId) {
        return this.credentialsByRepoIdMap.get(repositoryId);
    }
}

