/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConfigurationDefinedTraversableResolver;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.XmlDefinedTraversableResolver;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class TraversableResolverSpecifiedInValidationXmlTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)TraversableResolverSpecifiedInValidationXmlTest.webArchiveBuilder().withTestClass(TraversableResolverSpecifiedInValidationXmlTest.class)).withClasses(User.class, Optional.class, CreditCard.class, ConfigurationDefinedTraversableResolver.class, XmlDefinedTraversableResolver.class)).withValidationXml("validation-TraversableResolverSpecifiedInValidationXmlTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="g")
    public void testTraversableResolverSpecifiedInValidationXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        Assert.assertTrue((XmlDefinedTraversableResolver.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The resolver should have been called at least once if it was properly picked up by xml configuration.");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="d"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="g")})
    public void testTraversableResolverSpecifiedInValidationXmlCanBeOverridden() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        configuration = configuration.traversableResolver((TraversableResolver)new ConfigurationDefinedTraversableResolver());
        Validator validator = configuration.buildValidatorFactory().getValidator();
        User user = new User();
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 1);
        Assert.assertTrue((ConfigurationDefinedTraversableResolver.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The resolver should have been called at least once if configuration settings were applied.");
    }
}

