/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validatorfactory;

import javax.validation.Configuration;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MyConstraint;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MyConstraintValidator;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MySecondConstraint;
import org.hibernate.beanvalidation.tck.tests.validatorfactory.MySecondConstraintValidator;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class CustomConstraintValidatorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(CustomConstraintValidatorTest.class)).withClass(MyConstraint.class)).withClass(MyConstraintValidator.class)).withClass(MySecondConstraint.class)).withClass(MySecondConstraintValidator.class)).build();
    }

    @Test
    @SpecAssertion(section="3.5", id="b")
    public void testDefaultConstructorInValidatorCalled() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Dummy(), new Class[0]);
        Assert.assertTrue((boolean)MyConstraintValidator.defaultConstructorCalled, (String)"The no-arg default constructor should have been called.");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="3.5", id="c")
    public void testRuntimeExceptionInValidatorCreationIsWrapped() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new SecondDummy(), new Class[0]);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="3.5", id="d")
    public void testValidationExceptionIsThrownInCaseFactoryReturnsNull() {
        Configuration config = TestUtil.getConfigurationUnderTest().constraintValidatorFactory((ConstraintValidatorFactory)new CustomConstraintValidatorFactory());
        Validator validator = config.buildValidatorFactory().getValidator();
        validator.validate((Object)new SecondDummy(), new Class[0]);
    }

    @Test
    @SpecAssertion(section="5.5.2", id="d")
    public void testGetConstraintValidatorFactoryFromValidatorFactory() {
        CustomConstraintValidatorFactory constraintValidatorFactory = new CustomConstraintValidatorFactory();
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().constraintValidatorFactory((ConstraintValidatorFactory)constraintValidatorFactory).buildValidatorFactory();
        Assert.assertSame((Object)validatorFactory.getConstraintValidatorFactory(), (Object)constraintValidatorFactory, (String)"getConstraintValidatorFactory() should return the parameter name provider set via configuration");
    }

    private static class SecondDummy {
        @MySecondConstraint
        public int value;

        private SecondDummy() {
        }
    }

    private static class Dummy {
        @MyConstraint
        public int value;

        private Dummy() {
        }
    }

    private class CustomConstraintValidatorFactory
    implements ConstraintValidatorFactory {
        private CustomConstraintValidatorFactory() {
        }

        public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
            return null;
        }

        public void releaseInstance(ConstraintValidator<?, ?> instance) {
        }
    }
}

