/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Payload;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.validation.Actor;
import org.hibernate.beanvalidation.tck.tests.validation.ActorArrayBased;
import org.hibernate.beanvalidation.tck.tests.validation.ActorListBased;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.BadlyBehavedEntity;
import org.hibernate.beanvalidation.tck.tests.validation.Boy;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Engine;
import org.hibernate.beanvalidation.tck.tests.validation.Last;
import org.hibernate.beanvalidation.tck.tests.validation.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.tests.validation.PlayedWith;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidateTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidateTest.class)).withClasses(Engine.class, Boy.class, Actor.class, ActorArrayBased.class, ActorListBased.class, PlayedWith.class, Customer.class, Person.class, Order.class, Address.class, BadlyBehavedEntity.class, Last.class, NotEmpty.class)).build();
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertions(value={@SpecAssertion(section="4.1", id="a"), @SpecAssertion(section="4.6.4", id="h"), @SpecAssertion(section="6.1", id="c")})
    public void testUnexpectedTypeException() {
        Boy boy = new Boy();
        TestUtil.getValidatorUnderTest().validate((Object)boy, new Class[0]);
    }

    @Test
    @SpecAssertion(section="6.1", id="a")
    public void testConstraintDescriptorWithoutExplicitGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Order.class);
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty("orderNumber");
        Set descriptors = propertyDescriptor.getConstraintDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)1, (String)"There should be only one constraint descriptor");
        ConstraintDescriptor descriptor = (ConstraintDescriptor)descriptors.iterator().next();
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0, (String)"There should be only one group");
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"The declared constraint does not explicitly define a group, hence Default is expected");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="6.1", id="b")
    public void testNullParameterToGetConstraintsForClass() {
        TestUtil.getValidatorUnderTest().getConstraintsForClass(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="b")
    public void testValidateWithNullValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate(null, new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="5.1.1", id="b")
    public void testValidateWithNullGroup() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new Boy(), new Class[]{null});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.1", id="a"), @SpecAssertion(section="5.1.1", id="c")})
    public void testMultipleViolationOfTheSameType() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("mail@foobar.com");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        engine.setSerialNumber("ABCDEFGH1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        engine.setSerialNumber("ABCD-EFGH-1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6", id="c"), @SpecAssertion(section="5.1.1", id="c")})
    public void testMultipleConstraintViolationOfDifferentTypes() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Address address = new Address();
        address.setStreet(null);
        address.setZipCode(null);
        address.setCity("Llanfairpwllgwyngyllgogerychwyrndrobwyll-llantysiliogogogoch");
        Set constraintViolations = validator.validate((Object)address, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, Size.class, NotEmpty.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.1", id="a"), @SpecAssertion(section="4.6", id="a"), @SpecAssertion(section="4.6", id="c"), @SpecAssertion(section="5.2", id="a"), @SpecAssertion(section="5.2", id="b"), @SpecAssertion(section="5.2", id="c"), @SpecAssertion(section="5.2", id="e"), @SpecAssertion(section="5.2", id="f"), @SpecAssertion(section="5.2", id="i"), @SpecAssertion(section="5.2", id="g"), @SpecAssertion(section="5.2", id="h"), @SpecAssertion(section="5.2", id="k"), @SpecAssertion(section="6.11", id="a")})
    public void testConstraintViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Engine engine = new Engine();
        engine.setSerialNumber("ABCDEFGH1234");
        Set constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)violation.getMessage(), (String)"must match ^....-....-....$", (String)"Wrong message");
        Assert.assertEquals((String)violation.getMessageTemplate(), (String)"must match {regexp}", (String)"Wrong message template");
        Assert.assertEquals((Object)violation.getRootBean(), (Object)engine, (String)"Wrong root entity.");
        Assert.assertEquals((Object)violation.getRootBeanClass(), Engine.class, (String)"Wrong root bean class.");
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)engine);
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)"ABCDEFGH1234", (String)"Wrong validated value");
        Assert.assertNull((Object)violation.getExecutableParameters());
        Assert.assertNull((Object)violation.getExecutableReturnValue());
        Assert.assertNotNull((Object)violation.getConstraintDescriptor(), (String)"Constraint descriptor should not be null");
        Annotation ann = violation.getConstraintDescriptor().getAnnotation();
        Assert.assertEquals(ann.annotationType(), Pattern.class, (String)"Wrong annotation type");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "serialNumber");
        engine.setSerialNumber("ABCD-EFGH-1234");
        constraintViolations = validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.6", id="a"), @SpecAssertion(section="5.2", id="c"), @SpecAssertion(section="5.2", id="e"), @SpecAssertion(section="5.2", id="f"), @SpecAssertion(section="5.2", id="i")})
    public void testClassLevelConstraintViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DirtBike bike = new DirtBike();
        Set constraintViolations = validator.validate((Object)bike, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation violation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)violation.getRootBean(), (Object)bike, (String)"Wrong root entity.");
        Assert.assertEquals((Object)violation.getRootBeanClass(), DirtBike.class, (String)"Wrong root bean class.");
        Assert.assertEquals((Object)violation.getLeafBean(), (Object)bike, (String)"Wrong leaf bean.");
        Assert.assertEquals((Object)violation.getInvalidValue(), (Object)bike, (String)"Wrong validated value");
        Assert.assertNotNull((Object)violation.getConstraintDescriptor(), (String)"Constraint descriptor should not be null");
        Annotation ann = violation.getConstraintDescriptor().getAnnotation();
        Assert.assertEquals(ann.annotationType(), ValidDirtBike.class, (String)"Wrong annotation type");
        TestUtil.assertCorrectPathNodeKinds(constraintViolations, TestUtil.kinds(ElementKind.BEAN));
        TestUtil.assertCorrectPathNodeNames(constraintViolations, TestUtil.names(new String[]{null}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="4.6", id="a"), @SpecAssertion(section="5.2", id="f")})
    public void testGraphValidationWithList() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorListBased clint = new ActorListBased("Clint", "Eastwood");
        ActorListBased morgan = new ActorListBased("Morgan", null);
        ActorListBased charlie = new ActorListBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        morgan.addPlayedWith(clint);
        clint.addPlayedWith(morgan);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)constraintViolation.getMessage(), (String)"Everyone has a last name.", (String)"Wrong message");
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)clint, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getLeafBean(), (Object)morgan);
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)morgan.getLastName(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "playedWith[0].playedWith[1].lastName", "playedWith[1].lastName");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="4.1.3", id="i"), @SpecAssertion(section="4.1.3", id="d")})
    public void testGraphValidationWithArray() {
        Validator validator = TestUtil.getValidatorUnderTest();
        ActorArrayBased clint = new ActorArrayBased("Clint", "Eastwood");
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        ActorArrayBased charlie = new ActorArrayBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        morgan.addPlayedWith(clint);
        clint.addPlayedWith(morgan);
        Set constraintViolations = validator.validate((Object)clint, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((String)constraintViolation.getMessage(), (String)"Everyone has a last name.", (String)"Wrong message");
        Assert.assertEquals((Object)constraintViolation.getRootBean(), (Object)clint, (String)"Wrong root entity");
        Assert.assertEquals((Object)constraintViolation.getInvalidValue(), (Object)morgan.getLastName(), (String)"Wrong value");
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "playedWith[0].playedWith[1].lastName", "playedWith[1].lastName");
    }

    @Test
    @SpecAssertion(section="4.4.2", id="b")
    public void testOnlyFirstGroupInSequenceGetEvaluated() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Car car = new Car("USd-298");
        Set violations = validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, Second.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        car.setLicensePlateNumber("USD-298");
        violations = validator.validateProperty((Object)car, "licensePlateNumber", new Class[]{First.class, Second.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="5.1.1", id="k")
    public void testUnexpectedExceptionsInValidateGetWrappedInValidationExceptions() {
        Validator validator = TestUtil.getValidatorUnderTest();
        validator.validate((Object)new BadlyBehavedEntity(), new Class[0]);
    }

    @Constraint(validatedBy={Validator.class})
    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValidDirtBike {
        public String message() default "{ValidDirtBike.message}";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public static class Validator
        implements ConstraintValidator<ValidDirtBike, DirtBike> {
            public boolean isValid(DirtBike bike, ConstraintValidatorContext constraintValidatorContext) {
                return false;
            }
        }
    }

    private static interface Second {
    }

    private static interface First {
    }

    @ValidDirtBike
    private static class DirtBike {
        private DirtBike() {
        }
    }

    private static class Car {
        @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class})
        private @Pattern(regexp="[A-Z][A-Z][A-Z]-[0-9][0-9][0-9]", groups={First.class, Second.class}) String licensePlateNumber;

        Car(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }

        public String getLicensePlateNumber() {
            return this.licensePlateNumber;
        }

        public void setLicensePlateNumber(String licensePlateNumber) {
            this.licensePlateNumber = licensePlateNumber;
        }
    }
}

