/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.validation.ClockProvider;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.PastDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.PastRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ClockProviderPastTest
extends Arquillian {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ClockProviderPastTest.class)).build();
    }

    @Test
    @SpecAssertion(section="", id="")
    public void clockProviderIsUsed() {
        PastDummyEntity dummy = new PastDummyEntity(ZonedDateTime.of(1985, 6, 12, 3, 0, 0, 0, TZ_BERLIN));
        Validator validator = TestUtil.getValidatorUnderTest();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 0);
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(1984, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 13);
        TestUtil.assertCorrectPropertyPaths(validator.validate((Object)dummy, new Class[0]), "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
    }

    @Test
    @SpecAssertion(section="", id="")
    public void clockProviderIsUsedForRelativePartials() {
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone(TZ_BERLIN));
        cal.set(2016, 6, 6);
        cal.set(11, 14);
        cal.set(12, 45);
        PastRelativePartialDummyEntity dummy = new PastRelativePartialDummyEntity(ZonedDateTime.of(2016, 6, 6, 14, 45, 0, 0, TZ_BERLIN));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2016, 8, 15, 16, 15, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 0);
        clockProvider = new FixedClockProvider(ZonedDateTime.of(2014, 4, 4, 9, 45, 0, 0, TZ_BERLIN));
        validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 3);
        TestUtil.assertCorrectPropertyPaths(validator.validate((Object)dummy, new Class[0]), "localTime", "monthDay", "offsetTime");
    }
}

