/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.ClockProvider;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.tests.time.ClockProviderPastTest;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.FutureDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.FutureRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ClockProviderFutureTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ClockProviderPastTest.class)).build();
    }

    @Test
    @SpecAssertion(section="", id="")
    public void clockProviderIsUsed() {
        FutureDummyEntity dummy = new FutureDummyEntity(ZonedDateTime.of(2099, 1, 12, 5, 0, 0, 0, TZ_BERLIN));
        Validator validator = TestUtil.getValidatorUnderTest();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 0);
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2100, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 13);
        TestUtil.assertCorrectPropertyPaths(validator.validate((Object)dummy, new Class[0]), "date", "calendar", "instant", "hijrahDate", "japaneseDate", "localDate", "localDateTime", "minguoDate", "offsetDateTime", "thaiBuddhistDate", "year", "yearMonth", "zonedDateTime");
    }

    @Test
    @SpecAssertion(section="", id="")
    public void clockProviderIsUsedForRelativePartials() {
        FutureRelativePartialDummyEntity dummy = new FutureRelativePartialDummyEntity(ZonedDateTime.of(2016, 6, 6, 14, 45, 0, 0, TZ_BERLIN));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2015, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 0);
        clockProvider = new FixedClockProvider(ZonedDateTime.of(2016, 8, 17, 17, 45, 0, 0, TZ_BERLIN));
        validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        TestUtil.assertCorrectNumberOfViolations(validator.validate((Object)dummy, new Class[0]), 3);
        TestUtil.assertCorrectPropertyPaths(validator.validate((Object)dummy, new Class[0]), "localTime", "monthDay", "offsetTime");
    }
}

