/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.Scope;
import org.hibernate.beanvalidation.tck.tests.metadata.Account;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerService;
import org.hibernate.beanvalidation.tck.tests.metadata.CustomerServiceExtension;
import org.hibernate.beanvalidation.tck.tests.metadata.Executables;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExecutableDescriptorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ExecutableDescriptorTest.class)).withClasses(Account.class, Customer.class, CustomerService.class, CustomerServiceExtension.class, Executables.class, Person.class)).build();
    }

    @Test
    @SpecAssertion(section="6.2", id="a")
    public void testGetElementClassForMethod() {
        MethodDescriptor descriptor = Executables.returnValueConstrainedMethod();
        Assert.assertEquals((Object)descriptor.getElementClass(), Integer.TYPE);
    }

    @Test
    @SpecAssertion(section="6.2", id="a")
    public void testGetElementClassForVoidMethod() {
        MethodDescriptor descriptor = Executables.parameterConstrainedMethod();
        Assert.assertEquals((Object)descriptor.getElementClass(), Void.TYPE);
    }

    @Test
    @SpecAssertion(section="6.2", id="a")
    public void testGetElementClassForConstructor() {
        ConstructorDescriptor descriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertEquals((Object)descriptor.getElementClass(), CustomerService.class);
    }

    @Test
    @SpecAssertion(section="6.7", id="a")
    public void testGetNameForMethod() {
        MethodDescriptor descriptor = Executables.parameterConstrainedMethod();
        Assert.assertEquals((String)descriptor.getName(), (String)"createCustomer");
    }

    @Test
    @SpecAssertion(section="6.7", id="a")
    public void testGetNameForConstructor() {
        ConstructorDescriptor descriptor = Executables.parameterConstrainedConstructor();
        Assert.assertEquals((String)descriptor.getName(), (String)"CustomerService");
    }

    @Test
    @SpecAssertion(section="6.7", id="b")
    public void testGetParameterDescriptorsForMethod() {
        MethodDescriptor descriptor = Executables.parameterConstrainedMethod();
        Assert.assertEquals((int)descriptor.getParameterDescriptors().size(), (int)2, (String)"Size of parameter descriptor list doesn't match method parameter count");
    }

    @Test
    @SpecAssertion(section="6.7", id="b")
    public void testGetParameterDescriptorsForParameterlessMethod() {
        MethodDescriptor descriptor = Executables.returnValueConstrainedMethod();
        Assert.assertEquals((int)descriptor.getParameterDescriptors().size(), (int)0, (String)"Size of parameter descriptor list doesn't match method parameter count");
    }

    @Test
    @SpecAssertion(section="6.7", id="b")
    public void testGetParameterDescriptorsForConstructor() {
        ConstructorDescriptor descriptor = Executables.parameterConstrainedConstructor();
        Assert.assertEquals((int)descriptor.getParameterDescriptors().size(), (int)2, (String)"Size of parameter descriptor list doesn't match constructor parameter count");
    }

    @Test
    @SpecAssertion(section="6.7", id="b")
    public void testGetParameterDescriptorsForConstructorOfInnerClass() {
        ConstructorDescriptor descriptor = Executables.parameterConstrainedConstructorOfInnerClass();
        Assert.assertEquals((int)descriptor.getParameterDescriptors().size(), (int)2, (String)"Size of parameter descriptor list doesn't match constructor parameter count");
    }

    @Test
    @SpecAssertion(section="6.7", id="b")
    public void testGetParameterDescriptorsForParameterlessConstructor() {
        ConstructorDescriptor descriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertEquals((int)descriptor.getParameterDescriptors().size(), (int)0, (String)"Size of parameter descriptor list doesn't match constructor parameter count");
    }

    @Test
    @SpecAssertion(section="6.7", id="c")
    public void testGetCrossParameterDescriptorForMethod() {
        MethodDescriptor descriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertNotNull((Object)descriptor.getCrossParameterDescriptor(), (String)"Cross-parameter descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="c")
    public void testGetCrossParameterDescriptorForMethodWithoutCrossParameterConstraints() {
        MethodDescriptor descriptor = Executables.returnValueConstrainedMethod();
        Assert.assertNotNull((Object)descriptor.getCrossParameterDescriptor(), (String)"Cross-parameter descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="c")
    public void testGetCrossParameterDescriptorForConstructor() {
        ConstructorDescriptor descriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertNotNull((Object)descriptor.getCrossParameterDescriptor(), (String)"Cross-parameter descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="c")
    public void testGetCrossParameterDescriptorForConstructorWithoutCrossParameterConstraints() {
        ConstructorDescriptor descriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertNotNull((Object)descriptor.getCrossParameterDescriptor(), (String)"Cross-parameter descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="d")
    public void testGetReturnValueDescriptorForMethod() {
        MethodDescriptor descriptor = Executables.returnValueConstrainedMethod();
        Assert.assertNotNull((Object)descriptor.getReturnValueDescriptor(), (String)"Return value descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="d")
    public void testGetUnconstrainedReturnValueDescriptorForMethod() {
        MethodDescriptor descriptor = Executables.cascadedParameterMethod();
        Assert.assertNotNull((Object)descriptor.getReturnValueDescriptor(), (String)"Return value descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="d")
    public void testReturnValueDescriptorForVoidMethod() {
        MethodDescriptor descriptor = Executables.parameterConstrainedMethod();
        Assert.assertNotNull((Object)descriptor.getReturnValueDescriptor(), (String)"Return value descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="d")
    public void testGetReturnValueDescriptorForConstructor() {
        ConstructorDescriptor descriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertNotNull((Object)descriptor.getReturnValueDescriptor(), (String)"Return value descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="d")
    public void testGetUnconstrainedReturnValueDescriptorForConstructor() {
        ConstructorDescriptor descriptor = Executables.cascadedParameterConstructor();
        Assert.assertNotNull((Object)descriptor.getReturnValueDescriptor(), (String)"Return value descriptor should not be null");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForConstrainedMethod() {
        MethodDescriptor descriptor = Executables.parameterConstrainedMethod();
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters(), (String)"Should be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForCascadedMethod() {
        MethodDescriptor descriptor = Executables.cascadedParameterMethod();
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters(), (String)"Should be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForCrossParameterConstrainedMethod() {
        MethodDescriptor descriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters(), (String)"Should be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForNotConstrainedMethod() {
        MethodDescriptor descriptor = Executables.cascadedReturnValueMethod();
        Assert.assertFalse((boolean)descriptor.hasConstrainedParameters(), (String)"Should not be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForParameterlessMethod() {
        MethodDescriptor descriptor = Executables.returnValueConstrainedMethod();
        Assert.assertFalse((boolean)descriptor.hasConstrainedParameters(), (String)"Should not be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForConstrainedConstructor() {
        ConstructorDescriptor descriptor = Executables.parameterConstrainedConstructor();
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters(), (String)"Should be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForCascadedConstructor() {
        ConstructorDescriptor descriptor = Executables.cascadedParameterConstructor();
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters(), (String)"Should be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForCrossParameterConstrainedConstructor() {
        ConstructorDescriptor descriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertTrue((boolean)descriptor.hasConstrainedParameters(), (String)"Should be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForNotConstrainedConstructor() {
        ConstructorDescriptor descriptor = Executables.cascadedReturnValueConstructor();
        Assert.assertFalse((boolean)descriptor.hasConstrainedParameters(), (String)"Should not be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="e")
    public void testAreParametersConstrainedForParameterlessConstructor() {
        ConstructorDescriptor descriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertFalse((boolean)descriptor.hasConstrainedParameters(), (String)"Should not be constrained on parameters");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForConstrainedMethod() {
        MethodDescriptor descriptor = Executables.returnValueConstrainedMethod();
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForCascadedMethod() {
        MethodDescriptor descriptor = Executables.cascadedReturnValueMethod();
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForNotConstrainedMethod() {
        MethodDescriptor descriptor = Executables.cascadedParameterMethod();
        Assert.assertFalse((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should not be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForVoidMethod() {
        MethodDescriptor descriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertFalse((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should not be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForConstrainedConstructor() {
        ConstructorDescriptor descriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForCascadedConstructor() {
        ConstructorDescriptor descriptor = Executables.cascadedReturnValueConstructor();
        Assert.assertTrue((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="f")
    public void testIsReturnValueConstrainedForNotConstrainedConstructor() {
        ConstructorDescriptor descriptor = Executables.cascadedParameterConstructor();
        Assert.assertFalse((boolean)descriptor.hasConstrainedReturnValue(), (String)"Should not be constrained on return value");
    }

    @Test
    @SpecAssertion(section="6.7", id="g")
    public void testHasConstraintsForMethod() {
        MethodDescriptor parameterConstrainedDescriptor = Executables.parameterConstrainedMethod();
        Assert.assertFalse((boolean)parameterConstrainedDescriptor.hasConstraints(), (String)"Should have no constraints");
        MethodDescriptor returnValueConstrainedDescriptor = Executables.returnValueConstrainedMethod();
        Assert.assertFalse((boolean)returnValueConstrainedDescriptor.hasConstraints(), (String)"Should have no constraints");
        MethodDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertFalse((boolean)crossParameterConstrainedDescriptor.hasConstraints(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertion(section="6.7", id="g")
    public void testHasConstraintsForConstructor() {
        ConstructorDescriptor parameterConstrainedDescriptor = Executables.parameterConstrainedConstructor();
        Assert.assertFalse((boolean)parameterConstrainedDescriptor.hasConstraints(), (String)"Should have no constraints");
        ConstructorDescriptor returnValueConstrainedDescriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertFalse((boolean)returnValueConstrainedDescriptor.hasConstraints(), (String)"Should have no constraints");
        ConstructorDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertFalse((boolean)crossParameterConstrainedDescriptor.hasConstraints(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertion(section="6.7", id="g")
    public void testGetConstraintsForMethod() {
        MethodDescriptor parameterConstrainedDescriptor = Executables.parameterConstrainedMethod();
        Assert.assertTrue((boolean)parameterConstrainedDescriptor.getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        MethodDescriptor returnValueConstrainedDescriptor = Executables.returnValueConstrainedMethod();
        Assert.assertTrue((boolean)returnValueConstrainedDescriptor.getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        MethodDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertTrue((boolean)crossParameterConstrainedDescriptor.getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertion(section="6.7", id="g")
    public void testGetConstraintsForConstructor() {
        ConstructorDescriptor parameterConstrainedDescriptor = Executables.parameterConstrainedConstructor();
        Assert.assertTrue((boolean)parameterConstrainedDescriptor.getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        ConstructorDescriptor returnValueConstrainedDescriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertTrue((boolean)returnValueConstrainedDescriptor.getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        ConstructorDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertTrue((boolean)crossParameterConstrainedDescriptor.getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="d"), @SpecAssertion(section="6.7", id="g")})
    public void testFindConstraintsForMethod() {
        MethodDescriptor parameterConstrainedDescriptor = Executables.parameterConstrainedMethod();
        Assert.assertTrue((boolean)parameterConstrainedDescriptor.findConstraints().getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        MethodDescriptor returnValueConstrainedDescriptor = Executables.returnValueConstrainedMethod();
        Assert.assertTrue((boolean)returnValueConstrainedDescriptor.findConstraints().getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        MethodDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedMethod();
        Assert.assertTrue((boolean)crossParameterConstrainedDescriptor.findConstraints().getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="d"), @SpecAssertion(section="6.2", id="g"), @SpecAssertion(section="6.7", id="g")})
    public void testFindConstraintsForMethodLookingAt() {
        MethodDescriptor crossParameterConstrainedDescriptor = Executables.methodOverridingCrossParameterConstrainedMethod();
        Assert.assertEquals((int)crossParameterConstrainedDescriptor.findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors().size(), (int)0, (String)"Should have no local constraints");
        Assert.assertTrue((boolean)crossParameterConstrainedDescriptor.findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors().isEmpty(), (String)"Should have no hierarchy constraints");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="d"), @SpecAssertion(section="6.2", id="g"), @SpecAssertion(section="6.7", id="g")})
    public void testFindConstraintsForMethodDefinedOnSuperTypeLookingAt() {
        MethodDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedMethodFromSuperType();
        Assert.assertEquals((int)crossParameterConstrainedDescriptor.findConstraints().lookingAt(Scope.LOCAL_ELEMENT).getConstraintDescriptors().size(), (int)0, (String)"Should have no local constraints");
        Assert.assertTrue((boolean)crossParameterConstrainedDescriptor.findConstraints().lookingAt(Scope.HIERARCHY).getConstraintDescriptors().isEmpty(), (String)"Should have no hierarchy constraint");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="6.2", id="d"), @SpecAssertion(section="6.7", id="g")})
    public void testFindConstraintsForConstructor() {
        ConstructorDescriptor parameterConstrainedDescriptor = Executables.parameterConstrainedConstructor();
        Assert.assertTrue((boolean)parameterConstrainedDescriptor.findConstraints().getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        ConstructorDescriptor returnValueConstrainedDescriptor = Executables.returnValueConstrainedConstructor();
        Assert.assertTrue((boolean)returnValueConstrainedDescriptor.findConstraints().getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
        ConstructorDescriptor crossParameterConstrainedDescriptor = Executables.crossParameterConstrainedConstructor();
        Assert.assertTrue((boolean)crossParameterConstrainedDescriptor.findConstraints().getConstraintDescriptors().isEmpty(), (String)"Should have no constraints");
    }
}

