/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap.customprovider;

import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.beanvalidation.tck.common.TCKValidationProvider;
import org.hibernate.beanvalidation.tck.common.TCKValidatorConfiguration;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="2.0.0")
public class BootstrapCustomProviderDefinedInServiceFileTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BootstrapCustomProviderDefinedInServiceFileTest.class)).withClasses(TCKValidatorConfiguration.class, TCKValidationProvider.class)).withResource("javax.validation.spi.ValidationProvider", "META-INF/services/javax.validation.spi.ValidationProvider", true)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="a"), @SpecAssertion(section="5.5.3", id="k"), @SpecAssertion(section="5.5.4.2", id="a")})
    public void testGetFactoryByProviderSpecifiedProgrammatically() {
        TCKValidatorConfiguration configuration = (TCKValidatorConfiguration)Validation.byProvider(TCKValidationProvider.class).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5.3", id="k"), @SpecAssertion(section="5.5.4.1", id="a")})
    public void testProviderResolverReturnsListOfAvailableProviders() {
        TCKValidatorConfiguration configuration = (TCKValidatorConfiguration)Validation.byProvider(TCKValidationProvider.class).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
        Configuration config = Validation.byProvider(TestUtil.getValidationProviderUnderTest().getClass()).configure();
        factory = config.buildValidatorFactory();
        Assert.assertNotNull((Object)factory);
    }
}

