/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.beanvalidation.tck.common.TCKValidationProvider;
import org.hibernate.beanvalidation.tck.common.TCKValidatorConfiguration;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ValidationProviderTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidationProviderTest.class)).withClasses(TCKValidationProvider.class, TCKValidatorConfiguration.class)).build();
    }

    @Test
    @SpecAssertion(section="5.5.4.2", id="b")
    public void testFirstMatchingValidationProviderResolverIsReturned() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(TestUtil.getValidationProviderUnderTest());
                list.add(new TCKValidationProvider());
                return list;
            }
        };
        Configuration configuration = Validation.byProvider(TCKValidationProvider.class).providerResolver(resolver).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="5.5.4.2", id="c")
    public void testByDefaultProviderUsesTheFirstProviderReturnedByValidationProviderResolver() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                ArrayList list = new ArrayList();
                list.add(new TCKValidationProvider());
                list.add(TestUtil.getValidationProviderUnderTest());
                return list;
            }
        };
        Configuration configuration = Validation.byDefaultProvider().providerResolver(resolver).configure();
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertTrue((boolean)(factory instanceof TCKValidationProvider.DummyValidatorFactory));
    }

    @Test
    @SpecAssertion(section="5.5.4.2", id="d")
    public void testValidationProviderContainsNoArgConstructor() {
        ValidationProvider<?> validationProviderUnderTest = TestUtil.getValidationProviderUnderTest();
        try {
            Constructor<?> constructor = validationProviderUnderTest.getClass().getConstructor(new Class[0]);
            Assert.assertTrue((boolean)Modifier.isPublic(constructor.getModifiers()));
        }
        catch (Exception e) {
            FileAssert.fail((String)"The validation provider must have a public no arg constructor");
        }
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertions(value={@SpecAssertion(section="5.5.5", id="f"), @SpecAssertion(section="5.5.4.2", id="e")})
    public void testValidationExceptionIsThrownInCaseValidatorFactoryCreationFails() {
        ValidationProviderResolver resolver = new ValidationProviderResolver(){

            public List<ValidationProvider<?>> getValidationProviders() {
                throw new RuntimeException("ValidationProviderResolver failed!");
            }
        };
        Validation.byDefaultProvider().providerResolver(resolver).configure();
    }
}

