/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.inheritance;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.Bar;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.ValidBar;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.ValidFoo;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.ValidFubar;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ConstraintInheritanceTest
extends Arquillian {
    private Validator validator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConstraintInheritanceTest.class)).build();
    }

    @BeforeMethod
    public void setupValidator() {
        this.validator = TestUtil.getValidatorUnderTest();
    }

    @Test
    @SpecAssertion(section="4.3", id="b")
    public void testConstraintsOnSuperClassAreInherited() {
        String propertyName;
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "foo") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        Annotation constraintAnnotation = ((ConstraintDescriptor)propDescriptor.getConstraintDescriptors().iterator().next()).getAnnotation();
        Assert.assertTrue((constraintAnnotation.annotationType() == NotNull.class ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3", id="a"), @SpecAssertion(section="4.3", id="b")})
    public void testConstraintsOnInterfaceAreInherited() {
        String propertyName;
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "fubar") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        Annotation constraintAnnotation = ((ConstraintDescriptor)propDescriptor.getConstraintDescriptors().iterator().next()).getAnnotation();
        Assert.assertTrue((constraintAnnotation.annotationType() == NotNull.class ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3", id="a"), @SpecAssertion(section="4.3", id="c")})
    public void testConstraintsOnInterfaceAndImplementationAddUp() {
        String propertyName;
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "name") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        List<Class<? extends Annotation>> constraintTypes = this.getConstraintTypes(propDescriptor.getConstraintDescriptors());
        Assert.assertEquals((int)constraintTypes.size(), (int)2);
        Assert.assertTrue((boolean)constraintTypes.contains(DecimalMin.class));
        Assert.assertTrue((boolean)constraintTypes.contains(Size.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="4.3", id="a"), @SpecAssertion(section="4.3", id="c")})
    public void testConstraintsOnSuperAndSubClassAddUp() {
        String propertyName;
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "lastName") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        List<Class<? extends Annotation>> constraintTypes = this.getConstraintTypes(propDescriptor.getConstraintDescriptors());
        Assert.assertEquals((int)constraintTypes.size(), (int)2);
        Assert.assertTrue((boolean)constraintTypes.contains(DecimalMin.class));
        Assert.assertTrue((boolean)constraintTypes.contains(Size.class));
    }

    @Test
    @SpecAssertion(section="4.6", id="a")
    public void testValidationConsidersConstraintsFromSuperTypes() {
        Set violations = this.validator.validate((Object)new Bar(), new Class[0]);
        TestUtil.assertCorrectConstraintTypes(violations, DecimalMin.class, DecimalMin.class, ValidBar.class, NotNull.class, Size.class, ValidFoo.class, NotNull.class, Size.class, ValidFubar.class);
    }

    private List<Class<? extends Annotation>> getConstraintTypes(Iterable<ConstraintDescriptor<?>> descriptors) {
        ArrayList<Class<? extends Annotation>> constraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintDescriptor<?> constraintDescriptor : descriptors) {
            constraintTypes.add(constraintDescriptor.getAnnotation().annotationType());
        }
        return constraintTypes;
    }
}

