/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.testng.Assert;

public class PathUtil {
    public static PathExpectation pathWith() {
        return new PathExpectation();
    }

    public static void assertViolationsContainOnlyPaths(Set<? extends ConstraintViolation<?>> actualViolations, PathExpectation ... paths) {
        Assert.assertNotNull(actualViolations);
        Assert.assertNotNull((Object)paths);
        List<PathExpectation> expectedPaths = Arrays.asList(paths);
        ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
        for (ConstraintViolation<?> violation : actualViolations) {
            actualPaths.add(new PathExpectation(violation.getPropertyPath()));
        }
        ArrayList actualPathsTmp = new ArrayList(actualPaths);
        actualPathsTmp.removeAll(expectedPaths);
        if (!actualPathsTmp.isEmpty()) {
            Assert.fail((String)String.format("Found unexpected path(s): %s. Expected: %s", actualPathsTmp, expectedPaths));
        }
        ArrayList<PathExpectation> expectedPathsTmp = new ArrayList<PathExpectation>(expectedPaths);
        expectedPathsTmp.removeAll(actualPaths);
        if (!expectedPathsTmp.isEmpty()) {
            Assert.fail((String)String.format("Missing expected path(s) %s. Actual paths: %s", expectedPathsTmp, actualPaths));
        }
    }

    private static class NodeExpectation {
        private final String name;
        private final ElementKind kind;
        private final boolean inIterable;
        private final Object key;
        private final Integer index;
        private final Integer parameterIndex;

        private NodeExpectation(String name, ElementKind kind, boolean inIterable, Object key, Integer index, Integer parameterIndex) {
            this.name = name;
            this.kind = kind;
            this.inIterable = inIterable;
            this.key = key;
            this.index = index;
            this.parameterIndex = parameterIndex;
        }

        public String toString() {
            return "NodeExpectation(" + this.name + ", " + this.kind + ", " + this.inIterable + ", " + this.key + ", " + this.index + ", " + this.parameterIndex + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inIterable ? 1231 : 1237);
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeExpectation other = (NodeExpectation)obj;
            if (this.inIterable != other.inIterable) {
                return false;
            }
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex));
        }
    }

    public static class PathExpectation {
        private final List<NodeExpectation> nodes = new ArrayList<NodeExpectation>();

        private PathExpectation() {
        }

        private PathExpectation(Path propertyPath) {
            for (Path.Node node : propertyPath) {
                Integer parameterIndex = null;
                if (node.getKind() == ElementKind.PARAMETER) {
                    parameterIndex = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                }
                this.nodes.add(new NodeExpectation(node.getName(), node.getKind(), node.isInIterable(), node.getKey(), node.getIndex(), parameterIndex));
            }
        }

        public PathExpectation property(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, false, null, null, null));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null));
            return this;
        }

        public PathExpectation bean() {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, false, null, null, null));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null));
            return this;
        }

        public PathExpectation method(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.METHOD, false, null, null, null));
            return this;
        }

        public PathExpectation parameter(String name, int index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PARAMETER, false, null, null, index));
            return this;
        }

        public PathExpectation crossParameter() {
            this.nodes.add(new NodeExpectation("<cross-parameter>", ElementKind.CROSS_PARAMETER, false, null, null, null));
            return this;
        }

        public String toString() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder(lineBreak + "PathExpectation(" + lineBreak);
            for (NodeExpectation node : this.nodes) {
                asString.append("  ").append(node).append(lineBreak);
            }
            return asString.append(")").toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodes == null ? 0 : ((Object)this.nodes).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathExpectation other = (PathExpectation)obj;
            return !(this.nodes == null ? other.nodes != null : !((Object)this.nodes).equals(other.nodes));
        }
    }
}

