/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.BrokenCustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.CustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.parameternameprovider.User;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ParameterNameProviderTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ParameterNameProviderTest.class)).withClass(CustomParameterNameProvider.class)).withClass(BrokenCustomParameterNameProvider.class)).withClass(User.class)).build();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="Exception in ParameterNameProvider")
    @SpecAssertion(section="4.5.2.2", id="b")
    public void testExceptionInParameterNameProviderIsWrappedIntoValidationException() throws Throwable {
        Validator validator = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)new BrokenCustomParameterNameProvider()).buildValidatorFactory().getValidator();
        try {
            User object = new User();
            Method method = User.class.getMethod("setNames", String.class, String.class);
            Object[] parameters = new Object[]{null, null};
            validator.forExecutables().validateParameters((Object)object, method, parameters, new Class[0]);
            Assert.fail((String)"Expected exception wasn't thrown");
        }
        catch (ValidationException e) {
            throw e.getCause();
        }
    }

    @Test
    @SpecAssertion(section="5.5.2", id="e")
    public void testGetParameterNameProviderFromValidatorFactory() {
        BrokenCustomParameterNameProvider parameterNameProvider = new BrokenCustomParameterNameProvider();
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)parameterNameProvider).buildValidatorFactory();
        Assert.assertSame((Object)validatorFactory.getParameterNameProvider(), (Object)parameterNameProvider, (String)"getParameterNameProvider() should return the parameter name provider set via configuration");
    }

    @Test
    @SpecAssertion(section="5.5.2", id="g")
    public void testParameterNameProviderSetUsingContext() throws Exception {
        User object = new User();
        Method method = User.class.getMethod("setNames", String.class, String.class);
        Object[] parameters = new Object[]{null, null};
        ExecutableValidator executableValidator = TestUtil.getValidatorFactoryUnderTest().usingContext().parameterNameProvider((ParameterNameProvider)new CustomParameterNameProvider()).getValidator().forExecutables();
        Set constraintViolations = executableValidator.validateParameters((Object)object, method, parameters, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Set<String> actualParameterNames = TestUtil.getParameterNames(constraintViolations);
        Set<String> expectedParameterNames = TestUtil.asSet("param0", "param1");
        Assert.assertEquals(actualParameterNames, expectedParameterNames);
    }
}

