/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups.inheritance;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class GroupInheritanceTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(GroupInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="4.4.1", id="a")
    public void testGroupCanInheritGroupsViaInterfaceInheritance() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Part part = new Part();
        part.setPartNumber(123456);
        Set violations = validator.validate((Object)part, new Class[]{All.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 2);
        TestUtil.assertCorrectConstraintTypes(violations, Digits.class, AssertTrue.class);
        part.setPartNumber(12345);
        part.setQaChecked(true);
        violations = validator.validate((Object)part, new Class[]{All.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 0);
    }

    @Test
    @SpecAssertion(section="4.4.1", id="b")
    public void testGroupMembership() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor descriptor = validator.getConstraintsForClass(MiniaturePart.class);
        PropertyDescriptor propertyDescriptor = descriptor.getConstraintsForProperty("partNumber");
        Set descriptorsForGroup = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[]{All.class}).getConstraintDescriptors();
        Assert.assertEquals((int)descriptorsForGroup.size(), (int)1, (String)"Wrong number of descriptors");
        Assert.assertEquals(((ConstraintDescriptor)descriptorsForGroup.iterator().next()).getAnnotation().annotationType(), Digits.class);
        propertyDescriptor = descriptor.getConstraintsForProperty("qaChecked");
        descriptorsForGroup = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[]{All.class}).getConstraintDescriptors();
        Assert.assertEquals((int)descriptorsForGroup.size(), (int)1, (String)"Wrong number of descriptors");
        Assert.assertEquals(((ConstraintDescriptor)descriptorsForGroup.iterator().next()).getAnnotation().annotationType(), AssertTrue.class);
        propertyDescriptor = descriptor.getConstraintsForProperty("size");
        descriptorsForGroup = propertyDescriptor.findConstraints().unorderedAndMatchingGroups(new Class[]{All.class}).getConstraintDescriptors();
        Assert.assertEquals((int)descriptorsForGroup.size(), (int)1, (String)"Wrong number of descriptors");
        Assert.assertEquals(((ConstraintDescriptor)descriptorsForGroup.iterator().next()).getAnnotation().annotationType(), Max.class);
    }

    static interface All
    extends PreManufacturing,
    PostManufacturing {
    }

    static interface PostManufacturing {
    }

    static interface PreManufacturing {
    }

    class MiniaturePart
    extends Part {
        @Max(value=10L, groups={All.class})
        private int size;

        MiniaturePart() {
        }
    }

    class Part {
        @Digits(integer=5, fraction=0, groups={PreManufacturing.class})
        private int partNumber;
        @AssertTrue(groups={PostManufacturing.class})
        private boolean qaChecked;

        Part() {
        }

        public int getPartNumber() {
            return this.partNumber;
        }

        public void setPartNumber(int partNumber) {
            this.partNumber = partNumber;
        }

        public boolean getQaChecked() {
            return this.qaChecked;
        }

        public void setQaChecked(boolean qaChecked) {
            this.qaChecked = qaChecked;
        }
    }
}

