/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class BuiltinConstraintsTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BuiltinConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="c")})
    public void testNullConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NullDummyEntity dummy = new NullDummyEntity();
        Object foo = new Object();
        dummy.setProperty(foo);
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), NullDummyEntity.class, foo, "property");
        dummy.setProperty(null);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="d")})
    public void testNotNullConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NotNullDummyEntity dummy = new NotNullDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), NotNullDummyEntity.class, null, "property");
        dummy.setProperty(new Object());
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="e")})
    public void testAssertTrueConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        AssertTrueDummyEntity dummy = new AssertTrueDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertTrueDummyEntity.class, false, "primitiveBoolean");
        dummy.setPrimitiveBoolean(true);
        dummy.setObjectBoolean(Boolean.FALSE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertTrueDummyEntity.class, Boolean.FALSE, "objectBoolean");
        dummy.setObjectBoolean(Boolean.TRUE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="f")})
    public void testAssertFalseConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        AssertFalseDummyEntity dummy = new AssertFalseDummyEntity();
        dummy.setPrimitiveBoolean(true);
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertFalseDummyEntity.class, true, "primitiveBoolean");
        dummy.setPrimitiveBoolean(false);
        dummy.setObjectBoolean(Boolean.TRUE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), AssertFalseDummyEntity.class, Boolean.TRUE, "objectBoolean");
        dummy.setObjectBoolean(Boolean.FALSE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="g")})
    public void testMinConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        MinDummyEntity dummy = new MinDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.intObject = Integer.valueOf("100");
        dummy.longObject = Long.valueOf("0");
        dummy.byteObject = Byte.parseByte("-1");
        dummy.shortObject = Short.parseShort("3");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("102");
        dummy.shortObject = Short.parseShort("111");
        dummy.bigDecimal = BigDecimal.valueOf(101.1);
        dummy.bigInteger = BigInteger.valueOf(101L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="h")})
    public void testMaxConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        MaxDummyEntity dummy = new MaxDummyEntity();
        dummy.intPrimitive = 102;
        dummy.longPrimitive = 1234L;
        dummy.bytePrimitive = (byte)102;
        dummy.shortPrimitive = (short)102;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 100L;
        dummy.bytePrimitive = (byte)99;
        dummy.shortPrimitive = (short)42;
        dummy.intObject = Integer.valueOf("102");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("111");
        dummy.shortObject = Short.parseShort("1234");
        dummy.bigDecimal = BigDecimal.valueOf(102L);
        dummy.bigInteger = BigInteger.valueOf(102L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("100");
        dummy.byteObject = Byte.parseByte("100");
        dummy.shortObject = Short.parseShort("101");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="i")})
    public void testDecimalMinConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DecimalMinDummyEntity dummy = new DecimalMinDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.intObject = Integer.valueOf("100");
        dummy.longObject = Long.valueOf("0");
        dummy.byteObject = Byte.parseByte("-1");
        dummy.shortObject = Short.parseShort("3");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("102");
        dummy.shortObject = Short.parseShort("111");
        dummy.bigDecimal = BigDecimal.valueOf(101.1);
        dummy.bigInteger = BigInteger.valueOf(101L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="j")})
    public void testDecimalMaxConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DecimalMaxDummyEntity dummy = new DecimalMaxDummyEntity();
        dummy.intPrimitive = 102;
        dummy.longPrimitive = 1234L;
        dummy.bytePrimitive = (byte)102;
        dummy.shortPrimitive = (short)102;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 100L;
        dummy.bytePrimitive = (byte)99;
        dummy.shortPrimitive = (short)42;
        dummy.intObject = Integer.valueOf("102");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("111");
        dummy.shortObject = Short.parseShort("1234");
        dummy.bigDecimal = BigDecimal.valueOf(102L);
        dummy.bigInteger = BigInteger.valueOf(102L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("101");
        dummy.longObject = Long.valueOf("100");
        dummy.byteObject = Byte.parseByte("100");
        dummy.shortObject = Short.parseShort("101");
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="k")})
    public void testSizeConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        SizeDummyEntity dummy = new SizeDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        dummy.collection = new HashSet<String>();
        dummy.collection.add("foo");
        dummy.collection.add("bar");
        dummy.string = "";
        dummy.map = new HashMap<String, String>();
        dummy.map.put("key1", "value1");
        dummy.map.put("key2", "value2");
        dummy.integerArray = new Integer[0];
        dummy.intArray = new int[0];
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 5);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "collection", "map", "string", "integerArray", "intArray");
        dummy.collection.remove("bar");
        dummy.string = "a";
        dummy.integerArray = new Integer[1];
        dummy.intArray = new int[1];
        dummy.map.remove("key1");
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="l")})
    public void testDigitsConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DigitsDummyEntity dummy = new DigitsDummyEntity();
        dummy.intPrimitive = 42;
        dummy.longPrimitive = 42L;
        dummy.bytePrimitive = (byte)42;
        dummy.shortPrimitive = (short)42;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 4);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "bytePrimitive", "intPrimitive", "longPrimitive", "shortPrimitive");
        dummy.intPrimitive = 1;
        dummy.longPrimitive = 1L;
        dummy.bytePrimitive = 1;
        dummy.shortPrimitive = 1;
        dummy.intObject = Integer.valueOf("102");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("111");
        dummy.shortObject = Short.parseShort("1234");
        dummy.bigDecimal = BigDecimal.valueOf(102L);
        dummy.bigInteger = BigInteger.valueOf(102L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 6);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "byteObject", "intObject", "longObject", "shortObject", "bigDecimal", "bigInteger");
        dummy.intObject = Integer.valueOf("1");
        dummy.longObject = Long.valueOf("1");
        dummy.byteObject = Byte.parseByte("1");
        dummy.shortObject = Short.parseShort("1");
        dummy.bigDecimal = BigDecimal.valueOf(1.93);
        dummy.bigInteger = BigInteger.valueOf(5L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="m")})
    public void testPastConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PastDummyEntity dummy = new PastDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        Calendar cal = GregorianCalendar.getInstance();
        cal.add(1, 1);
        dummy.calendar = cal;
        dummy.date = cal.getTime();
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "date", "calendar");
        cal.add(1, -2);
        dummy.calendar = cal;
        dummy.date = cal.getTime();
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="n")})
    public void testFutureConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        FutureDummyEntity dummy = new FutureDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        Calendar cal = GregorianCalendar.getInstance();
        cal.add(1, -1);
        dummy.calendar = cal;
        dummy.date = cal.getTime();
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "date", "calendar");
        cal.add(1, 2);
        dummy.calendar = cal;
        dummy.date = cal.getTime();
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7", id="a"), @SpecAssertion(section="7", id="o")})
    public void testPatternConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PatternDummyEntity dummy = new PatternDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        dummy.pattern = "ab cd";
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertConstraintViolation((ConstraintViolation)constraintViolations.iterator().next(), PatternDummyEntity.class, "ab cd", "pattern");
        dummy.pattern = "wc 00";
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
    }

    class PatternDummyEntity {
        @Pattern(regexp="[a-z][a-z] \\d\\d")
        String pattern;

        PatternDummyEntity() {
        }
    }

    class FutureDummyEntity {
        @Future
        Calendar calendar;
        @Future
        Date date;

        FutureDummyEntity() {
        }
    }

    class PastDummyEntity {
        @Past
        Calendar calendar;
        @Past
        Date date;

        PastDummyEntity() {
        }
    }

    class DigitsDummyEntity {
        @Digits(integer=1, fraction=2)
        BigDecimal bigDecimal;
        @Digits(integer=1, fraction=0)
        BigInteger bigInteger;
        @Digits(integer=1, fraction=0)
        byte bytePrimitive;
        @Digits(integer=1, fraction=0)
        short shortPrimitive;
        @Digits(integer=1, fraction=0)
        int intPrimitive;
        @Digits(integer=1, fraction=0)
        long longPrimitive;
        @Digits(integer=1, fraction=0)
        Byte byteObject;
        @Digits(integer=1, fraction=0)
        Short shortObject;
        @Digits(integer=1, fraction=0)
        Integer intObject;
        @Digits(integer=1, fraction=0)
        Long longObject;

        DigitsDummyEntity() {
        }
    }

    class SizeDummyEntity {
        @Size(min=1, max=1)
        String string;
        @Size(min=1, max=1)
        Collection<String> collection;
        @Size(min=1, max=1)
        Map<String, String> map;
        @Size(min=1, max=1)
        Integer[] integerArray;
        @Size(min=1, max=1)
        int[] intArray;

        SizeDummyEntity() {
        }
    }

    class DecimalMinDummyEntity {
        @DecimalMin(value="101.000000000")
        BigDecimal bigDecimal;
        @DecimalMin(value="1.01E+2")
        BigInteger bigInteger;
        @DecimalMin(value="101")
        byte bytePrimitive;
        @DecimalMin(value="101")
        short shortPrimitive;
        @DecimalMin(value="101")
        int intPrimitive;
        @DecimalMin(value="101")
        long longPrimitive;
        @DecimalMin(value="101")
        Byte byteObject;
        @DecimalMin(value="101")
        Short shortObject;
        @DecimalMin(value="101")
        Integer intObject;
        @DecimalMin(value="101")
        Long longObject;

        DecimalMinDummyEntity() {
        }
    }

    class DecimalMaxDummyEntity {
        @DecimalMax(value="101.000000000")
        BigDecimal bigDecimal;
        @DecimalMax(value="1.01E+2")
        BigInteger bigInteger;
        @DecimalMax(value="101")
        byte bytePrimitive;
        @DecimalMax(value="101")
        short shortPrimitive;
        @DecimalMax(value="101")
        int intPrimitive;
        @DecimalMax(value="101")
        long longPrimitive;
        @DecimalMax(value="101")
        Byte byteObject;
        @DecimalMax(value="101")
        Short shortObject;
        @DecimalMax(value="101")
        Integer intObject;
        @DecimalMax(value="101")
        Long longObject;

        DecimalMaxDummyEntity() {
        }
    }

    class MaxDummyEntity {
        @Max(value=101L)
        BigDecimal bigDecimal;
        @Max(value=101L)
        BigInteger bigInteger;
        @Max(value=101L)
        byte bytePrimitive;
        @Max(value=101L)
        short shortPrimitive;
        @Max(value=101L)
        int intPrimitive;
        @Max(value=101L)
        long longPrimitive;
        @Max(value=101L)
        Byte byteObject;
        @Max(value=101L)
        Short shortObject;
        @Max(value=101L)
        Integer intObject;
        @Max(value=101L)
        Long longObject;

        MaxDummyEntity() {
        }
    }

    class MinDummyEntity {
        @Min(value=101L)
        BigDecimal bigDecimal;
        @Min(value=101L)
        BigInteger bigInteger;
        @Min(value=101L)
        byte bytePrimitive;
        @Min(value=101L)
        short shortPrimitive;
        @Min(value=101L)
        int intPrimitive;
        @Min(value=101L)
        long longPrimitive;
        @Min(value=101L)
        Byte byteObject;
        @Min(value=101L)
        Short shortObject;
        @Min(value=101L)
        Integer intObject;
        @Min(value=101L)
        Long longObject;

        MinDummyEntity() {
        }
    }

    class AssertFalseDummyEntity {
        @AssertFalse
        boolean primitiveBoolean;
        @AssertFalse
        Boolean objectBoolean;

        AssertFalseDummyEntity() {
        }

        public boolean isPrimitiveBoolean() {
            return this.primitiveBoolean;
        }

        public void setPrimitiveBoolean(boolean primitiveBoolean) {
            this.primitiveBoolean = primitiveBoolean;
        }

        public Boolean isObjectBoolean() {
            return this.objectBoolean;
        }

        public void setObjectBoolean(Boolean objectBoolean) {
            this.objectBoolean = objectBoolean;
        }
    }

    class AssertTrueDummyEntity {
        @AssertTrue
        boolean primitiveBoolean;
        @AssertTrue
        Boolean objectBoolean;

        AssertTrueDummyEntity() {
        }

        public boolean isPrimitiveBoolean() {
            return this.primitiveBoolean;
        }

        public void setPrimitiveBoolean(boolean primitiveBoolean) {
            this.primitiveBoolean = primitiveBoolean;
        }

        public Boolean isObjectBoolean() {
            return this.objectBoolean;
        }

        public void setObjectBoolean(Boolean objectBoolean) {
            this.objectBoolean = objectBoolean;
        }
    }

    class NotNullDummyEntity {
        @NotNull
        Object property;

        NotNullDummyEntity() {
        }

        public Object getProperty() {
            return this.property;
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }

    class NullDummyEntity {
        @Null
        Object property;

        NullDummyEntity() {
        }

        public Object getProperty() {
            return this.property;
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }
}

