/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.validation.Address;
import org.hibernate.beanvalidation.tck.tests.validation.NotEmpty;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ValidateWithGroupsTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ValidateWithGroupsTest.class)).withClasses(Address.class, NotEmpty.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.3", id="a"), @SpecAssertion(section="5.1.3", id="b")})
    public void testCorrectGroupsAreAppliedForValidate() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)new Address(), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class, NotEmpty.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city", "zipCode");
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Default.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class, NotEmpty.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city", "zipCode");
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Address.Minimal.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class, NotEmpty.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "street", "zipCode");
        constraintViolations = validator.validate((Object)new Address(), new Class[]{Default.class, Address.Minimal.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 3);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class, NotEmpty.class, NotEmpty.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city", "street", "zipCode");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.3", id="a"), @SpecAssertion(section="5.1.3", id="b")})
    public void testCorrectGroupsAreAppliedForValidateProperty() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city");
        constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[]{Default.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city");
        constraintViolations = validator.validateProperty((Object)new Address(), "city", new Class[]{Address.Minimal.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validateProperty((Object)new Address(), "street", new Class[]{Address.Minimal.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "street");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.1.3", id="a"), @SpecAssertion(section="5.1.3", id="b")})
    public void testCorrectGroupsAreAppliedForValidateValue() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validateValue(Address.class, "city", null, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city");
        constraintViolations = validator.validateValue(Address.class, "city", null, new Class[]{Default.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotNull.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "city");
        constraintViolations = validator.validateValue(Address.class, "city", null, new Class[]{Address.Minimal.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 0);
        constraintViolations = validator.validateValue(Address.class, "street", null, new Class[]{Address.Minimal.class});
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        TestUtil.assertCorrectConstraintTypes(constraintViolations, NotEmpty.class);
        TestUtil.assertCorrectPropertyPaths(constraintViolations, "street");
    }
}

