/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.beanvalidation.tck.tests.validation.Actor;
import org.hibernate.beanvalidation.tck.tests.validation.ActorArrayBased;
import org.hibernate.beanvalidation.tck.tests.validation.ActorCollectionBased;
import org.hibernate.beanvalidation.tck.tests.validation.ActorLikesGenre;
import org.hibernate.beanvalidation.tck.tests.validation.ActorListBased;
import org.hibernate.beanvalidation.tck.tests.validation.CustomParameterNameProvider;
import org.hibernate.beanvalidation.tck.tests.validation.Customer;
import org.hibernate.beanvalidation.tck.tests.validation.Employee;
import org.hibernate.beanvalidation.tck.tests.validation.Engine;
import org.hibernate.beanvalidation.tck.tests.validation.Movie;
import org.hibernate.beanvalidation.tck.tests.validation.MovieStudio;
import org.hibernate.beanvalidation.tck.tests.validation.Order;
import org.hibernate.beanvalidation.tck.tests.validation.Person;
import org.hibernate.beanvalidation.tck.tests.validation.PlayedWith;
import org.hibernate.beanvalidation.tck.tests.validation.ValidMovieStudio;
import org.hibernate.beanvalidation.tck.tests.validation.ValidMovieStudioValidator;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class PropertyPathTest
extends Arquillian {
    private Validator validator;
    private ExecutableValidator executableValidator;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(PropertyPathTest.class)).withClasses(Actor.class, ActorArrayBased.class, ActorCollectionBased.class, ActorLikesGenre.class, ActorListBased.class, PlayedWith.class, Person.class, VerySpecialClass.class, Customer.class, Engine.class, Order.class, Employee.class, Movie.class, MovieStudio.class, CustomParameterNameProvider.class, ValidMovieStudio.class, ValidMovieStudioValidator.class)).build();
    }

    @BeforeMethod
    public void setupValidators() {
        this.validator = TestUtil.getValidatorUnderTest();
        this.executableValidator = this.validator.forExecutables();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="r"), @SpecAssertion(section="5.2", id="v"), @SpecAssertion(section="5.2", id="ab")})
    public void testPropertyPathWithConstraintViolationForRootObject() {
        Set constraintViolations = this.validator.validate((Object)new VerySpecialClass(), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        this.assertNode(node, TestUtil.BEAN_NODE_NAME, ElementKind.BEAN, false, null, null);
        Path.BeanNode beanNode = (Path.BeanNode)node.as(Path.BeanNode.class);
        Assert.assertNotNull((Object)beanNode);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="r"), @SpecAssertion(section="5.2", id="w"), @SpecAssertion(section="5.2", id="aa")})
    public void testPropertyPathTraversedObject() {
        Engine engine = new Engine();
        engine.setSerialNumber("ABCDEFGH1234");
        Set constraintViolations = this.validator.validate((Object)engine, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        this.assertNode(node, "serialNumber", ElementKind.PROPERTY, false, null, null);
        Path.PropertyNode propertyNode = (Path.PropertyNode)node.as(Path.PropertyNode.class);
        Assert.assertNotNull((Object)propertyNode);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="x"), @SpecAssertion(section="5.2", id="z")})
    public void testPropertyPathWithList() {
        ActorListBased clint = new ActorListBased("Clint", "Eastwood");
        ActorListBased morgan = new ActorListBased("Morgan", null);
        ActorListBased charlie = new ActorListBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = this.validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="x"), @SpecAssertion(section="5.2", id="z")})
    public void testPropertyPathWithArray() {
        ActorArrayBased clint = new ActorArrayBased("Clint", "Eastwood");
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        ActorArrayBased charlie = new ActorArrayBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = this.validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="u"), @SpecAssertion(section="5.2", id="x"), @SpecAssertion(section="5.2", id="z")})
    public void testPropertyPathWithRuntimeTypeList() {
        ActorCollectionBased clint = new ActorCollectionBased("Clint", "Eastwood");
        ActorCollectionBased morgan = new ActorCollectionBased("Morgan", null);
        ActorCollectionBased charlie = new ActorCollectionBased("Charlie", "Sheen");
        clint.addPlayedWith(charlie);
        charlie.addPlayedWith(clint);
        charlie.addPlayedWith(morgan);
        morgan.addPlayedWith(charlie);
        Set constraintViolations = this.validator.validate((Object)clint, new Class[0]);
        this.checkActorViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="y"), @SpecAssertion(section="5.2", id="z")})
    public void testPropertyPathWithMap() {
        ActorDB db = new ActorDB();
        ActorArrayBased morgan = new ActorArrayBased("Morgan", null);
        Integer id = db.addActor(morgan);
        Set constraintViolations = this.validator.validate((Object)db, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "actors", ElementKind.PROPERTY, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, null, id);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="z")})
    public void testPropertyPathSet() {
        Customer customer = new Customer();
        customer.setFirstName("John");
        customer.setLastName("Doe");
        Order order = new Order();
        customer.addOrder(order);
        Set constraintViolations = this.validator.validate((Object)customer, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "orders", ElementKind.PROPERTY, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "orderNumber", ElementKind.PROPERTY, true, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="r"), @SpecAssertion(section="5.2", id="s"), @SpecAssertion(section="5.2", id="t"), @SpecAssertion(section="5.2", id="ac"), @SpecAssertion(section="5.2", id="ad"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForMethodParameterConstraint() throws Exception {
        String methodName = "makeMovie";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, List.class);
        Object[] parameterValues = new Object[]{null, null, null};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Iterator nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "arg0").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, methodName, ElementKind.METHOD, false, null, null);
        Path.MethodNode methodNode = (Path.MethodNode)nextNode.as(Path.MethodNode.class);
        Assert.assertNotNull((Object)methodNode);
        Assert.assertEquals((Collection)methodNode.getParameterTypes(), Arrays.asList(String.class, Person.class, List.class));
        Assert.assertTrue((boolean)nodeIter.hasNext());
        nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "arg0", ElementKind.PARAMETER, false, null, null);
        Path.ParameterNode parameterNode = (Path.ParameterNode)nextNode.as(Path.ParameterNode.class);
        Assert.assertNotNull((Object)parameterNode);
        Assert.assertEquals((int)parameterNode.getParameterIndex(), (int)0);
        Assert.assertFalse((boolean)nodeIter.hasNext());
        nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "arg1").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "arg1", ElementKind.PARAMETER, false, null, null);
        parameterNode = (Path.ParameterNode)nextNode.as(Path.ParameterNode.class);
        Assert.assertNotNull((Object)parameterNode);
        Assert.assertEquals((int)parameterNode.getParameterIndex(), (int)1);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="ad"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForMethodParameterConstraintWithCustomParameterNameProvider() throws Exception {
        String methodName = "makeMovie";
        ExecutableValidator executableValidator = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)new CustomParameterNameProvider()).buildValidatorFactory().getValidator().forExecutables();
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, List.class);
        Object[] parameterValues = new Object[]{null, null, null};
        Set constraintViolations = executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Iterator nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "param0").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "param0", ElementKind.PARAMETER, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
        nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "param1").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "param1", ElementKind.PARAMETER, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="r"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="ac"), @SpecAssertion(section="5.2", id="af"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForMethodReturnValueConstraint() throws Exception {
        String methodName = "makeMovie";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, List.class);
        Object returnValue = null;
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Path.ReturnValueNode returnValueNode = (Path.ReturnValueNode)nextNode.as(Path.ReturnValueNode.class);
        Assert.assertNotNull((Object)returnValueNode);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="ac"), @SpecAssertion(section="5.2", id="ae"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForMethodCrossParameterConstraint() throws Exception {
        String methodName = "makeMovie";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, Actor.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<cross-parameter>", ElementKind.CROSS_PARAMETER, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="r"), @SpecAssertion(section="5.2", id="s"), @SpecAssertion(section="5.2", id="t"), @SpecAssertion(section="5.2", id="ac"), @SpecAssertion(section="5.2", id="ad"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForConstructorParameterConstraint() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class);
        Object[] parameterValues = new Object[]{null, null};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Iterator nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "arg0").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Path.ConstructorNode constructorNode = (Path.ConstructorNode)nextNode.as(Path.ConstructorNode.class);
        Assert.assertNotNull((Object)constructorNode);
        Assert.assertEquals((Collection)constructorNode.getParameterTypes(), Arrays.asList(String.class, Person.class));
        Assert.assertTrue((boolean)nodeIter.hasNext());
        nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "arg0", ElementKind.PARAMETER, false, null, null);
        Path.ParameterNode parameterNode = (Path.ParameterNode)nextNode.as(Path.ParameterNode.class);
        Assert.assertNotNull((Object)parameterNode);
        Assert.assertEquals((int)parameterNode.getParameterIndex(), (int)0);
        Assert.assertFalse((boolean)nodeIter.hasNext());
        nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "arg1").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "arg1", ElementKind.PARAMETER, false, null, null);
        parameterNode = (Path.ParameterNode)nextNode.as(Path.ParameterNode.class);
        Assert.assertNotNull((Object)parameterNode);
        Assert.assertEquals((int)parameterNode.getParameterIndex(), (int)1);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="ad"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForConstructorParameterConstraintWithCustomParameterNameProvider() throws Exception {
        ExecutableValidator executableValidator = TestUtil.getConfigurationUnderTest().parameterNameProvider((ParameterNameProvider)new CustomParameterNameProvider()).buildValidatorFactory().getValidator().forExecutables();
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class);
        Object[] parameterValues = new Object[]{null, null};
        Set constraintViolations = executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Iterator nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "param0").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "param0", ElementKind.PARAMETER, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
        nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "param1").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "param1", ElementKind.PARAMETER, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="r"), @SpecAssertion(section="5.2", id="ac"), @SpecAssertion(section="5.2", id="ae"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForConstructorCrossParameterConstraint() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(Actor.class, String.class);
        Object[] parameterValues = new Object[]{null, null};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "<cross-parameter>", ElementKind.CROSS_PARAMETER, false, null, null);
        Path.CrossParameterNode crossParameterNode = (Path.CrossParameterNode)nextNode.as(Path.CrossParameterNode.class);
        Assert.assertNotNull((Object)crossParameterNode);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="r"), @SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="ac"), @SpecAssertion(section="5.2", id="af"), @SpecAssertion(section="5.2", id="ag")})
    public void testPropertyPathForConstructorReturnValueConstraint() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class);
        MovieStudio returnValue = new MovieStudio(null);
        Set constraintViolations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai")})
    public void testPropertyPathTraversingMethodParameter() throws Exception {
        String methodName = "makeMovie";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, List.class);
        Object[] parameterValues = new Object[]{this.validFilmTitle(), this.employWithoutFirstName(), null};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg1", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "firstName", ElementKind.PROPERTY, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="ak"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodListParameter() throws Exception {
        String methodName = "makeMovie";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, List.class);
        Object[] parameterValues = new Object[]{this.validFilmTitle(), this.validEmployee(), Arrays.asList(this.validActor(), this.actorWithoutLastName())};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="ak"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodArrayParameter() throws Exception {
        String methodName = "makeMovieArrayBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, Actor[].class);
        Object[] parameterValues = new Object[]{this.validFilmTitle(), this.validEmployee(), new Actor[]{this.validActor(), this.actorWithoutLastName()}};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodSetParameter() throws Exception {
        String methodName = "makeMovieSetBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, Set.class);
        Object[] parameterValues = new Object[]{this.validFilmTitle(), this.validEmployee(), TestUtil.asSet(this.validActor(), this.actorWithoutLastName())};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="al"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodMapParameter() throws Exception {
        String methodName = "makeMovieMapBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, String.class, Person.class, Map.class);
        HashMap<String, ActorListBased> actors = new HashMap<String, ActorListBased>();
        actors.put("Glen", this.validActor());
        actors.put("Garry", this.actorWithoutLastName());
        Object[] parameterValues = new Object[]{this.validFilmTitle(), this.validEmployee(), actors};
        Set constraintViolations = this.executableValidator.validateParameters((Object)object, method, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, null, "Garry");
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai")})
    public void testPropertyPathTraversingConstructorParameter() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class);
        Object[] parameterValues = new Object[]{this.validStudioName(), this.employWithoutFirstName()};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg1", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "firstName", ElementKind.PROPERTY, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="ak"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingConstructorListParameter() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class, List.class);
        Object[] parameterValues = new Object[]{this.validStudioName(), this.validEmployee(), Arrays.asList(this.validActor(), this.actorWithoutLastName())};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="ak"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingConstructorArrayParameter() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class, Actor[].class);
        Object[] parameterValues = new Object[]{this.validStudioName(), this.validEmployee(), new Actor[]{this.validActor(), this.actorWithoutLastName()}};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingConstructorSetParameter() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class, Set.class);
        Object[] parameterValues = new Object[]{this.validStudioName(), this.validEmployee(), TestUtil.asSet(this.validActor(), this.actorWithoutLastName())};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="ai"), @SpecAssertion(section="5.2", id="al"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingConstructorMapParameter() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class, Map.class);
        HashMap<String, ActorListBased> actors = new HashMap<String, ActorListBased>();
        actors.put("Glen", this.validActor());
        actors.put("Garry", this.actorWithoutLastName());
        Object[] parameterValues = new Object[]{this.validStudioName(), this.validEmployee(), actors};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "arg2", ElementKind.PARAMETER, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, null, "Garry");
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="aj")})
    public void testPropertyPathTraversingMethodReturnValue() throws Exception {
        String methodName = "getBestSellingMovie";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, new Class[0]);
        Movie returnValue = new Movie();
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "title", ElementKind.PROPERTY, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="aj"), @SpecAssertion(section="5.2", id="ak"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodListReturnValue() throws Exception {
        String methodName = "getBestSellingMoviesListBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, new Class[0]);
        List<Movie> returnValue = Arrays.asList(new Movie(this.validFilmTitle()), new Movie());
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "title", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="aj"), @SpecAssertion(section="5.2", id="ak"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodArrayReturnValue() throws Exception {
        String methodName = "getBestSellingMoviesArrayBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, new Class[0]);
        Movie[] returnValue = new Movie[]{new Movie(this.validFilmTitle()), new Movie()};
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "title", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="aj"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodSetReturnValue() throws Exception {
        String methodName = "getBestSellingMoviesSetBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, new Class[0]);
        Set<Movie> returnValue = TestUtil.asSet(new Movie(this.validFilmTitle()), new Movie());
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "title", ElementKind.PROPERTY, true, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="aj"), @SpecAssertion(section="5.2", id="al"), @SpecAssertion(section="5.2", id="am")})
    public void testPropertyPathTraversingMethodMapReturnValue() throws Exception {
        String methodName = "getBestSellingMoviesMapBased";
        MovieStudio object = new MovieStudio();
        Method method = MovieStudio.class.getMethod(methodName, new Class[0]);
        HashMap<String, Movie> returnValue = new HashMap<String, Movie>();
        returnValue.put("BVDC", new Movie(this.validFilmTitle()));
        returnValue.put("NO_TITLE", new Movie());
        Set constraintViolations = this.executableValidator.validateReturnValue((Object)object, method, returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), methodName, ElementKind.METHOD, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "title", ElementKind.PROPERTY, true, null, "NO_TITLE");
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.2", id="l"), @SpecAssertion(section="5.2", id="m"), @SpecAssertion(section="5.2", id="n"), @SpecAssertion(section="5.2", id="o"), @SpecAssertion(section="5.2", id="p"), @SpecAssertion(section="5.2", id="q"), @SpecAssertion(section="5.2", id="aa"), @SpecAssertion(section="5.2", id="ah"), @SpecAssertion(section="5.2", id="aj")})
    public void testPropertyPathTraversingConstructorReturnValue() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class);
        MovieStudio returnValue = new MovieStudio(null);
        Set constraintViolations = this.executableValidator.validateConstructorReturnValue(constructor, (Object)returnValue, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        Iterator nodeIter = ((ConstraintViolation)constraintViolations.iterator().next()).getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "<return value>", ElementKind.RETURN_VALUE, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "name", ElementKind.PROPERTY, false, null, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    @Test(expectedExceptions={ClassCastException.class})
    @SpecAssertion(section="5.2", id="r")
    public void testPassingWrongTypeToAsOnBeanNodeCausesClassCastException() {
        Set constraintViolations = this.validator.validate((Object)new VerySpecialClass(), new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node node = (Path.Node)nodeIter.next();
        this.assertNode(node, TestUtil.BEAN_NODE_NAME, ElementKind.BEAN, false, null, null);
        node.as(Path.PropertyNode.class);
    }

    @Test(expectedExceptions={ClassCastException.class})
    @SpecAssertion(section="5.2", id="r")
    public void testPassingWrongTypeToAsOnConstructorNodeCausesClassCastException() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class);
        Object[] parameterValues = new Object[]{null, null};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Iterator nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "arg0").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        nextNode.as(Path.PropertyNode.class);
    }

    @Test(expectedExceptions={ClassCastException.class})
    @SpecAssertion(section="5.2", id="r")
    public void testPassingWrongTypeToAsOnParameterNodeCausesClassCastException() throws Exception {
        Constructor constructor = MovieStudio.class.getConstructor(String.class, Person.class);
        Object[] parameterValues = new Object[]{null, null};
        Set constraintViolations = this.executableValidator.validateConstructorParameters(constructor, parameterValues, new Class[0]);
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 2);
        Iterator nodeIter = TestUtil.getConstraintViolationForParameter(constraintViolations, "arg0").getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        Path.Node nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "MovieStudio", ElementKind.CONSTRUCTOR, false, null, null);
        Path.ConstructorNode constructorNode = (Path.ConstructorNode)nextNode.as(Path.ConstructorNode.class);
        Assert.assertNotNull((Object)constructorNode);
        Assert.assertEquals((Collection)constructorNode.getParameterTypes(), Arrays.asList(String.class, Person.class));
        Assert.assertTrue((boolean)nodeIter.hasNext());
        nextNode = (Path.Node)nodeIter.next();
        this.assertNode(nextNode, "arg0", ElementKind.PARAMETER, false, null, null);
        nextNode.as(Path.BeanNode.class);
    }

    private void checkActorViolations(Set<ConstraintViolation<Actor>> constraintViolations) {
        TestUtil.assertCorrectNumberOfViolations(constraintViolations, 1);
        ConstraintViolation constraintViolation = constraintViolations.iterator().next();
        Iterator nodeIter = constraintViolation.getPropertyPath().iterator();
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "playedWith", ElementKind.PROPERTY, false, null, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "playedWith", ElementKind.PROPERTY, true, 0, null);
        Assert.assertTrue((boolean)nodeIter.hasNext());
        this.assertNode((Path.Node)nodeIter.next(), "lastName", ElementKind.PROPERTY, true, 1, null);
        Assert.assertFalse((boolean)nodeIter.hasNext());
    }

    private void assertNode(Path.Node actualNode, String expectedName, ElementKind expectedKind, boolean expectedInIterable, Integer expectedIndex, Object expectedKey) {
        Assert.assertEquals((String)actualNode.getName(), (String)expectedName);
        Assert.assertEquals((Object)actualNode.getKind(), (Object)expectedKind);
        Assert.assertEquals((boolean)actualNode.isInIterable(), (boolean)expectedInIterable);
        Assert.assertEquals((Object)actualNode.getIndex(), (Object)expectedIndex);
        Assert.assertEquals((Object)actualNode.getKey(), (Object)expectedKey);
    }

    private Employee employWithoutFirstName() {
        return new Employee(null, "Hotchcick");
    }

    private Employee validEmployee() {
        return new Employee("Albert", "Hotchcick");
    }

    private ActorListBased actorWithoutLastName() {
        return new ActorListBased("Garry", null);
    }

    private ActorListBased validActor() {
        return new ActorListBased("Glen", "Closed");
    }

    private String validFilmTitle() {
        return "Bean Validation - Director's Cut";
    }

    private String validStudioName() {
        return "AcmeStudios";
    }

    class ActorDB {
        private int idGen = 0;
        @Valid
        Map<Integer, Actor> actors = new HashMap<Integer, Actor>();

        ActorDB() {
        }

        public Integer addActor(Actor actor) {
            Integer id = this.idGen++;
            this.actors.put(id, actor);
            return id;
        }
    }

    public static class SpecialValidator
    implements ConstraintValidator<Special, VerySpecialClass> {
        public void initialize(Special constraintAnnotation) {
        }

        public boolean isValid(VerySpecialClass clazz, ConstraintValidatorContext constraintValidatorContext) {
            return false;
        }
    }

    @Constraint(validatedBy={SpecialValidator.class})
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Special {
        public String message() default "special validation failed";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    @Special
    class VerySpecialClass {
        VerySpecialClass() {
        }
    }
}

