/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint;

import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import org.hibernate.beanvalidation.tck.tests.methodvalidation.constraint.MyCrossParameterConstraint;
import org.testng.Assert;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class MyCrossParameterConstraintValidator
implements ConstraintValidator<MyCrossParameterConstraint, Object[]> {
    private int expectedMaxInvocationCount;
    private AtomicInteger actualInvocationCount;

    public void initialize(MyCrossParameterConstraint constraintAnnotation) {
        this.expectedMaxInvocationCount = constraintAnnotation.expectedMaxInvocationCount();
        this.actualInvocationCount = new AtomicInteger();
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        int invocationCount = this.actualInvocationCount.incrementAndGet();
        if (invocationCount > this.expectedMaxInvocationCount) {
            Assert.fail((String)String.format("Constraint validator was expected to be invoked only %s times but was invoked %s times.", this.expectedMaxInvocationCount, this.actualInvocationCount));
        }
        return false;
    }
}

